/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.LinearImageHeapPartition;
import com.oracle.svm.core.image.AbstractImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;

public class LinearImageHeapLayouter
extends AbstractImageHeapLayouter<LinearImageHeapPartition> {
    private final ImageHeapInfo heapInfo;
    private boolean compressedNullPadding;

    public LinearImageHeapLayouter(ImageHeapInfo heapInfo, boolean compressedNullPadding) {
        this.heapInfo = heapInfo;
        this.compressedNullPadding = compressedNullPadding;
    }

    @Override
    public void initialize() {
        if (this.compressedNullPadding && LinearImageHeapLayouter.useHeapBase()) {
            assert (((LinearImageHeapPartition)this.getReadOnlyPrimitive()).getSize() == 0L);
            LinearImageHeapPartition firstPartition = (LinearImageHeapPartition)this.getReadOnlyPrimitive();
            firstPartition.size += (long)ConfigurationValues.getObjectLayout().getAlignment();
        }
    }

    protected LinearImageHeapPartition[] createPartitionsArray(int count) {
        return new LinearImageHeapPartition[count];
    }

    @Override
    protected LinearImageHeapPartition createPartition(String name, boolean containsReferences, boolean writable) {
        return new LinearImageHeapPartition(name, writable);
    }

    @Override
    public void assignPartitionRelativeOffsets(ImageHeap imageHeap) {
        for (ImageHeapObject imageHeapObject : imageHeap.getObjects()) {
            ImageHeapPartition partition = imageHeapObject.getPartition();
            partition.allocate(imageHeapObject);
            assert (ConfigurationValues.getObjectLayout().isAligned(imageHeapObject.getOffsetInPartition())) : "start: " + imageHeapObject.getOffsetInPartition() + " must be aligned.";
            assert (ConfigurationValues.getObjectLayout().isAligned(partition.getSize())) : "size: " + partition.getSize() + " must be aligned.";
        }
        this.initializeHeapInfo();
    }

    private void initializeHeapInfo() {
        Object lastReadOnlyReferenceObject;
        Object firstReadOnlyReferenceObject = ((LinearImageHeapPartition)this.getReadOnlyReference()).firstObject;
        if (firstReadOnlyReferenceObject == null) {
            firstReadOnlyReferenceObject = ((LinearImageHeapPartition)this.getReadOnlyRelocatable()).firstObject;
        }
        if ((lastReadOnlyReferenceObject = ((LinearImageHeapPartition)this.getReadOnlyRelocatable()).lastObject) == null) {
            lastReadOnlyReferenceObject = ((LinearImageHeapPartition)this.getReadOnlyReference()).lastObject;
        }
        this.heapInfo.initialize(((LinearImageHeapPartition)this.getReadOnlyPrimitive()).firstObject, ((LinearImageHeapPartition)this.getReadOnlyPrimitive()).lastObject, firstReadOnlyReferenceObject, lastReadOnlyReferenceObject, ((LinearImageHeapPartition)this.getWritablePrimitive()).firstObject, ((LinearImageHeapPartition)this.getWritablePrimitive()).lastObject, ((LinearImageHeapPartition)this.getWritableReference()).firstObject, ((LinearImageHeapPartition)this.getWritableReference()).lastObject);
    }
}

