/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.Generation;
import com.oracle.svm.core.genscavenge.GreyObjectsWalker;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.HeapVerifierImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.SpaceVerifierImpl;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.log.Log;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class OldGeneration
extends Generation {
    private final Space fromSpace;
    private final Space toSpace;
    private final GreyObjectsWalker toGreyObjectsWalker;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    OldGeneration(String name) {
        super(name);
        int age = HeapPolicy.getMaxSurvivorSpaces() + 1;
        this.fromSpace = new Space("oldFromSpace", true, age);
        this.toSpace = new Space("oldToSpace", false, age);
        this.toGreyObjectsWalker = GreyObjectsWalker.factory();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void tearDown() {
        this.fromSpace.tearDown();
        this.toSpace.tearDown();
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        if (!this.getFromSpace().walkObjects(visitor)) {
            return false;
        }
        return this.getToSpace().walkObjects(visitor);
    }

    @Override
    @AlwaysInline(value="GC performance")
    public Object promoteObject(Object original, UnsignedWord header) {
        if (ObjectHeaderImpl.isAlignedHeader(original, header)) {
            AlignedHeapChunk.AlignedHeader chunk = AlignedHeapChunk.getEnclosingAlignedHeapChunk(original);
            Space originalSpace = chunk.getSpace();
            if (originalSpace.isFrom()) {
                return this.promoteAlignedObject(original, originalSpace);
            }
        } else {
            assert (ObjectHeaderImpl.isUnalignedHeader(original, header));
            UnalignedHeapChunk.UnalignedHeader chunk = UnalignedHeapChunk.getEnclosingUnalignedHeapChunk(original);
            Space originalSpace = chunk.getSpace();
            if (originalSpace.isFrom()) {
                this.promoteUnalignedChunk(chunk, originalSpace);
            }
        }
        return original;
    }

    @AlwaysInline(value="GC performance")
    public Object promoteAlignedObject(Object original, Space originalSpace) {
        return this.getToSpace().promoteAlignedObject(original, originalSpace);
    }

    @AlwaysInline(value="GC performance")
    public void promoteUnalignedChunk(UnalignedHeapChunk.UnalignedHeader chunk, Space originalSpace) {
        this.getToSpace().promoteUnalignedHeapChunk(chunk, originalSpace);
    }

    public void promoteObjectChunk(Object obj) {
        this.getToSpace().promoteObjectChunk(obj);
    }

    void releaseSpaces() {
        this.getFromSpace().release();
        if (HeapImpl.getHeapImpl().getGCImpl().isCompleteCollection()) {
            this.getToSpace().cleanRememberedSet();
        }
    }

    protected void walkDirtyObjects(ObjectVisitor visitor, boolean clean) {
        this.getToSpace().walkDirtyObjects(visitor, clean);
    }

    protected void prepareForPromotion() {
        this.getToGreyObjectsWalker().setScanStart(this.getToSpace());
    }

    protected boolean scanGreyObjects() {
        if (!this.getToGreyObjectsWalker().haveGreyObjects()) {
            return false;
        }
        this.getToGreyObjectsWalker().walkGreyObjects();
        return true;
    }

    @Override
    public Log report(Log log, boolean traceHeapChunks) {
        log.string("[Old generation: ").indent(true);
        this.getFromSpace().report(log, traceHeapChunks).newline();
        this.getToSpace().report(log, traceHeapChunks).newline();
        log.redent(false).string("]");
        return log;
    }

    @Override
    protected boolean verify(HeapVerifier.Occasion occasion) {
        boolean result = true;
        HeapImpl heap = HeapImpl.getHeapImpl();
        HeapVerifierImpl heapVerifier = heap.getHeapVerifierImpl();
        SpaceVerifierImpl spaceVerifier = heapVerifier.getSpaceVerifierImpl();
        spaceVerifier.initialize(heap.getOldGeneration().getFromSpace());
        if (!spaceVerifier.verify()) {
            result = false;
            heapVerifier.getWitnessLog().string("[OldGeneration.verify:").string("  old from space fails to verify").string("]").newline();
        }
        if (occasion.equals((Object)HeapVerifier.Occasion.AFTER_COLLECTION) && !spaceVerifier.verifyOnlyCleanCards()) {
            result = false;
            heapVerifier.getWitnessLog().string("[OldGeneration.verify:").string("  old from space contains dirty cards").string("]").newline();
        }
        spaceVerifier.initialize(heap.getOldGeneration().getToSpace());
        if (!spaceVerifier.verify()) {
            result = false;
            heapVerifier.getWitnessLog().string("[OldGeneration.verify:").string("  old to space fails to verify").string("]").newline();
        }
        if (!occasion.equals((Object)HeapVerifier.Occasion.DURING_COLLECTION) && spaceVerifier.containsChunks()) {
            result = false;
            heapVerifier.getWitnessLog().string("[OldGeneration.verify:").string("  old to space contains chunks").string("]").newline();
        }
        return result;
    }

    protected void verifyDirtyCards(boolean isTo) {
        if (isTo) {
            this.getToSpace().verifyDirtyCards();
        } else {
            this.getFromSpace().verifyDirtyCards();
        }
    }

    boolean slowlyFindPointer(Pointer p) {
        if (this.slowlyFindPointerInFromSpace(p)) {
            return true;
        }
        if (this.slowlyFindPointerInToSpace(p)) {
            try (Log paranoia = Log.noopLog();){
                if (paranoia.isEnabled()) {
                    paranoia.string("[OldGeneration.slowlyFindPointerInOldGeneration:");
                    paranoia.string("  p: ").hex((WordBase)p);
                    paranoia.string("  found in: ").string(this.getToSpace().getName());
                    paranoia.string("]").newline();
                }
            }
            return false;
        }
        return false;
    }

    boolean slowlyFindPointerInFromSpace(Pointer p) {
        return HeapVerifierImpl.slowlyFindPointerInSpace(this.getFromSpace(), p, HeapVerifierImpl.ChunkLimit.top);
    }

    boolean slowlyFindPointerInToSpace(Pointer p) {
        return HeapVerifierImpl.slowlyFindPointerInSpace(this.getToSpace(), p, HeapVerifierImpl.ChunkLimit.top);
    }

    int classifyPointer(Pointer p) {
        if (p.isNull()) {
            return 0;
        }
        if (this.slowlyFindPointerInFromSpace(p)) {
            return 1;
        }
        if (this.slowlyFindPointerInToSpace(p)) {
            return 2;
        }
        return -1;
    }

    public Space getFromSpace() {
        return this.fromSpace;
    }

    Space getToSpace() {
        return this.toSpace;
    }

    void swapSpaces() {
        assert (this.getFromSpace().isEmpty()) : "fromSpace should be empty.";
        this.getFromSpace().absorb(this.getToSpace());
    }

    void emptyFromSpaceIntoToSpace() {
        this.getToSpace().absorb(this.getFromSpace());
    }

    private GreyObjectsWalker getToGreyObjectsWalker() {
        return this.toGreyObjectsWalker;
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        return this.getFromSpace().walkHeapChunks(visitor) && this.getToSpace().walkHeapChunks(visitor);
    }
}

