/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class RuntimeCodeCacheCleaner
implements RuntimeCodeCache.CodeInfoVisitor {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    RuntimeCodeCacheCleaner() {
    }

    @Override
    public <T extends CodeInfo> boolean visitCode(T codeInfo) {
        int state = CodeInfoAccess.getState(codeInfo);
        if (state == 4) {
            RuntimeCodeCacheCleaner.freeMemory(codeInfo);
        } else if (state == 2) {
            CodeInfoTable.invalidateNonStackCodeAtSafepoint(codeInfo);
            RuntimeCodeCacheCleaner.freeMemory(codeInfo);
        }
        return true;
    }

    private static void freeMemory(CodeInfo codeInfo) {
        boolean removed = RuntimeCodeInfoMemory.singleton().removeDuringGC(codeInfo);
        assert (removed) : "must have been present";
        RuntimeCodeInfoAccess.releaseMethodInfoMemory(codeInfo);
    }
}

