/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.graal.snippets.DeoptTester;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ThreadLocalAllocation {
    public static final FastThreadLocalBytes<Descriptor> regularTLAB = FastThreadLocalFactory.createBytes(ThreadLocalAllocation::getRegularTLABSize);
    protected static final FastThreadLocalWord<AlignedHeapChunk.AlignedHeader> freeList = FastThreadLocalFactory.createWord();
    private static final OutOfMemoryError arrayAllocationTooLarge = new OutOfMemoryError("Array allocation too large.");

    private ThreadLocalAllocation() {
    }

    @Fold
    static Log log() {
        return Log.noopLog();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int getRegularTLABSize() {
        return SizeOf.get(Descriptor.class);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewInstance(Word objectHeader) {
        DynamicHub hub = ObjectHeaderImpl.getObjectHeaderImpl().dynamicHubFromObjectHeader((UnsignedWord)objectHeader);
        UnsignedWord gcEpoch = HeapImpl.getHeapImpl().getGCImpl().possibleCollectionPrologue();
        Object result = ThreadLocalAllocation.slowPathNewInstanceWithoutAllocating(hub);
        HeapImpl.getHeapImpl().getGCImpl().possibleCollectionEpilogue(gcEpoch);
        ThreadLocalAllocation.runSlowPathHooks();
        return result;
    }

    private static void runSlowPathHooks() {
        HeapPolicy.samplePhysicalMemorySize();
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object slowPathNewInstanceWithoutAllocating(DynamicHub hub) {
        Descriptor tlab = regularTLAB.getAddress();
        return ThreadLocalAllocation.allocateNewInstance(hub, tlab, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object allocateNewInstance(DynamicHub hub, Descriptor tlab, boolean rememberedSet) {
        DeoptTester.disableDeoptTesting();
        try {
            ThreadLocalAllocation.log().string("[ThreadLocalAllocation.allocateNewInstance: ").string(DynamicHub.toClass(hub).getName()).string(" in tlab ").hex((WordBase)tlab).newline();
            HeapImpl.exitIfAllocationDisallowed("ThreadLocalAllocation.allocateNewInstance", DynamicHub.toClass(hub).getName());
            HeapImpl.getHeapImpl().getHeapPolicy().getCollectOnAllocationPolicy().maybeCauseCollection();
            AlignedHeapChunk.AlignedHeader newChunk = ThreadLocalAllocation.prepareNewAllocationChunk(tlab);
            UnsignedWord size = LayoutEncoding.getInstanceSize(hub.getLayoutEncoding());
            Object result = ThreadLocalAllocation.allocateNewInstanceUninterruptibly(hub, tlab, rememberedSet, size, newChunk);
            ThreadLocalAllocation.log().string("  ThreadLocalAllocation.allocateNewInstance returns ").object(result).string(" .. ").hex((WordBase)LayoutEncoding.getObjectEnd(result)).string("]").newline();
            Object object = result;
            return object;
        }
        finally {
            DeoptTester.enableDeoptTesting();
        }
    }

    @Uninterruptible(reason="Holds uninitialized memory, modifies TLAB")
    private static Object allocateNewInstanceUninterruptibly(DynamicHub hub, Descriptor tlab, boolean rememberedSet, UnsignedWord size, AlignedHeapChunk.AlignedHeader newChunk) {
        ThreadLocalAllocation.registerNewAllocationChunk(tlab, newChunk);
        Pointer memory = ThreadLocalAllocation.allocateMemory(tlab, size);
        assert (memory.isNonNull());
        return FormatObjectNode.formatObject(memory, DynamicHub.toClass(hub), rememberedSet, true, true);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewArray(Word objectHeader, int length) {
        if (length < 0) {
            throw new NegativeArraySizeException();
        }
        UnsignedWord gcEpoch = HeapImpl.getHeapImpl().getGCImpl().possibleCollectionPrologue();
        DynamicHub hub = ObjectHeaderImpl.getObjectHeaderImpl().dynamicHubFromObjectHeader((UnsignedWord)objectHeader);
        Object result = ThreadLocalAllocation.slowPathNewArrayWithoutAllocating(hub, length);
        HeapImpl.getHeapImpl().getGCImpl().possibleCollectionEpilogue(gcEpoch);
        ThreadLocalAllocation.runSlowPathHooks();
        return result;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object slowPathNewArrayWithoutAllocating(DynamicHub hub, int length) {
        Descriptor tlab = regularTLAB.getAddress();
        return ThreadLocalAllocation.allocateNewArray(hub, length, tlab, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object allocateNewArray(DynamicHub hub, int length, Descriptor tlab, boolean rememberedSet) {
        DeoptTester.disableDeoptTesting();
        try {
            Object result;
            ThreadLocalAllocation.log().string("[ThreadLocalAllocation.allocateNewArray: ").string(DynamicHub.toClass(hub).getName()).string("  length ").signed(length).string("  in tlab ").hex((WordBase)tlab).newline();
            HeapImpl.exitIfAllocationDisallowed("Heap.allocateNewArray", DynamicHub.toClass(hub).getName());
            HeapImpl.getHeapImpl().getHeapPolicy().getCollectOnAllocationPolicy().maybeCauseCollection();
            UnsignedWord size = LayoutEncoding.getArraySize(hub.getLayoutEncoding(), length);
            if (size.aboveOrEqual(HeapPolicy.getLargeArrayThreshold())) {
                if (size.aboveOrEqual(HeapPolicy.getMaximumHeapSize())) {
                    throw arrayAllocationTooLarge;
                }
                UnalignedHeapChunk.UnalignedHeader uChunk = HeapChunkProvider.get().produceUnalignedChunk(size);
                result = ThreadLocalAllocation.allocateLargeArray(hub, length, size, uChunk, tlab, rememberedSet);
            } else {
                AlignedHeapChunk.AlignedHeader newChunk = ThreadLocalAllocation.prepareNewAllocationChunk(tlab);
                result = ThreadLocalAllocation.allocateSmallArray(hub, length, size, tlab, rememberedSet, newChunk);
            }
            ThreadLocalAllocation.log().string("  ThreadLocalAllocation.allocateNewArray returns ").object(result).string(" .. ").hex((WordBase)LayoutEncoding.getObjectEnd(result)).string("]").newline();
            Object object = result;
            return object;
        }
        finally {
            DeoptTester.enableDeoptTesting();
        }
    }

    @Uninterruptible(reason="Holds uninitialized memory, modifies TLAB")
    private static Object allocateSmallArray(DynamicHub hub, int length, UnsignedWord size, Descriptor tlab, boolean rememberedSet, AlignedHeapChunk.AlignedHeader newChunk) {
        ThreadLocalAllocation.registerNewAllocationChunk(tlab, newChunk);
        Pointer memory = ThreadLocalAllocation.allocateMemory(tlab, size);
        assert (memory.isNonNull());
        return FormatArrayNode.formatArray(memory, DynamicHub.toClass(hub), length, rememberedSet, false, true, true);
    }

    @Uninterruptible(reason="Holds uninitialized memory, modifies TLAB")
    private static Object allocateLargeArray(DynamicHub hub, int length, UnsignedWord size, UnalignedHeapChunk.UnalignedHeader uChunk, Descriptor tlab, boolean rememberedSet) {
        uChunk.setNext(tlab.getUnalignedChunk());
        tlab.setUnalignedChunk(uChunk);
        Pointer memory = UnalignedHeapChunk.allocateMemory(uChunk, size);
        assert (memory.isNonNull());
        return FormatArrayNode.formatArray(memory, DynamicHub.toClass(hub), length, rememberedSet, true, true, true);
    }

    @Uninterruptible(reason="returns uninitialized memory, modifies TLAB", callerMustBe=true)
    private static Pointer allocateMemory(Descriptor allocator, UnsignedWord size) {
        Pointer top = KnownIntrinsics.nonNullPointer((Pointer)allocator.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY));
        Pointer end = KnownIntrinsics.nonNullPointer((Pointer)allocator.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY));
        Pointer available = end.subtract((UnsignedWord)top);
        if (BranchProbabilityNode.probability((double)0.99, (boolean)size.belowOrEqual((UnsignedWord)available))) {
            allocator.setAllocationTop(top.add(size), SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
            return top;
        }
        return (Pointer)WordFactory.nullPointer();
    }

    static boolean isThreadLocalAllocationSpace(Space space) {
        return space == HeapImpl.getHeapImpl().getYoungGeneration().getEden();
    }

    public static void disableThreadLocalAllocation() {
        VMOperation.guaranteeInProgress("ThreadLocalAllocation.disableThreadLocalAllocation");
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                ThreadLocalAllocation.disableThreadLocalAllocation(vmThread);
                vmThread = VMThreads.nextThread(vmThread);
            }
        } else {
            ThreadLocalAllocation.disableThreadLocalAllocation((IsolateThread)WordFactory.nullPointer());
        }
    }

    public static void disableThreadLocalAllocation(IsolateThread vmThread) {
        ThreadLocalAllocation.retireToSpace(regularTLAB.getAddress(vmThread), HeapImpl.getHeapImpl().getAllocationSpace());
        AlignedHeapChunk.AlignedHeader alignedChunk = ThreadLocalAllocation.popFromThreadLocalFreeList();
        while (alignedChunk.isNonNull()) {
            HeapChunkProvider.get().consumeAlignedChunk(alignedChunk);
            alignedChunk = ThreadLocalAllocation.popFromThreadLocalFreeList();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void tearDown() {
        IsolateThread thread;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            thread = VMThreads.firstThreadUnsafe();
            VMError.guarantee(VMThreads.nextThread(thread).isNull(), "Other isolate threads are still active");
        } else {
            thread = (IsolateThread)WordFactory.nullPointer();
        }
        ThreadLocalAllocation.freeHeapChunks(regularTLAB.getAddress(thread));
        HeapChunkProvider.freeAlignedChunkList(freeList.get());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void freeHeapChunks(Descriptor tlab) {
        HeapChunkProvider.freeAlignedChunkList(tlab.getAlignedChunk());
        HeapChunkProvider.freeUnalignedChunkList(tlab.getUnalignedChunk());
    }

    public static void suspendThreadLocalAllocation() {
        ThreadLocalAllocation.retireAllocationChunk(regularTLAB.getAddress());
    }

    public static void resumeThreadLocalAllocation() {
        ThreadLocalAllocation.resumeAllocationChunk(regularTLAB.getAddress());
    }

    static void retireToSpace(Descriptor tlab, Space space) {
        HeapChunk.Header<AlignedHeapChunk.AlignedHeader> next;
        assert (!space.isOldSpace()) : "must not be moved to the old gen - otherwise a remembered set would have to be constructed";
        ThreadLocalAllocation.log().string("[ThreadLocalAllocator.retireToSpace: tlab ").hex((WordBase)tlab).string(" space ").string(space.getName()).newline();
        ThreadLocalAllocation.retireAllocationChunk(tlab);
        AlignedHeapChunk.AlignedHeader alignedChunk = tlab.getAlignedChunk();
        HeapChunk.Header<UnalignedHeapChunk.UnalignedHeader> unalignedChunk = tlab.getUnalignedChunk();
        tlab.setAlignedChunk((AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        tlab.setUnalignedChunk((UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
        while (alignedChunk.isNonNull()) {
            next = (AlignedHeapChunk.AlignedHeader)alignedChunk.getNext();
            alignedChunk.setNext((HeapChunk.Header)WordFactory.nullPointer());
            ThreadLocalAllocation.log().string("  aligned chunk ").hex((WordBase)alignedChunk).newline();
            space.appendAlignedHeapChunk(alignedChunk);
            alignedChunk = next;
        }
        while (unalignedChunk.isNonNull()) {
            next = (UnalignedHeapChunk.UnalignedHeader)unalignedChunk.getNext();
            unalignedChunk.setNext((UnalignedHeapChunk.UnalignedHeader)((HeapChunk.Header)WordFactory.nullPointer()));
            ThreadLocalAllocation.log().string("  unaligned chunk ").hex((WordBase)unalignedChunk).newline();
            space.appendUnalignedHeapChunk((UnalignedHeapChunk.UnalignedHeader)unalignedChunk);
            unalignedChunk = next;
        }
        ThreadLocalAllocation.log().string("  ThreadLocalAllocator.retireToSpace ]").newline();
    }

    public static void releaseMemory(Descriptor tlab) {
        HeapChunk.Header<AlignedHeapChunk.AlignedHeader> next;
        ThreadLocalAllocation.log().string("[ThreadLocalAllocator.releaseMemory: tlab ").hex((WordBase)tlab).newline();
        ThreadLocalAllocation.retireAllocationChunk(tlab);
        AlignedHeapChunk.AlignedHeader alignedChunk = tlab.getAlignedChunk();
        HeapChunk.Header<UnalignedHeapChunk.UnalignedHeader> unalignedChunk = tlab.getUnalignedChunk();
        tlab.setAlignedChunk((AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        tlab.setUnalignedChunk((UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
        while (alignedChunk.isNonNull()) {
            next = (AlignedHeapChunk.AlignedHeader)alignedChunk.getNext();
            HeapChunkProvider.resetAlignedHeader(alignedChunk);
            ThreadLocalAllocation.log().string("  aligned chunk ").hex((WordBase)alignedChunk).newline();
            ThreadLocalAllocation.pushToThreadLocalFreeList(alignedChunk);
            alignedChunk = next;
        }
        while (unalignedChunk.isNonNull()) {
            next = (UnalignedHeapChunk.UnalignedHeader)unalignedChunk.getNext();
            unalignedChunk.setNext((UnalignedHeapChunk.UnalignedHeader)((HeapChunk.Header)WordFactory.nullPointer()));
            ThreadLocalAllocation.log().string("  unaligned chunk ").hex((WordBase)alignedChunk).newline();
            HeapChunkProvider.get().consumeUnalignedChunk((UnalignedHeapChunk.UnalignedHeader)unalignedChunk);
            unalignedChunk = next;
        }
        ThreadLocalAllocation.log().string("  ]").newline();
    }

    @Uninterruptible(reason="Pushes the free list that is drained, at a safepoint, by garbage collections.")
    private static void pushToThreadLocalFreeList(AlignedHeapChunk.AlignedHeader alignedChunk) {
        ThreadLocalAllocation.log().string("[ThreadLocalAllocation.pushToThreadLocalFreeList:  alignedChunk: ").hex((WordBase)alignedChunk).newline();
        ThreadLocalAllocation.log().string("  before freeList: ").hex((WordBase)freeList.get()).newline();
        assert (alignedChunk.isNonNull()) : "Should not push a null chunk on the free list.";
        AlignedHeapChunk.AlignedHeader head = freeList.get();
        alignedChunk.setNext(head);
        freeList.set(alignedChunk);
        ThreadLocalAllocation.log().string("   after freeList: ").hex((WordBase)freeList.get()).string("]").newline();
    }

    @Uninterruptible(reason="Pops from the free list that is drained, at a safepoint, by garbage collections.")
    private static AlignedHeapChunk.AlignedHeader popFromThreadLocalFreeList() {
        AlignedHeapChunk.AlignedHeader result = freeList.get();
        if (result.isNonNull()) {
            AlignedHeapChunk.AlignedHeader next = (AlignedHeapChunk.AlignedHeader)result.getNext();
            result.setNext((HeapChunk.Header)WordFactory.nullPointer());
            freeList.set(next);
        }
        return result;
    }

    public static UnsignedWord getObjectBytes(Descriptor tlab) {
        Log log = ThreadLocalAllocation.log();
        log.newline();
        log.string("[ThreadLocalAllocator.usedMemory: tlab ").hex((WordBase)tlab).newline();
        AlignedHeapChunk.AlignedHeader aChunk = tlab.getAlignedChunk();
        UnsignedWord alignedUsedMemory = (UnsignedWord)WordFactory.zero();
        while (aChunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader next = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
            Pointer start = AlignedHeapChunk.getAlignedHeapChunkStart(aChunk);
            Pointer top = aChunk.getTop().isNull() ? tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY) : aChunk.getTop();
            Pointer aChunkUsedMemory = top.subtract((UnsignedWord)start);
            alignedUsedMemory = alignedUsedMemory.add((UnsignedWord)aChunkUsedMemory);
            log.string("     aligned chunk: ").hex((WordBase)aChunk).string(" | used memory: ").unsigned((WordBase)aChunkUsedMemory).newline();
            aChunk = next;
        }
        UnsignedWord unalignedUsedMemory = (UnsignedWord)WordFactory.zero();
        UnalignedHeapChunk.UnalignedHeader uChunk = tlab.getUnalignedChunk();
        while (uChunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader next = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
            UnsignedWord uChunkUsedMemory = UnalignedHeapChunk.usedObjectMemoryOfUnalignedHeapChunk(uChunk);
            unalignedUsedMemory = unalignedUsedMemory.add(uChunkUsedMemory);
            log.string("     unaligned chunk ").hex((WordBase)uChunk).string(" | used memory: ").unsigned((WordBase)uChunkUsedMemory).newline();
            uChunk = next;
        }
        UnsignedWord tlabUsedMemory = alignedUsedMemory.add(unalignedUsedMemory);
        log.newline();
        log.string("  aligned used memory: ").unsigned((WordBase)alignedUsedMemory).newline();
        log.string("  unaligned used memory: ").unsigned((WordBase)unalignedUsedMemory).newline();
        log.string("  TLAB used memory: ").unsigned((WordBase)tlabUsedMemory).newline();
        log.string("  ]").newline();
        return tlabUsedMemory;
    }

    private static AlignedHeapChunk.AlignedHeader prepareNewAllocationChunk(Descriptor tlab) {
        ThreadLocalAllocation.retireAllocationChunk(tlab);
        AlignedHeapChunk.AlignedHeader newChunk = ThreadLocalAllocation.popFromThreadLocalFreeList();
        if (newChunk.isNull()) {
            newChunk = HeapChunkProvider.get().produceAlignedChunk();
        }
        return newChunk;
    }

    @Uninterruptible(reason="Modifies TLAB")
    private static void registerNewAllocationChunk(Descriptor tlab, AlignedHeapChunk.AlignedHeader newChunk) {
        newChunk.setNext(tlab.getAlignedChunk());
        tlab.setAlignedChunk(newChunk);
        ThreadLocalAllocation.resumeAllocationChunk(tlab);
    }

    @Uninterruptible(reason="Modifies TLAB")
    private static void retireAllocationChunk(Descriptor tlab) {
        Word allocationTop = tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        if (allocationTop.isNonNull()) {
            AlignedHeapChunk.AlignedHeader alignedChunk = tlab.getAlignedChunk();
            assert (alignedChunk.getTop().isNull());
            assert (alignedChunk.getEnd().equal((UnsignedWord)tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY)));
            alignedChunk.setTop((Pointer)allocationTop);
            tlab.setAllocationTop((Pointer)WordFactory.nullPointer(), SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
            tlab.setAllocationEnd((Pointer)WordFactory.nullPointer(), SubstrateAllocationSnippets.TLAB_END_IDENTITY);
        }
    }

    @Uninterruptible(reason="Modifies TLAB.")
    static void resumeAllocationChunk(Descriptor tlab) {
        assert (tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY).isNull());
        assert (tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_END_IDENTITY).isNull());
        AlignedHeapChunk.AlignedHeader alignedChunk = tlab.getAlignedChunk();
        if (alignedChunk.isNonNull()) {
            tlab.setAllocationTop(alignedChunk.getTop(), SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
            tlab.setAllocationEnd(alignedChunk.getEnd(), SubstrateAllocationSnippets.TLAB_END_IDENTITY);
            alignedChunk.setTop((Pointer)WordFactory.nullPointer());
        }
    }

    public static boolean verifyUninitialized(Descriptor tlab) {
        assert (tlab.getAlignedChunk().isNull());
        assert (tlab.getUnalignedChunk().isNull());
        assert (tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY).isNull());
        assert (tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_END_IDENTITY).isNull());
        return true;
    }

    public static class TestingBackdoor {
        public static AlignedHeapChunk.AlignedHeader getAlignedChunkFromProvider() {
            return HeapChunkProvider.get().produceAlignedChunk();
        }

        public static AlignedHeapChunk.AlignedHeader popFromThreadLocalFreeList() {
            return ThreadLocalAllocation.popFromThreadLocalFreeList();
        }

        public static void pushToThreadLocalFreeList(AlignedHeapChunk.AlignedHeader alignedChunk) {
            ThreadLocalAllocation.pushToThreadLocalFreeList(alignedChunk);
        }

        public static boolean isEmptyThreadLocalFreeList() {
            return freeList.get().isNull();
        }

        public static boolean isHeadThreadLocalFreeList(AlignedHeapChunk.AlignedHeader alignedChunk) {
            return freeList.get().equal((ComparableWord)alignedChunk);
        }
    }

    @RawStructure
    public static interface Descriptor
    extends PointerBase {
        @RawField
        @UniqueLocationIdentity
        public AlignedHeapChunk.AlignedHeader getAlignedChunk();

        @RawField
        @UniqueLocationIdentity
        public void setAlignedChunk(AlignedHeapChunk.AlignedHeader var1);

        @RawField
        @UniqueLocationIdentity
        public UnalignedHeapChunk.UnalignedHeader getUnalignedChunk();

        @RawField
        @UniqueLocationIdentity
        public void setUnalignedChunk(UnalignedHeapChunk.UnalignedHeader var1);

        @RawField
        public Word getAllocationTop(LocationIdentity var1);

        @RawField
        public void setAllocationTop(Pointer var1, LocationIdentity var2);

        @RawField
        public Word getAllocationEnd(LocationIdentity var1);

        @RawField
        public void setAllocationEnd(Pointer var1, LocationIdentity var2);
    }
}

