/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.SnippetRuntime;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.AllocationSnippets;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class GenScavengeAllocationSnippets
extends SubstrateAllocationSnippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_INSTANCE = SnippetRuntime.findForeignCall(ThreadLocalAllocation.class, "slowPathNewInstance", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_ARRAY = SnippetRuntime.findForeignCall(ThreadLocalAllocation.class, "slowPathNewArray", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{SLOW_NEW_INSTANCE, SLOW_NEW_ARRAY};

    public static void registerForeignCalls(Providers providers, Map<SnippetRuntime.SubstrateForeignCallDescriptor, SubstrateForeignCallLinkage> foreignCalls) {
        SubstrateAllocationSnippets.registerForeignCalls(providers, foreignCalls);
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : FOREIGN_CALLS) {
            foreignCalls.put(descriptor, new SubstrateForeignCallLinkage(providers, descriptor));
        }
    }

    public static void registerLowering(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        GenScavengeAllocationSnippets snippetReceiver = new GenScavengeAllocationSnippets();
        Templates allocationSnippets = new Templates(snippetReceiver, options, factories, SnippetCounter.Group.NullFactory, providers, snippetReflection);
        allocationSnippets.registerLowerings(lowerings);
    }

    @Snippet
    public Object formatObjectSnippet(Word memory, DynamicHub hub, boolean rememberedSet, boolean fillContents, boolean emitMemoryBarrier, @Snippet.ConstantParameter AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getInstanceSize(layoutEncoding);
        Word objectHeader = GenScavengeAllocationSnippets.encodeAsObjectHeader(hubNonNull, rememberedSet, false);
        return this.formatObject(objectHeader, (Word)WordFactory.nullPointer(), size, memory, fillContents, emitMemoryBarrier, false, snippetCounters);
    }

    @Snippet
    public Object formatArraySnippet(Word memory, DynamicHub hub, int length, boolean rememberedSet, boolean unaligned, boolean fillContents, boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getArraySize(layoutEncoding, length);
        Word objectHeader = GenScavengeAllocationSnippets.encodeAsObjectHeader(hubNonNull, rememberedSet, unaligned);
        return this.formatArray(objectHeader, (Word)WordFactory.nullPointer(), size, length, memory, fillContents, GenScavengeAllocationSnippets.getArrayZeroingStartOffset(), emitMemoryBarrier, false, supportsBulkZeroing, snippetCounters);
    }

    private static Word encodeAsObjectHeader(DynamicHub hub, boolean rememberedSet, boolean unaligned) {
        return ObjectHeaderImpl.encodeAsObjectHeader(hub, rememberedSet, unaligned);
    }

    protected void initializeObjectHeader(Word memory, Word objectHeader, Word prototypeMarkWord, boolean isArray) {
        ObjectHeaderImpl.initializeHeaderOfNewObject((Pointer)memory, objectHeader);
    }

    protected boolean useTLAB() {
        return true;
    }

    protected boolean shouldAllocateInTLAB(UnsignedWord size, boolean isArray) {
        return !isArray || size.belowThan(HeapPolicy.getLargeArrayThreshold());
    }

    protected Word getTLABInfo() {
        return (Word)ThreadLocalAllocation.regularTLAB.getAddress();
    }

    protected Word readTlabTop(Word tlabInfo) {
        return ((ThreadLocalAllocation.Descriptor)tlabInfo).getAllocationTop(TLAB_TOP_IDENTITY);
    }

    protected Word readTlabEnd(Word tlabInfo) {
        return ((ThreadLocalAllocation.Descriptor)tlabInfo).getAllocationEnd(TLAB_END_IDENTITY);
    }

    protected void writeTlabTop(Word tlabInfo, Word newTop) {
        ((ThreadLocalAllocation.Descriptor)tlabInfo).setAllocationTop((Pointer)newTop, TLAB_TOP_IDENTITY);
    }

    @Override
    protected SnippetRuntime.SubstrateForeignCallDescriptor getSlowNewInstanceStub() {
        return SLOW_NEW_INSTANCE;
    }

    @Override
    protected SnippetRuntime.SubstrateForeignCallDescriptor getSlowNewArrayStub() {
        return SLOW_NEW_ARRAY;
    }

    public static class Templates
    extends SubstrateAllocationSnippets.Templates {
        private final SnippetTemplate.SnippetInfo formatObject;
        private final SnippetTemplate.SnippetInfo formatArray;

        public Templates(GenScavengeAllocationSnippets receiver, OptionValues options, Iterable<DebugHandlersFactory> factories, SnippetCounter.Group.Factory groupFactory, Providers providers, SnippetReflectionProvider snippetReflection) {
            super(receiver, options, factories, groupFactory, providers, snippetReflection);
            this.formatObject = this.snippet((Class<? extends Snippets>)GenScavengeAllocationSnippets.class, "formatObjectSnippet", (ResolvedJavaMethod)null, (Object)receiver, new LocationIdentity[0]);
            this.formatArray = this.snippet((Class<? extends Snippets>)GenScavengeAllocationSnippets.class, "formatArraySnippet", (ResolvedJavaMethod)null, (Object)receiver, new LocationIdentity[0]);
        }

        @Override
        public void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
            super.registerLowerings(lowerings);
            FormatObjectLowering formatObjectLowering = new FormatObjectLowering();
            lowerings.put(FormatObjectNode.class, formatObjectLowering);
            FormatArrayLowering formatArrayLowering = new FormatArrayLowering();
            lowerings.put(FormatArrayNode.class, formatArrayLowering);
        }

        private class FormatArrayLowering
        implements NodeLoweringProvider<FormatArrayNode> {
            private FormatArrayLowering() {
            }

            @Override
            public void lower(FormatArrayNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.formatArray, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("memory", (Object)node.getMemory());
                args.add("hub", (Object)node.getHub());
                args.add("length", (Object)node.getLength());
                args.add("rememberedSet", (Object)node.getRememberedSet());
                args.add("unaligned", (Object)node.getUnaligned());
                args.add("fillContents", (Object)node.getFillContents());
                args.add("emitMemoryBarrier", (Object)node.getEmitMemoryBarrier());
                args.addConst("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroing());
                args.addConst("snippetCounters", (Object)Templates.this.snippetCounters);
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class FormatObjectLowering
        implements NodeLoweringProvider<FormatObjectNode> {
            private FormatObjectLowering() {
            }

            @Override
            public void lower(FormatObjectNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.formatObject, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("memory", (Object)node.getMemory());
                args.add("hub", (Object)node.getHub());
                args.add("rememberedSet", (Object)node.getRememberedSet());
                args.add("fillContents", (Object)node.getFillContents());
                args.add("emitMemoryBarrier", (Object)node.getEmitMemoryBarrier());
                args.addConst("snippetCounters", (Object)Templates.this.snippetCounters);
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

