/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.results.StaticAnalysisResultsBuilder;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;

public class HostedConfiguration {
    public static HostedConfiguration instance() {
        return (HostedConfiguration)ImageSingletons.lookup(HostedConfiguration.class);
    }

    static void setDefaultIfEmpty() {
        if (!ImageSingletons.contains(HostedConfiguration.class)) {
            ImageSingletons.add(HostedConfiguration.class, (Object)new HostedConfiguration());
            CompressEncoding compressEncoding = new CompressEncoding(SubstrateOptions.SpawnIsolates.getValue() != false ? 1L : 0L, 0);
            ImageSingletons.add(CompressEncoding.class, (Object)compressEncoding);
            ObjectLayout objectLayout = HostedConfiguration.createObjectLayout();
            ImageSingletons.add(ObjectLayout.class, (Object)objectLayout);
        }
    }

    public static ObjectLayout createObjectLayout() {
        return HostedConfiguration.createObjectLayout(0, JavaKind.Object);
    }

    public static ObjectLayout createObjectLayout(int hubOffset, JavaKind referenceKind) {
        SubstrateTargetDescription target = ConfigurationValues.getTarget();
        int referenceSize = target.arch.getPlatformKind(referenceKind).getSizeInBytes();
        int objectAlignment = target.wordSize;
        int firstFieldOffset = hubOffset + referenceSize;
        int arrayLengthOffset = hubOffset + referenceSize;
        int arrayIdentityHashCodeOffset = arrayLengthOffset + target.arch.getPlatformKind(JavaKind.Int).getSizeInBytes();
        int arrayBaseOffset = arrayIdentityHashCodeOffset + target.arch.getPlatformKind(JavaKind.Int).getSizeInBytes();
        int arrayZeroingStartOffset = arrayIdentityHashCodeOffset;
        boolean useExplicitIdentityHashCodeField = true;
        int instanceIdentityHashCodeOffset = -1;
        ObjectLayout objectLayout = new ObjectLayout(target, referenceSize, objectAlignment, hubOffset, firstFieldOffset, arrayLengthOffset, arrayBaseOffset, arrayZeroingStartOffset, useExplicitIdentityHashCodeField, instanceIdentityHashCodeOffset, arrayIdentityHashCodeOffset);
        return objectLayout;
    }

    public CompileQueue createCompileQueue(DebugContext debug, FeatureHandler featureHandler, HostedUniverse hostedUniverse, SharedRuntimeConfigurationBuilder runtime, boolean deoptimizeAll, SnippetReflectionProvider aSnippetReflection, ForkJoinPool executor) {
        return new CompileQueue(debug, featureHandler, hostedUniverse, runtime, deoptimizeAll, aSnippetReflection, executor);
    }

    public void findAllFieldsForLayout(HostedUniverse universe, HostedMetaAccess metaAccess, Map<AnalysisField, HostedField> universeFields, ArrayList<HostedField> rawFields, ArrayList<HostedField> orderedFields, HostedInstanceClass clazz) {
        for (AnalysisField aField : clazz.getWrapped().getInstanceFields(false)) {
            HostedField hField = universe.lookup((JavaField)aField);
            if (!hField.getDeclaringClass().equals(clazz)) continue;
            if (HybridLayout.isHybridField(hField)) {
                orderedFields.add(hField);
                continue;
            }
            if (!hField.isAccessed()) continue;
            rawFields.add(hField);
        }
    }

    public StaticAnalysisResultsBuilder createStaticAnalysisResultsBuilder(BigBang bigbang, HostedUniverse universe) {
        return new StaticAnalysisResultsBuilder(bigbang, (Universe)universe);
    }

    public boolean isUsingAOTProfiles() {
        return false;
    }
}

