/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.query;

import com.oracle.svm.core.c.enums.EnumArrayLookup;
import com.oracle.svm.core.c.enums.EnumMapLookup;
import com.oracle.svm.core.c.enums.EnumNoLookup;
import com.oracle.svm.core.c.enums.EnumRuntimeData;
import com.oracle.svm.core.c.struct.CInterfaceLocationIdentity;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumConstantInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.EnumValueInfo;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.query.NativeInfoTreeVisitor;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.struct.AllowNarrowingCast;
import org.graalvm.nativeimage.c.struct.AllowWideningCast;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;

public final class SizeAndSignednessVerifier
extends NativeInfoTreeVisitor {
    private SizeAndSignednessVerifier(NativeLibraries nativeLibs) {
        super(nativeLibs);
    }

    public static void verify(NativeLibraries nativeLibs, NativeCodeInfo nativeCodeInfo) {
        SizeAndSignednessVerifier verifier = new SizeAndSignednessVerifier(nativeLibs);
        nativeCodeInfo.accept(verifier);
    }

    @Override
    protected void visitConstantInfo(ConstantInfo constantInfo) {
        if (constantInfo.getKind() != SizableInfo.ElementKind.STRING && constantInfo.getKind() != SizableInfo.ElementKind.BYTEARRAY) {
            ResolvedJavaMethod method = constantInfo.getAnnotatedElement();
            ResolvedJavaType returnType = AccessorInfo.getReturnType(method);
            this.checkSizeAndSignedness(constantInfo, returnType, method, true);
        }
    }

    @Override
    protected void visitStructFieldInfo(StructFieldInfo structFieldInfo) {
        this.checkAccessorLocationIdentity(structFieldInfo.getChildren());
        if (structFieldInfo.getAnyAccessorInfo().hasUniqueLocationIdentity()) {
            structFieldInfo.setLocationIdentity(new CInterfaceLocationIdentity(structFieldInfo.getParent().getName() + "." + structFieldInfo.getName()));
        }
        super.visitStructFieldInfo(structFieldInfo);
    }

    @Override
    protected void visitStructBitfieldInfo(StructBitfieldInfo structBitfieldInfo) {
        this.checkAccessorLocationIdentity(structBitfieldInfo.getChildren());
        super.visitStructBitfieldInfo(structBitfieldInfo);
    }

    private void checkAccessorLocationIdentity(List<ElementInfo> children) {
        AccessorInfo firstAccessorInfo = null;
        for (ElementInfo child : children) {
            if (!(child instanceof AccessorInfo)) continue;
            AccessorInfo accessorInfo = (AccessorInfo)child;
            if (firstAccessorInfo == null) {
                firstAccessorInfo = accessorInfo;
                continue;
            }
            if (accessorInfo.hasLocationIdentityParameter() != firstAccessorInfo.hasLocationIdentityParameter()) {
                this.addError("All accessors for a field must agree on LocationIdentity parameter", firstAccessorInfo, accessorInfo);
                continue;
            }
            if (accessorInfo.hasUniqueLocationIdentity() == firstAccessorInfo.hasUniqueLocationIdentity()) continue;
            this.addError("All accessors for a field must agree on @" + UniqueLocationIdentity.class.getSimpleName() + " annotation", firstAccessorInfo, accessorInfo);
        }
    }

    @Override
    protected void visitAccessorInfo(AccessorInfo accessorInfo) {
        ResolvedJavaMethod method = accessorInfo.getAnnotatedElement();
        ResolvedJavaType returnType = accessorInfo.getReturnType();
        if (accessorInfo.getParent() instanceof StructBitfieldInfo) {
            StructBitfieldInfo bitfieldInfo = (StructBitfieldInfo)accessorInfo.getParent();
            switch (accessorInfo.getAccessorKind()) {
                case GETTER: 
                case SETTER: {
                    this.checkSignedness(bitfieldInfo.isUnsigned(), returnType, method);
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } else {
            SizableInfo sizableInfo = (SizableInfo)accessorInfo.getParent();
            switch (accessorInfo.getAccessorKind()) {
                case ADDRESS: {
                    assert (this.nativeLibs.isPointerBase(returnType));
                    break;
                }
                case OFFSET: {
                    assert (returnType.getJavaKind().isNumericInteger() || this.nativeLibs.isUnsigned(returnType));
                    break;
                }
                case GETTER: {
                    this.checkSizeAndSignedness(sizableInfo, returnType, method, true);
                    break;
                }
                case SETTER: {
                    assert (returnType.getJavaKind() == JavaKind.Void);
                    ResolvedJavaType valueType = accessorInfo.getValueParameterType();
                    this.checkSizeAndSignedness(sizableInfo, valueType, method, false);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void visitEnumInfo(EnumInfo enumInfo) {
        void var10_14;
        super.visitEnumInfo(enumInfo);
        HashMap javaToC = new HashMap();
        HashMap cToJava = new HashMap();
        Class<?> enumClass = null;
        long minLookupValue = Long.MAX_VALUE;
        long maxLookupValue = Long.MIN_VALUE;
        for (ElementInfo elementInfo : enumInfo.getChildren()) {
            if (!(elementInfo instanceof EnumConstantInfo)) continue;
            EnumConstantInfo enumConstantInfo = (EnumConstantInfo)elementInfo;
            long cValue = (Long)enumConstantInfo.getValueInfo().getProperty();
            Enum<?> javaValue = enumConstantInfo.getEnumValue();
            assert (enumClass == null || enumClass == javaValue.getClass());
            enumClass = javaValue.getClass();
            assert (javaToC.get(javaValue) == null);
            javaToC.put(javaValue, cValue);
            if (!enumInfo.getNeedsLookup() || !enumConstantInfo.getIncludeInLookup()) continue;
            if (cToJava.get(cValue) != null) {
                this.addError("C value is not unique, so reverse lookup from C to Java is not possible: " + cToJava.get(cValue) + " and " + javaValue + " hava same C value " + cValue, enumConstantInfo.getAnnotatedElement());
            }
            cToJava.put(cValue, javaValue);
            minLookupValue = Math.min(minLookupValue, cValue);
            maxLookupValue = Math.max(maxLookupValue, cValue);
        }
        long[] javaToCArray = new long[javaToC.size()];
        for (Map.Entry entry : javaToC.entrySet()) {
            int idx = ((Enum)entry.getKey()).ordinal();
            assert (idx >= 0 && idx < javaToCArray.length && javaToCArray[idx] == 0L) : "ordinal values are defined as unique and consecutive";
            javaToCArray[idx] = (Long)entry.getValue();
        }
        if (cToJava.size() > 0) {
            assert (minLookupValue <= maxLookupValue);
            long l = maxLookupValue - minLookupValue;
            assert (l >= (long)(cToJava.size() - 1));
            if (l < (long)cToJava.size() * 5L && l >= 0L && l < Integer.MAX_VALUE) {
                long offset = minLookupValue;
                Enum[] cToJavaArray = (Enum[])Array.newInstance(enumClass, (int)l + 1);
                for (Map.Entry entry : cToJava.entrySet()) {
                    long idx = (Long)entry.getKey() - offset;
                    assert (idx >= 0L && idx < (long)cToJavaArray.length);
                    assert (cToJavaArray[(int)idx] == null);
                    cToJavaArray[(int)idx] = (Enum)entry.getValue();
                }
                EnumArrayLookup enumArrayLookup = new EnumArrayLookup(javaToCArray, offset, cToJavaArray);
            } else {
                EnumMapLookup enumMapLookup = new EnumMapLookup(javaToCArray, cToJava);
            }
        } else {
            EnumNoLookup enumNoLookup = new EnumNoLookup(javaToCArray);
        }
        enumInfo.setRuntimeData((EnumRuntimeData)var10_14);
    }

    @Override
    protected void visitEnumValueInfo(EnumValueInfo valueInfo) {
        ResolvedJavaMethod method = valueInfo.getAnnotatedElement();
        ResolvedJavaType returnType = AccessorInfo.getReturnType(method);
        EnumInfo enumInfo = (EnumInfo)valueInfo.getParent();
        for (ElementInfo info : enumInfo.getChildren()) {
            if (!(info instanceof EnumConstantInfo)) continue;
            EnumConstantInfo constantInfo = (EnumConstantInfo)info;
            this.checkSizeAndSignedness(constantInfo, returnType, method, true);
        }
    }

    private void checkSizeAndSignedness(SizableInfo sizableInfo, ResolvedJavaType type, ResolvedJavaMethod method, boolean isReturn) {
        int actualSize;
        int declaredSize = this.getSizeInBytes(type);
        int n = actualSize = sizableInfo.isObject() ? this.getSizeInBytes(JavaKind.Object) : sizableInfo.getSizeInfo().getProperty().intValue();
        if (declaredSize != actualSize) {
            Class supressionAnnotation;
            Class clazz = supressionAnnotation = declaredSize > actualSize ^ isReturn ? AllowNarrowingCast.class : AllowWideningCast.class;
            if (method.getAnnotation(supressionAnnotation) == null) {
                this.addError("Type " + type.toJavaName(false) + " has a size of " + declaredSize + " bytes, but accessed C value has a size of " + actualSize + " bytes; to suppress this error, use the annotation @" + supressionAnnotation.getSimpleName(), method);
            }
        }
        this.checkSignedness(sizableInfo.isUnsigned(), type, method);
    }

    private void checkSignedness(boolean isUnsigned, ResolvedJavaType type, ResolvedJavaMethod method) {
        if (this.isSigned(type)) {
            if (isUnsigned) {
                this.addError("Type " + type.toJavaName(false) + " is signed, but accessed C value is unsigned", method);
            }
        } else if (this.nativeLibs.isWordBase(type) && !isUnsigned) {
            this.addError("Type " + type.toJavaName(false) + " is unsigned, but accessed C value is signed", method);
        }
    }
}

