/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.dashboard.CodeBreakdownDumper;
import com.oracle.svm.hosted.dashboard.DashboardOptions;
import com.oracle.svm.hosted.dashboard.HeapBreakdownDumper;
import com.oracle.svm.hosted.dashboard.PointsToDumper;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class DashboardDumpFeature
implements Feature {
    private final Dict dumpRoot = new Dict();

    private static boolean isHeapBreakdownDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardHeap.getValue() != false;
    }

    private static boolean isPointsToDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardPointsTo.getValue() != false;
    }

    private static boolean isCodeBreakdownDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardCode.getValue() != false;
    }

    private static void dumpToFile(Dict dumpContent, String dumpPath) {
        File file = new File(dumpPath).getAbsoluteFile();
        ReportUtils.report((String)"Dashboard dump output", (Path)file.toPath(), writer -> dumpContent.dump((PrintWriter)writer));
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return DashboardOptions.DashboardDump.getValue() != null;
    }

    public void onAnalysisExit(Feature.OnAnalysisExitAccess access) {
        if (DashboardDumpFeature.isPointsToDumped()) {
            PointsToDumper pointsToDumper = new PointsToDumper();
            Dict pointsTo = pointsToDumper.dump(access);
            this.dumpRoot.insert("points-to", pointsTo);
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        if (DashboardDumpFeature.isCodeBreakdownDumped()) {
            CodeBreakdownDumper codeBreakdownDumper = new CodeBreakdownDumper();
            Dict breakdown = codeBreakdownDumper.dump(access);
            this.dumpRoot.insert("code-breakdown", breakdown);
        }
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        if (DashboardDumpFeature.isHeapBreakdownDumped()) {
            HeapBreakdownDumper heapBreakdownDumper = new HeapBreakdownDumper();
            Dict breakdown = heapBreakdownDumper.dump(access);
            this.dumpRoot.insert("heap-breakdown", breakdown);
        }
    }

    public void cleanup() {
        DashboardDumpFeature.dumpToFile(this.dumpRoot, DashboardOptions.DashboardDump.getValue());
    }

    static class Dict {
        final LinkedHashMap<String, Object> sections = new LinkedHashMap();

        Dict() {
        }

        void insert(String key, Object value) {
            this.sections.put(key, value);
        }

        boolean hasKey(String key) {
            return this.sections.containsKey(key);
        }

        Object get(String key) {
            return this.sections.get(key);
        }

        Integer getInt(String key) {
            return (Integer)this.get(key);
        }

        Number getNumber(String key) {
            return (Number)this.get(key);
        }

        ArrayList<Object> getList(String key) {
            return (ArrayList)this.get(key);
        }

        String getString(String key) {
            return (String)this.get(key);
        }

        Dict getDict(String key) {
            return (Dict)this.get(key);
        }

        public void dump(PrintWriter writer) {
            writer.println();
            writer.println("{");
            int index = 0;
            for (Map.Entry<String, Object> entry : this.sections.entrySet()) {
                writer.print("\"");
                writer.print(Dict.escape(entry.getKey()));
                writer.print("\": ");
                Object value = entry.getValue();
                this.dumpValue(writer, value);
                if (++index < this.sections.size()) {
                    writer.print(",");
                }
                writer.println();
            }
            writer.println("}");
            writer.println();
        }

        static String escape(String input) {
            String escaped = input;
            escaped = escaped.replace("\\", "\\\\");
            escaped = escaped.replace("\"", "\\\"");
            escaped = escaped.replace("\b", "\\b");
            escaped = escaped.replace("\f", "\\f");
            escaped = escaped.replace("\n", "\\n");
            escaped = escaped.replace("\r", "\\r");
            escaped = escaped.replace("\t", "\\t");
            escaped = escaped.replace("/", "\\/");
            return escaped;
        }

        private void dumpValue(PrintWriter writer, Object value) {
            if (value instanceof Number) {
                writer.print(value);
            } else if (value instanceof String) {
                writer.print("\"");
                writer.print(Dict.escape((String)value));
                writer.print("\"");
            } else if (value instanceof ArrayList) {
                this.dumpList(writer, (ArrayList)value);
            } else if (value instanceof Dict) {
                ((Dict)value).dump(writer);
            } else if (value == null) {
                writer.print("null");
            } else {
                throw GraalError.shouldNotReachHere((String)("Unknown value: " + value + ", type: " + value.getClass()));
            }
        }

        private void dumpList(PrintWriter writer, ArrayList<Object> list) {
            writer.print("[");
            int index = 0;
            for (Object value : list) {
                this.dumpValue(writer, value);
                if (++index >= list.size()) continue;
                writer.print(", ");
            }
            writer.print("]");
        }
    }
}

