/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.NativeBootImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.Reference;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.word.WordFactory;

public class LIRNativeImageCodeCache
extends NativeImageCodeCache {
    private static final byte CODE_FILLER_BYTE = -52;
    private int codeCacheSize;

    public LIRNativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap) {
        super(compilations, imageHeap);
    }

    @Override
    public int getCodeCacheSize() {
        assert (this.codeCacheSize > 0);
        return this.codeCacheSize;
    }

    @Override
    public void layoutMethods(DebugContext debug, String imageName, BigBang bb, ForkJoinPool threadPool) {
        try (Indent indent = debug.logAndIndent("layout methods");){
            assert (this.codeCacheSize == 0);
            HostedMethod firstMethod = null;
            for (Map.Entry entry : this.compilations.entrySet()) {
                HostedMethod method = (HostedMethod)entry.getKey();
                if (firstMethod == null) {
                    firstMethod = method;
                }
                CompilationResult compilation = (CompilationResult)entry.getValue();
                this.compilationsByStart.put(this.codeCacheSize, compilation);
                method.setCodeAddressOffset(this.codeCacheSize);
                this.codeCacheSize = NumUtil.roundUp((int)(this.codeCacheSize + compilation.getTargetCodeSize()), (int)SubstrateOptions.codeAlignment());
            }
            this.buildRuntimeMetadata(MethodPointer.factory(firstMethod), WordFactory.unsigned((int)this.codeCacheSize));
        }
    }

    @Override
    public void patchMethods(DebugContext debug, RelocatableBuffer relocs, ObjectFile objectFile) {
        for (Map.Entry entry : this.compilations.entrySet()) {
            HostedMethod method = (HostedMethod)entry.getKey();
            CompilationResult compilation = (CompilationResult)entry.getValue();
            int compStart = method.getCodeAddressOffset();
            HashMap<Integer, HostedPatcher> patches = new HashMap<Integer, HostedPatcher>();
            for (CompilationResult.CodeAnnotation codeAnnotation : compilation.getCodeAnnotations()) {
                if (!(codeAnnotation instanceof HostedPatcher)) continue;
                patches.put(codeAnnotation.getPosition(), (HostedPatcher)codeAnnotation);
            }
            for (Infopoint infopoint : compilation.getInfopoints()) {
                if (!(infopoint instanceof Call) || !((Call)infopoint).direct) continue;
                Call call = (Call)infopoint;
                int callTargetStart = ((HostedMethod)call.target).getCodeAddressOffset();
                int pcDisplacement = callTargetStart - (compStart + call.pcOffset);
                ((HostedPatcher)patches.get(call.pcOffset)).patch(call.pcOffset, pcDisplacement, compilation.getTargetCode());
            }
            for (DataPatch dataPatch : compilation.getDataPatches()) {
                Reference ref = dataPatch.reference;
                ((HostedPatcher)patches.get(dataPatch.pcOffset)).relocate(ref, relocs, compStart);
            }
            try {
                DebugContext.Scope ds = debug.scope((Object)"After Patching", (Object)method.asJavaMethod());
                Throwable throwable = null;
                try {
                    debug.dump(1, (Object)compilation, "After patching");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ds.close();
                }
            }
            catch (Throwable e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    @Override
    public void writeCode(RelocatableBuffer buffer) {
        int startPos = buffer.getPosition();
        for (Map.Entry entry : this.compilations.entrySet()) {
            HostedMethod method = (HostedMethod)entry.getKey();
            CompilationResult compilation = (CompilationResult)entry.getValue();
            buffer.setPosition(startPos + method.getCodeAddressOffset());
            int codeSize = compilation.getTargetCodeSize();
            buffer.putBytes(compilation.getTargetCode(), 0, codeSize);
            for (int i = codeSize; i < NumUtil.roundUp((int)codeSize, (int)SubstrateOptions.codeAlignment()); ++i) {
                buffer.putByte((byte)-52);
            }
        }
        buffer.setPosition(startPos);
    }

    @Override
    public NativeBootImage.NativeTextSectionImpl getTextSectionImpl(RelocatableBuffer buffer, ObjectFile objectFile, NativeImageCodeCache codeCache) {
        return new NativeBootImage.NativeTextSectionImpl(buffer, objectFile, codeCache){

            @Override
            protected void defineMethodSymbol(String name, boolean global, ObjectFile.Element section, HostedMethod method, CompilationResult result) {
                int size = result == null ? 0 : result.getTargetCodeSize();
                this.objectFile.createDefinedSymbol(name, section, (long)method.getCodeAddressOffset(), size, true, global);
            }
        };
    }

    @Override
    public List<ObjectFile.Symbol> getSymbols(ObjectFile objectFile, boolean onlyGlobal) {
        Stream<ObjectFile.Symbol> stream = StreamSupport.stream(objectFile.getSymbolTable().spliterator(), false);
        if (onlyGlobal) {
            stream = stream.filter(ObjectFile.Symbol::isGlobal);
        }
        return stream.filter(ObjectFile.Symbol::isDefined).collect(Collectors.toList());
    }
}

