/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image.sources;

import com.oracle.svm.hosted.image.sources.SourceCache;
import com.oracle.svm.hosted.image.sources.SourceCacheType;
import com.oracle.svm.util.ModuleSupport;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import jdk.vm.ci.meta.ResolvedJavaType;

public class SourceManager {
    public static final String[] JDK_SRC_PACKAGE_PREFIXES = new String[]{"java.", "jdk.", "javax.", "sun.", "com.sun.", "org.ietf.", "org.jcp.", "org.omg.", "org.w3c.", "org.xml"};
    public static final String[] GRAALVM_SRC_PACKAGE_PREFIXES = new String[]{"com.oracle.graal.", "com.oracle.objectfile.", "com.oracle.svm.", "com.oracle.truffle.", "org.graalvm."};
    private static HashMap<SourceCacheType, SourceCache> caches = new HashMap();
    private static HashMap<ResolvedJavaType, Path> verifiedPaths = new HashMap();
    private static final Path INVALID_PATH = Paths.get("invalid", new String[0]);

    public Path findAndCacheSource(ResolvedJavaType resolvedType, Class<?> clazz) {
        SourceCacheType sourceCacheType;
        String packageName;
        Path path = verifiedPaths.get(resolvedType);
        if (path != null) {
            return path != INVALID_PATH ? path : null;
        }
        String fileName = SourceManager.computeBaseName(resolvedType);
        if (fileName != null && (resolvedType.isInstanceClass() || resolvedType.isInterface()) && (path = SourceManager.locateSource(fileName, packageName = SourceManager.computePackageName(resolvedType), sourceCacheType = SourceManager.sourceCacheType(packageName), clazz)) == null && packageName.length() > 0) {
            path = Paths.get("", packageName.split("\\."));
            path = path.resolve(fileName);
        }
        verifiedPaths.put(resolvedType, path != null ? path : INVALID_PATH);
        return path;
    }

    private static String computeBaseName(ResolvedJavaType resolvedType) {
        String fileName = resolvedType.getSourceFileName();
        if (fileName == null) {
            fileName = resolvedType.toJavaName();
            int idx = fileName.lastIndexOf(46);
            if (idx > 0) {
                fileName = fileName.substring(idx + 1);
            }
            if ((idx = fileName.indexOf(36)) == 0) {
                fileName = null;
            } else {
                if (idx > 0) {
                    fileName = fileName.substring(0, idx);
                }
                fileName = fileName + ".java";
            }
        }
        return fileName;
    }

    private static String computePackageName(ResolvedJavaType javaType) {
        String name = javaType.toClassName();
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            return name.substring(0, idx);
        }
        return "";
    }

    private static Path computePrototypeName(String fileName, String packageName, SourceCacheType sourceCacheType, Class<?> clazz) {
        String moduleName;
        String prefix = "";
        if (sourceCacheType == SourceCacheType.JDK && clazz != null && (moduleName = ModuleSupport.getModuleName(clazz)) != null) {
            prefix = moduleName;
        }
        if (packageName.length() == 0) {
            return Paths.get("", fileName);
        }
        return Paths.get(prefix, packageName.split("\\.")).resolve(fileName);
    }

    private static boolean whiteListPackage(String packageName, String[] whitelist) {
        for (String prefix : whitelist) {
            if (!packageName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static SourceCacheType sourceCacheType(String packageName) {
        if (SourceManager.whiteListPackage(packageName, JDK_SRC_PACKAGE_PREFIXES)) {
            return SourceCacheType.JDK;
        }
        if (SourceManager.whiteListPackage(packageName, GRAALVM_SRC_PACKAGE_PREFIXES)) {
            return SourceCacheType.GRAALVM;
        }
        return SourceCacheType.APPLICATION;
    }

    private static SourceCache getOrCreateCache(SourceCacheType type) {
        SourceCache sourceCache = caches.get((Object)type);
        if (sourceCache == null) {
            sourceCache = SourceCache.createSourceCache(type);
            caches.put(type, sourceCache);
        }
        return sourceCache;
    }

    private static Path locateSource(String fileName, String packagename, SourceCacheType cacheType, Class<?> clazz) {
        SourceCache cache = SourceManager.getOrCreateCache(cacheType);
        Path prototypeName = SourceManager.computePrototypeName(fileName, packagename, cacheType, clazz);
        if (prototypeName != null) {
            return cache.resolve(prototypeName);
        }
        return null;
    }
}

