/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class JNINativeLinkage {
    private PointerBase entryPoint = WordFactory.nullPointer();
    private final String declaringClass;
    private final String name;
    private final String descriptor;
    private CGlobalDataInfo builtInAddress = null;

    public JNINativeLinkage(String declaringClass, String name, String descriptor) {
        assert (declaringClass.startsWith("L") && declaringClass.endsWith(";")) : declaringClass;
        this.declaringClass = declaringClass;
        this.name = name;
        this.descriptor = descriptor;
    }

    public String getDeclaringClassName() {
        return this.declaringClass;
    }

    public boolean isBuiltInFunction() {
        return PlatformNativeLibrarySupport.singleton().isBuiltinPkgNative(this.getShortName());
    }

    public CGlobalDataInfo getBuiltInAddress() {
        assert (this.isBuiltInFunction());
        if (this.builtInAddress == null) {
            CGlobalData linkage = CGlobalDataFactory.forSymbol(this.getShortName());
            this.builtInAddress = CGlobalDataFeature.singleton().registerAsAccessedOrGet(linkage);
        }
        return this.builtInAddress;
    }

    public void setEntryPoint(CFunctionPointer fnptr) {
        this.entryPoint = fnptr;
    }

    public void unsetEntryPoint() {
        this.entryPoint = WordFactory.nullPointer();
    }

    public int hashCode() {
        return (this.name.hashCode() * 31 + this.descriptor.hashCode()) * 31 + this.declaringClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JNINativeLinkage) {
            JNINativeLinkage that = (JNINativeLinkage)obj;
            return that == this || this.declaringClass.equals(that.declaringClass) && this.name.equals(that.name) && this.descriptor.equals(that.descriptor);
        }
        return false;
    }

    public String toString() {
        String shortName = this.getShortName();
        return MetaUtil.internalNameToJava((String)this.declaringClass, (boolean)true, (boolean)false) + "." + this.name + this.descriptor + " [symbol: " + shortName + " or " + shortName + "__" + this.getSignature() + "]";
    }

    public PointerBase getOrFindEntryPoint() {
        if (this.entryPoint.isNull()) {
            String shortName = this.getShortName();
            this.entryPoint = NativeLibrarySupport.singleton().findSymbol(shortName);
            if (this.entryPoint.isNull()) {
                String longName = shortName + "__" + this.getSignature();
                this.entryPoint = NativeLibrarySupport.singleton().findSymbol(longName);
                if (this.entryPoint.isNull()) {
                    throw new UnsatisfiedLinkError(this.toString());
                }
            }
        }
        return this.entryPoint;
    }

    private String getShortName() {
        StringBuilder sb = new StringBuilder("Java_");
        JNINativeLinkage.mangleName(this.declaringClass, 1, this.declaringClass.length() - 1, sb);
        sb.append('_');
        JNINativeLinkage.mangleName(this.name, 0, this.name.length(), sb);
        return sb.toString();
    }

    private String getSignature() {
        int closing = this.descriptor.indexOf(41);
        assert (this.descriptor.startsWith("(") && this.descriptor.indexOf(41) == closing && closing != -1);
        return JNINativeLinkage.mangleName(this.descriptor, 1, closing, new StringBuilder()).toString();
    }

    private static StringBuilder mangleName(String name, int beginIndex, int endIndex, StringBuilder sb) {
        block6: for (int i = beginIndex; i < endIndex; ++i) {
            char c = name.charAt(i);
            if (c <= '\u007f' && Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            switch (c) {
                case '/': {
                    sb.append("_");
                    continue block6;
                }
                case '_': {
                    sb.append("_1");
                    continue block6;
                }
                case ';': {
                    sb.append("_2");
                    continue block6;
                }
                case '[': {
                    sb.append("_3");
                    continue block6;
                }
                default: {
                    sb.append('_');
                    String hex = Integer.toHexString(c);
                    for (int j = hex.length(); j < 5; ++j) {
                        sb.append('0');
                    }
                    sb.append(hex);
                }
            }
        }
        return sb;
    }

    public static String mangle(String s) {
        return JNINativeLinkage.mangleName(s, 0, s.length(), new StringBuilder()).toString();
    }
}

