/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoImpl;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTether;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ReusableTypeReader;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.util.TypeReader;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class CodeInfoAccess {
    private CodeInfoAccess() {
    }

    @Fold
    static boolean haveAssertions() {
        return SubstrateOptions.getRuntimeAssertionsForClass(CodeInfoAccess.class.getName());
    }

    @Uninterruptible(reason="The handle should only be accessed from uninterruptible code to prevent that the GC frees the CodeInfo.", callerMustBe=true)
    public static Object acquireTether(UntetheredCodeInfo info) {
        Object tether = UntetheredCodeInfoAccess.getTetherUnsafe(info);
        assert (VMOperation.isGCInProgress() || ((CodeInfoTether)tether).incrementCount() > 0);
        return tether;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @NeverInline(value="Prevent elimination of object reference in caller.")
    public static void releaseTether(UntetheredCodeInfo info, Object tether) {
        assert (VMOperation.isGCInProgress() || UntetheredCodeInfoAccess.getTetherUnsafe(info) == null || UntetheredCodeInfoAccess.getTetherUnsafe(info) == tether);
        assert (VMOperation.isGCInProgress() || ((CodeInfoTether)tether).decrementCount() >= 0);
    }

    @Uninterruptible(reason="Called during teardown.", callerMustBe=true)
    @NeverInline(value="Prevent elimination of object reference in caller.")
    public static void releaseTetherUnsafe(UntetheredCodeInfo info, Object tether) {
        assert (VMOperation.isGCInProgress() || ((CodeInfoTether)tether).decrementCount() >= 0);
    }

    @Uninterruptible(reason="Should be called from the same method as acquireTether.", callerMustBe=true)
    public static CodeInfo convert(UntetheredCodeInfo untetheredInfo, Object tether) {
        assert (UntetheredCodeInfoAccess.getTetherUnsafe(untetheredInfo) == null || UntetheredCodeInfoAccess.getTetherUnsafe(untetheredInfo) == tether);
        return CodeInfoAccess.convert(untetheredInfo);
    }

    @Uninterruptible(reason="Called by uninterruptible code.", mayBeInlined=true)
    public static CodeInfo convert(UntetheredCodeInfo untetheredInfo) {
        assert (CodeInfoAccess.isValid(untetheredInfo));
        return (CodeInfo)untetheredInfo;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isValid(UntetheredCodeInfo info) {
        return SubstrateUtil.HOSTED || !CodeInfoAccess.haveAssertions() || VMOperation.isGCInProgress() || UntetheredCodeInfoAccess.getTetherUnsafe(info) == null || ((CodeInfoTether)UntetheredCodeInfoAccess.getTetherUnsafe(info)).getCount() > 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public static void setState(CodeInfo info, int state) {
        assert (CodeInfoAccess.getState(info) < state);
        CodeInfoAccess.cast(info).setState(state);
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public static int getState(CodeInfo info) {
        return CodeInfoAccess.cast(info).getState();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CodePointer getCodeStart(CodeInfo info) {
        return CodeInfoAccess.cast(info).getCodeStart();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getCodeSize(CodeInfo info) {
        return CodeInfoAccess.cast(info).getCodeSize();
    }

    public static UnsignedWord getMetadataSize(CodeInfo info) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        return SizeOf.unsigned(CodeInfo.class).add(NonmovableArrays.byteSizeOf(impl.getObjectFields())).add(NonmovableArrays.byteSizeOf(impl.getCodeInfoIndex())).add(NonmovableArrays.byteSizeOf(impl.getCodeInfoEncodings())).add(NonmovableArrays.byteSizeOf(impl.getReferenceMapEncoding())).add(NonmovableArrays.byteSizeOf(impl.getFrameInfoEncodings())).add(NonmovableArrays.byteSizeOf(impl.getFrameInfoObjectConstants())).add(NonmovableArrays.byteSizeOf(impl.getFrameInfoSourceClasses())).add(NonmovableArrays.byteSizeOf(impl.getFrameInfoSourceMethodNames())).add(NonmovableArrays.byteSizeOf(impl.getFrameInfoNames())).add(NonmovableArrays.byteSizeOf(impl.getDeoptimizationStartOffsets())).add(NonmovableArrays.byteSizeOf(impl.getDeoptimizationEncodings())).add(NonmovableArrays.byteSizeOf(impl.getDeoptimizationObjectConstants())).add(NonmovableArrays.byteSizeOf(impl.getObjectsReferenceMapEncoding()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean contains(CodeInfo info, CodePointer ip) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        return ((UnsignedWord)ip).subtract((UnsignedWord)impl.getCodeStart()).belowThan(impl.getCodeSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long relativeIP(CodeInfo info, CodePointer ip) {
        assert (CodeInfoAccess.contains(info, ip));
        return ((UnsignedWord)ip).subtract((UnsignedWord)CodeInfoAccess.cast(info).getCodeStart()).rawValue();
    }

    public static CodePointer absoluteIP(CodeInfo info, long relativeIP) {
        return (CodePointer)((UnsignedWord)CodeInfoAccess.cast(info).getCodeStart()).add(WordFactory.unsigned((long)relativeIP));
    }

    public static long initFrameInfoReader(CodeInfo info, CodePointer ip, ReusableTypeReader frameInfoReader) {
        long entryOffset = CodeInfoDecoder.lookupCodeInfoEntryOffset(info, CodeInfoAccess.relativeIP(info, ip));
        if (entryOffset >= 0L && !CodeInfoDecoder.initFrameInfoReader(info, entryOffset, frameInfoReader)) {
            return -1L;
        }
        return entryOffset;
    }

    public static FrameInfoQueryResult nextFrameInfo(CodeInfo info, long entryOffset, ReusableTypeReader frameInfoReader, FrameInfoDecoder.FrameInfoQueryResultAllocator resultAllocator, FrameInfoDecoder.ValueInfoAllocator valueInfoAllocator, boolean fetchFirstFrame) {
        int entryFlags = CodeInfoDecoder.loadEntryFlags(info, entryOffset);
        boolean isDeoptEntry = CodeInfoDecoder.extractFI(entryFlags) == 1;
        return FrameInfoDecoder.decodeFrameInfo(isDeoptEntry, (TypeReader)frameInfoReader, info, resultAllocator, valueInfoAllocator, fetchFirstFrame);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static <T> T getObjectField(CodeInfo info, int index) {
        return (T)NonmovableArrays.getObject(CodeInfoAccess.cast(info).getObjectFields(), index);
    }

    public static String getName(CodeInfo info) {
        return (String)CodeInfoAccess.getObjectField(info, 1);
    }

    public static long lookupDeoptimizationEntrypoint(CodeInfo info, long method, long encodedBci, CodeInfoQueryResult codeInfo) {
        return CodeInfoDecoder.lookupDeoptimizationEntrypoint(info, method, encodedBci, codeInfo);
    }

    public static long lookupTotalFrameSize(CodeInfo info, long ip) {
        SimpleCodeInfoQueryResult codeInfoQueryResult = (SimpleCodeInfoQueryResult)StackValue.get(SimpleCodeInfoQueryResult.class);
        CodeInfoAccess.lookupCodeInfo(info, ip, codeInfoQueryResult);
        return CodeInfoQueryResult.getTotalFrameSize(codeInfoQueryResult.getEncodedFrameSize());
    }

    public static NonmovableArray<Byte> getReferenceMapEncoding(CodeInfo info) {
        return CodeInfoAccess.cast(info).getReferenceMapEncoding();
    }

    public static long lookupReferenceMapIndex(CodeInfo info, long ip) {
        return CodeInfoDecoder.lookupReferenceMapIndex(info, ip);
    }

    public static void lookupCodeInfo(CodeInfo info, long ip, CodeInfoQueryResult codeInfoQueryResult) {
        CodeInfoDecoder.lookupCodeInfo(info, ip, codeInfoQueryResult);
    }

    public static void lookupCodeInfo(CodeInfo info, long ip, SimpleCodeInfoQueryResult codeInfoQueryResult) {
        CodeInfoDecoder.lookupCodeInfo(info, ip, codeInfoQueryResult);
    }

    @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed.")
    public static void setFrameInfo(CodeInfo info, NonmovableArray<Byte> encodings, NonmovableObjectArray<Object> objectConstants, NonmovableObjectArray<Class<?>> sourceClasses, NonmovableObjectArray<String> sourceMethodNames, NonmovableObjectArray<String> names) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        impl.setFrameInfoEncodings(encodings);
        impl.setFrameInfoObjectConstants(objectConstants);
        impl.setFrameInfoSourceClasses(sourceClasses);
        impl.setFrameInfoSourceMethodNames(sourceMethodNames);
        impl.setFrameInfoNames(names);
    }

    public static void setCodeInfo(CodeInfo info, NonmovableArray<Byte> index, NonmovableArray<Byte> encodings, NonmovableArray<Byte> referenceMapEncoding) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        impl.setCodeInfoIndex(index);
        impl.setCodeInfoEncodings(encodings);
        impl.setReferenceMapEncoding(referenceMapEncoding);
    }

    public static Log log(CodeInfo info, Log log) {
        return info.isNull() ? log.string("null") : log.string(CodeInfo.class.getName()).string("@").hex((WordBase)info);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getTier(CodeInfo info) {
        return CodeInfoAccess.cast(info).getTier();
    }

    static NonmovableArray<Integer> getDeoptimizationStartOffsets(CodeInfo info) {
        return CodeInfoAccess.cast(info).getDeoptimizationStartOffsets();
    }

    static NonmovableArray<Byte> getDeoptimizationEncodings(CodeInfo info) {
        return CodeInfoAccess.cast(info).getDeoptimizationEncodings();
    }

    static NonmovableObjectArray<Object> getDeoptimizationObjectConstants(CodeInfo info) {
        return CodeInfoAccess.cast(info).getDeoptimizationObjectConstants();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static CodePointer getCodeEnd(CodeInfo info) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        return (CodePointer)((UnsignedWord)impl.getCodeStart()).add(impl.getCodeSize());
    }

    public static NonmovableArray<Byte> getCodeInfoIndex(CodeInfo info) {
        return CodeInfoAccess.cast(info).getCodeInfoIndex();
    }

    public static NonmovableArray<Byte> getCodeInfoEncodings(CodeInfo info) {
        return CodeInfoAccess.cast(info).getCodeInfoEncodings();
    }

    public static NonmovableArray<Byte> getFrameInfoEncodings(CodeInfo info) {
        return CodeInfoAccess.cast(info).getFrameInfoEncodings();
    }

    public static NonmovableObjectArray<Object> getFrameInfoObjectConstants(CodeInfo info) {
        return CodeInfoAccess.cast(info).getFrameInfoObjectConstants();
    }

    public static NonmovableObjectArray<Class<?>> getFrameInfoSourceClasses(CodeInfo info) {
        return CodeInfoAccess.cast(info).getFrameInfoSourceClasses();
    }

    public static NonmovableObjectArray<String> getFrameInfoSourceMethodNames(CodeInfo info) {
        return CodeInfoAccess.cast(info).getFrameInfoSourceMethodNames();
    }

    public static NonmovableObjectArray<String> getFrameInfoNames(CodeInfo info) {
        return CodeInfoAccess.cast(info).getFrameInfoNames();
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    private static CodeInfoImpl cast(UntetheredCodeInfo info) {
        assert (CodeInfoAccess.isValid(info));
        return (CodeInfoImpl)info;
    }
}

