/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoMemoryWalker;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.InstalledCodeObserverSupport;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.RingBuffer;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class RuntimeCodeCache {
    private final RingBuffer<CodeCacheLogEntry> recentCodeCacheOperations = new RingBuffer<CodeCacheLogEntry>(30, () -> new CodeCacheLogEntry());
    private long codeCacheOperationSequenceNumber;
    private final Counter.Group counters = new Counter.Group(CodeInfoTable.Options.CodeCacheCounters, "RuntimeCodeInfo");
    private final Counter lookupMethodCount = new Counter(this.counters, "lookupMethod", "");
    private final Counter addMethodCount = new Counter(this.counters, "addMethod", "");
    private final Counter invalidateMethodCount = new Counter(this.counters, "invalidateMethod", "");
    private final CodeNotOnStackVerifier codeNotOnStackVerifier = new CodeNotOnStackVerifier();
    static final String INFO_ADD = "Add";
    static final String INFO_INVALIDATE = "Invalidate";
    private static final int INITIAL_TABLE_SIZE = 100;
    private NonmovableArray<UntetheredCodeInfo> codeInfos;
    private int numCodeInfos;
    private static final RingBuffer.Consumer<CodeCacheLogEntry> consumer = (context, e) -> e.log(Log.log());

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeCodeCache() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void tearDown() {
        NonmovableArrays.releaseUnmanagedArray(this.codeInfos);
        this.codeInfos = NonmovableArrays.nullArray();
        RuntimeCodeInfoMemory.singleton().tearDown();
    }

    @Uninterruptible(reason="codeInfos is accessed without holding a lock, so must not be interrupted by a safepoint that can add/remove code", callerMustBe=true)
    protected UntetheredCodeInfo lookupCodeInfo(CodePointer ip) {
        this.lookupMethodCount.inc();
        assert (this.verifyTable());
        if (this.numCodeInfos == 0) {
            return (UntetheredCodeInfo)WordFactory.nullPointer();
        }
        int idx = RuntimeCodeCache.binarySearch(this.codeInfos, 0, this.numCodeInfos, ip);
        if (idx >= 0) {
            return NonmovableArrays.getWord(this.codeInfos, idx);
        }
        int insertionPoint = -idx - 1;
        if (insertionPoint == 0) {
            assert (((UnsignedWord)ip).belowThan((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(this.codeInfos, 0))));
            return (UntetheredCodeInfo)WordFactory.nullPointer();
        }
        UntetheredCodeInfo info = NonmovableArrays.getWord(this.codeInfos, insertionPoint - 1);
        assert (((UnsignedWord)ip).aboveThan((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(info)));
        if (((UnsignedWord)ip).subtract((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(info)).aboveOrEqual(UntetheredCodeInfoAccess.getCodeSize(info))) {
            return (UntetheredCodeInfo)WordFactory.nullPointer();
        }
        return info;
    }

    @Uninterruptible(reason="called from uninterruptible code")
    private static int binarySearch(NonmovableArray<UntetheredCodeInfo> a, int fromIndex, int toIndex, CodePointer key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CodePointer midVal = UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(a, mid));
            if (((UnsignedWord)midVal).belowThan((UnsignedWord)key)) {
                low = mid + 1;
                continue;
            }
            if (((UnsignedWord)midVal).aboveThan((UnsignedWord)key)) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void addMethod(CodeInfo info) {
        VMOperation.guaranteeInProgressAtSafepoint("Modifying code tables that are used by the GC");
        InstalledCodeObserverSupport.activateObservers(RuntimeCodeInfoAccess.getCodeObserverHandles(info));
        long num = this.logMethodOperation(info, INFO_ADD);
        this.addMethodOperation(info);
        this.logMethodOperationEnd(num);
    }

    private void addMethodOperation(CodeInfo info) {
        this.addMethodCount.inc();
        assert (this.verifyTable());
        if (Options.TraceCodeCache.getValue().booleanValue()) {
            Log.log().string("[Add method: ");
            RuntimeCodeCache.logCodeInfo(Log.log(), info);
            Log.log().string("]").newline();
        }
        if (this.codeInfos.isNull() || this.numCodeInfos >= NonmovableArrays.lengthOf(this.codeInfos)) {
            this.enlargeTable();
            assert (this.verifyTable());
        }
        assert (this.numCodeInfos < NonmovableArrays.lengthOf(this.codeInfos));
        int idx = RuntimeCodeCache.binarySearch(this.codeInfos, 0, this.numCodeInfos, CodeInfoAccess.getCodeStart(info));
        assert (idx < 0) : "must not find code already in table";
        int insertionPoint = -idx - 1;
        NonmovableArrays.arraycopy(this.codeInfos, insertionPoint, this.codeInfos, insertionPoint + 1, this.numCodeInfos - insertionPoint);
        ++this.numCodeInfos;
        NonmovableArrays.setWord(this.codeInfos, insertionPoint, info);
        if (Options.TraceCodeCache.getValue().booleanValue()) {
            this.logTable();
        }
        assert (this.verifyTable());
    }

    private void enlargeTable() {
        int newTableSize = this.numCodeInfos * 2;
        if (newTableSize < 100) {
            newTableSize = 100;
        }
        NonmovableArray newCodeInfos = NonmovableArrays.createWordArray(newTableSize);
        if (this.codeInfos.isNonNull()) {
            NonmovableArrays.arraycopy(this.codeInfos, 0, newCodeInfos, 0, NonmovableArrays.lengthOf(this.codeInfos));
            NonmovableArrays.releaseUnmanagedArray(this.codeInfos);
        }
        this.codeInfos = newCodeInfos;
    }

    protected void invalidateMethod(CodeInfo info) {
        this.prepareInvalidation(info);
        Deoptimizer.deoptimizeInRange(CodeInfoAccess.getCodeStart(info), CodeInfoAccess.getCodeEnd(info), false);
        this.finishInvalidation(info);
    }

    protected void invalidateNonStackMethod(CodeInfo info) {
        this.prepareInvalidation(info);
        assert (this.codeNotOnStackVerifier.verify(info));
        this.finishInvalidation(info);
    }

    private void prepareInvalidation(CodeInfo info) {
        SubstrateInstalledCode installedCode;
        VMOperation.guaranteeInProgressAtSafepoint("Modifying code tables that are used by the GC");
        this.invalidateMethodCount.inc();
        assert (this.verifyTable());
        if (Options.TraceCodeCache.getValue().booleanValue()) {
            Log.log().string("[Invalidate method: ");
            RuntimeCodeCache.logCodeInfo(Log.log(), info);
            Log.log().string("]").newline();
        }
        if ((installedCode = RuntimeCodeInfoAccess.getInstalledCode(info)) != null) {
            assert (!installedCode.isValid() || CodeInfoAccess.getCodeStart(info).rawValue() == installedCode.getAddress());
            installedCode.clearAddress();
        }
    }

    private void finishInvalidation(CodeInfo info) {
        int idx = RuntimeCodeCache.binarySearch(this.codeInfos, 0, this.numCodeInfos, CodeInfoAccess.getCodeStart(info));
        assert (idx >= 0) : "info must be in table";
        NonmovableArrays.arraycopy(this.codeInfos, idx + 1, this.codeInfos, idx, this.numCodeInfos - (idx + 1));
        --this.numCodeInfos;
        NonmovableArrays.setWord(this.codeInfos, this.numCodeInfos, WordFactory.nullPointer());
        RuntimeCodeInfoAccess.partialReleaseAfterInvalidate(info);
        if (Options.TraceCodeCache.getValue().booleanValue()) {
            this.logTable();
        }
        assert (this.verifyTable());
    }

    @Uninterruptible(reason="called from uninterruptible code")
    private boolean verifyTable() {
        int i;
        if (this.codeInfos.isNull()) {
            assert (this.numCodeInfos == 0) : "a1";
            return true;
        }
        assert (this.numCodeInfos <= NonmovableArrays.lengthOf(this.codeInfos)) : "a11";
        for (i = 0; i < this.numCodeInfos; ++i) {
            UntetheredCodeInfo info = NonmovableArrays.getWord(this.codeInfos, i);
            assert (info.isNonNull()) : "a20";
            assert (i == 0 || ((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(this.codeInfos, i - 1))).belowThan((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(NonmovableArrays.getWord(this.codeInfos, i)))) : "a22";
            assert (i == 0 || ((UnsignedWord)UntetheredCodeInfoAccess.getCodeEnd(NonmovableArrays.getWord(this.codeInfos, i - 1))).belowOrEqual((UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(info))) : "a23";
        }
        for (i = this.numCodeInfos; i < NonmovableArrays.lengthOf(this.codeInfos); ++i) {
            assert (NonmovableArrays.getWord(this.codeInfos, i).isNull()) : "a31";
        }
        return true;
    }

    public void logTable() {
        this.logTable(Log.log());
    }

    public void logRecentOperations(Log log) {
        log.string("== [Recent RuntimeCodeCache operations: ");
        this.recentCodeCacheOperations.foreach(consumer);
        log.string("]").newline();
    }

    public void logTable(Log log) {
        log.string("== [RuntimeCodeCache: ").signed(this.numCodeInfos).string(" methods");
        for (int i = 0; i < this.numCodeInfos; ++i) {
            this.logCodeInfo(log, i);
        }
        log.string("]").newline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.")
    private void logCodeInfo(Log log, int i) {
        UntetheredCodeInfo untetheredInfo = NonmovableArrays.getWord(this.codeInfos, i);
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
            RuntimeCodeCache.logCodeInfo0(log, info);
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    @Uninterruptible(reason="Pass the now protected CodeInfo to interruptible code.", calleeMustBe=false)
    private static void logCodeInfo0(Log log, CodeInfo info) {
        log.newline().hex((WordBase)CodeInfoAccess.getCodeStart(info)).string("  ");
        RuntimeCodeCache.logCodeInfo(log, info);
    }

    private static void logCodeInfo(Log log, CodeInfo info) {
        RuntimeCodeCache.logCodeInfo(log, CodeInfoAccess.getName(info), CodeInfoAccess.getCodeStart(info), CodeInfoAccess.getCodeEnd(info), CodeInfoAccess.getCodeSize(info));
    }

    private static void logCodeInfo(Log log, String codeName, CodePointer codeStart, CodePointer codeEnd, UnsignedWord codeSize) {
        log.string(codeName);
        log.string("  ip: ").hex((WordBase)codeStart).string(" - ").hex((WordBase)codeEnd);
        log.string("  size: ").unsigned((WordBase)codeSize);
    }

    long logMethodOperation(CodeInfo info, String kind) {
        long current = ++this.codeCacheOperationSequenceNumber;
        this.recentCodeCacheOperations.next().setValues(current, kind, CodeInfoAccess.getName(info), CodeInfoAccess.getCodeStart(info), CodeInfoAccess.getCodeEnd(info), CodeInfoAccess.getCodeSize(info));
        return current;
    }

    void logMethodOperationEnd(long operationNumber) {
        this.recentCodeCacheOperations.next().setValues(operationNumber, null, null, (CodePointer)WordFactory.nullPointer(), (CodePointer)WordFactory.nullPointer(), WordFactory.unsigned((int)0));
    }

    public boolean walkRuntimeMethods(MemoryWalker.Visitor visitor) {
        VMOperation.guaranteeInProgress("Modifying code tables that are used by the GC");
        boolean continueVisiting = true;
        for (int i = 0; continueVisiting && i < this.numCodeInfos; ++i) {
            continueVisiting = this.walkRuntimeMethod(visitor, i);
        }
        return continueVisiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.")
    private boolean walkRuntimeMethod(MemoryWalker.Visitor visitor, int i) {
        boolean continueVisiting;
        UntetheredCodeInfo untetheredInfo = NonmovableArrays.getWord(this.codeInfos, i);
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo codeInfo = CodeInfoAccess.convert(untetheredInfo, tether);
            continueVisiting = RuntimeCodeCache.visitRuntimeMethod0(visitor, codeInfo);
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
        return continueVisiting;
    }

    @Uninterruptible(reason="Pass the now protected CodeInfo to interruptible code.", calleeMustBe=false)
    private static boolean visitRuntimeMethod0(MemoryWalker.Visitor visitor, CodeInfo codeInfo) {
        return visitor.visitCode(codeInfo, (MemoryWalker.CodeAccess)ImageSingletons.lookup(CodeInfoMemoryWalker.class));
    }

    public static interface CodeInfoVisitor {
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting code.")
        public <T extends CodeInfo> boolean visitCode(T var1);
    }

    private static final class CodeNotOnStackVerifier
    extends StackFrameVisitor {
        private CodeInfo codeInfoToCheck;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        CodeNotOnStackVerifier() {
        }

        @NeverInline(value="Starting a stack walk.")
        public boolean verify(CodeInfo info) {
            this.codeInfoToCheck = info;
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            JavaStackWalker.walkCurrentThread(sp, this);
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (vmThread != CurrentIsolate.getCurrentThread()) {
                        JavaStackWalker.walkThread(vmThread, this);
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
            return true;
        }

        @Override
        public boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo currentCodeInfo, DeoptimizedFrame deoptimizedFrame) {
            assert (currentCodeInfo != this.codeInfoToCheck);
            return true;
        }
    }

    private static class CodeCacheLogEntry {
        private long sequenceNumber;
        private String kind;
        private String codeName;
        private CodePointer codeStart;
        private CodePointer codeEnd;
        private UnsignedWord codeSize;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        CodeCacheLogEntry() {
        }

        public void setValues(long sequenceNumber, String kind, String codeName, CodePointer codeStart, CodePointer codeEnd, UnsignedWord codeSize) {
            this.sequenceNumber = sequenceNumber;
            this.kind = kind;
            this.codeName = codeName;
            this.codeStart = codeStart;
            this.codeEnd = codeEnd;
            this.codeSize = codeSize;
        }

        public void log(Log log) {
            log.newline();
            if (this.kind != null) {
                log.string(this.kind).string(": ");
                RuntimeCodeCache.logCodeInfo(log, this.codeName, this.codeStart, this.codeEnd, this.codeSize);
                log.string(" ").unsigned(this.sequenceNumber).string(":{");
            } else {
                log.string("}:").unsigned(this.sequenceNumber);
            }
        }
    }

    public static class Options {
        @Option(help={"Print logging information for runtime code cache modifications"})
        public static final RuntimeOptionKey<Boolean> TraceCodeCache = new RuntimeOptionKey<Boolean>(false);
        @Option(help={"Allocate code cache with write access, allowing inlining of objects"}, type=OptionType.Expert)
        public static final RuntimeOptionKey<Boolean> WriteableCodeCache = new RuntimeOptionKey<Boolean>(false);
    }
}

