/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.deopt.DeoptimizationCounters;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.log.StringBuilderLog;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.RingBuffer;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.util.ArrayList;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;
import sun.misc.Unsafe;

public final class Deoptimizer {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private static final RingBuffer<char[]> recentDeoptimizationEvents = new RingBuffer();
    private static final int actionShift = 0;
    private static final int actionBits = 32 - Integer.numberOfLeadingZeros(DeoptimizationAction.values().length);
    private static final int reasonShift = 0 + actionBits;
    private static final int reasonBits = 32 - Integer.numberOfLeadingZeros(DeoptimizationReason.values().length);
    private static final int idShift = reasonShift + reasonBits;
    private static final int idBits = 32;
    public static boolean testGCinDeoptimizer;
    int endOfParams;
    private final CodeInfoQueryResult sourceChunk;
    private final Pointer sourceSp;
    private Object[] materializedObjects;
    private ArrayList<DeoptimizedFrame.RelockObjectData> relockedObjects;
    protected int targetContentSize;
    protected static long deoptStubFrameSize;
    private static final RingBuffer.Consumer<char[]> deoptEventsConsumer;

    public static long encodeDeoptActionAndReasonToLong(DeoptimizationAction action, DeoptimizationReason reason, int speculationId) {
        return (long)action.ordinal() << 0 | (long)reason.ordinal() << reasonShift | (long)speculationId << idShift;
    }

    public static JavaConstant encodeDeoptActionAndReason(DeoptimizationAction action, DeoptimizationReason reason, int speculationId) {
        PrimitiveConstant result = JavaConstant.forLong((long)Deoptimizer.encodeDeoptActionAndReasonToLong(action, reason, speculationId));
        assert (Deoptimizer.decodeDeoptAction((JavaConstant)result) == action);
        assert (Deoptimizer.decodeDeoptReason((JavaConstant)result) == reason);
        assert (Deoptimizer.decodeDebugId((JavaConstant)result) == speculationId);
        return result;
    }

    public static DeoptimizationAction decodeDeoptAction(long actionAndReason) {
        return DeoptimizationAction.values()[(int)(actionAndReason >> 0 & (1L << actionBits) - 1L)];
    }

    public static DeoptimizationReason decodeDeoptReason(long actionAndReason) {
        return DeoptimizationReason.values()[(int)(actionAndReason >> reasonShift & (1L << reasonBits) - 1L)];
    }

    public static int decodeDebugId(long actionAndReason) {
        return (int)(actionAndReason >> idShift & 0xFFFFFFFFL);
    }

    public static DeoptimizationAction decodeDeoptAction(JavaConstant actionAndReason) {
        return Deoptimizer.decodeDeoptAction(actionAndReason.asLong());
    }

    public static DeoptimizationReason decodeDeoptReason(JavaConstant actionAndReason) {
        return Deoptimizer.decodeDeoptReason(actionAndReason.asLong());
    }

    public static int decodeDebugId(JavaConstant actionAndReason) {
        return Deoptimizer.decodeDebugId(actionAndReason.asLong());
    }

    private static boolean checkEncoding() {
        for (DeoptimizationAction action : DeoptimizationAction.values()) {
            for (DeoptimizationReason reason : DeoptimizationReason.values()) {
                for (int speculationId : new int[]{0, 1, -1, Integer.MIN_VALUE, Integer.MAX_VALUE}) {
                    Deoptimizer.encodeDeoptActionAndReason(action, reason, speculationId);
                }
            }
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static DeoptimizedFrame checkDeoptimized(Pointer sourceSp) {
        CodePointer returnAddress;
        if (DeoptimizationSupport.enabled() && (returnAddress = FrameAccess.singleton().readReturnAddress(sourceSp)).equal((ComparableWord)DeoptimizationSupport.getDeoptStubPointer())) {
            DeoptimizedFrame result = KnownIntrinsics.convertUnknownValue(sourceSp.readObject(0), DeoptimizedFrame.class);
            assert (result != null);
            return result;
        }
        return null;
    }

    private static void installDeoptimizedFrame(Pointer sourceSp, DeoptimizedFrame deoptimizedFrame) {
        FrameAccess.singleton().writeReturnAddress(sourceSp, (CodePointer)DeoptimizationSupport.getDeoptStubPointer());
        sourceSp.writeWord(0, (WordBase)deoptimizedFrame.getPin().addressOfObject());
    }

    @NeverInline(value="deoptimize must have a separate stack frame")
    public static void deoptimizeAll() {
        JavaVMOperation.enqueueBlockingSafepoint("Deoptimizer.deoptimizeInRange", () -> Deoptimizer.deoptimizeInRange((CodePointer)WordFactory.zero(), (CodePointer)WordFactory.zero(), true));
    }

    @NeverInline(value="deoptimize must have a separate stack frame")
    public static void deoptimizeInRange(CodePointer fromIp, CodePointer toIp, boolean deoptAll) {
        VMOperation.guaranteeInProgressAtSafepoint("Deoptimization requires a safepoint.");
        Deoptimizer.deoptimizeInRangeOperation(fromIp, toIp, deoptAll);
    }

    @NeverInline(value="Starting a stack walk in the caller frame. Note that we could start the stack frame also further down the stack, because VM operation frames never need deoptimization. But we don't store stack frame information for the first frame we would need to process.")
    private static void deoptimizeInRangeOperation(CodePointer fromIp, CodePointer toIp, boolean deoptAll) {
        VMOperation.guaranteeInProgress("Deoptimizer.deoptimizeInRangeOperation, but not in VMOperation.");
        Pointer sp = KnownIntrinsics.readCallerStackPointer();
        StackFrameVisitor currentThreadDeoptVisitor = Deoptimizer.getStackFrameVisitor((Pointer)fromIp, (Pointer)toIp, deoptAll);
        JavaStackWalker.walkCurrentThread(sp, currentThreadDeoptVisitor);
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (vmThread != CurrentIsolate.getCurrentThread()) {
                    StackFrameVisitor deoptVisitor = Deoptimizer.getStackFrameVisitor((Pointer)fromIp, (Pointer)toIp, deoptAll);
                    JavaStackWalker.walkThread(vmThread, deoptVisitor);
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
        }
        if (testGCinDeoptimizer) {
            Heap.getHeap().getGC().collect(GCCause.TestGCInDeoptimizer);
        }
    }

    private static StackFrameVisitor getStackFrameVisitor(final Pointer fromIp, final Pointer toIp, final boolean deoptAll) {
        return new StackFrameVisitor(){

            @Override
            public boolean visitFrame(Pointer frameSp, CodePointer frameIp, CodeInfo codeInfo, DeoptimizedFrame deoptFrame) {
                Pointer ip = (Pointer)frameIp;
                if (deoptFrame == null && (ip.aboveOrEqual((UnsignedWord)fromIp) && ip.belowThan((UnsignedWord)toIp) || deoptAll)) {
                    CodeInfoQueryResult queryResult = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, frameIp);
                    Deoptimizer deoptimizer = new Deoptimizer(frameSp, queryResult);
                    deoptimizer.deoptSourceFrame(frameIp, deoptAll);
                }
                return true;
            }
        };
    }

    @NeverInline(value="Inlining of this method would require that we have deopt targets for callees of this method (SVM internals).")
    public static void deoptimizeFrame(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation) {
        DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sourceSp);
        if (deoptFrame != null) {
            Deoptimizer.registerSpeculationFailure(deoptFrame.getSourceInstalledCode(), speculation);
            return;
        }
        JavaVMOperation.enqueueBlockingSafepoint("DeoptimizeFrame", () -> Deoptimizer.deoptimizeFrameOperation(sourceSp, ignoreNonDeoptimizable, speculation));
    }

    private static void deoptimizeFrameOperation(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation) {
        VMOperation.guaranteeInProgress("doDeoptimizeFrame");
        CodePointer returnAddress = FrameAccess.singleton().readReturnAddress(sourceSp);
        Deoptimizer.deoptimizeFrame(sourceSp, ignoreNonDeoptimizable, speculation, returnAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo object.")
    private static void deoptimizeFrame(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, CodePointer returnAddress) {
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(returnAddress);
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
            Deoptimizer.deoptimize(sourceSp, ignoreNonDeoptimizable, speculation, returnAddress, info);
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    @Uninterruptible(reason="Pass the now protected CodeInfo object to interruptible code.", calleeMustBe=false)
    private static void deoptimize(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, CodePointer returnAddress, CodeInfo info) {
        Deoptimizer.deoptimize0(sourceSp, ignoreNonDeoptimizable, speculation, returnAddress, info);
    }

    private static void deoptimize0(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, CodePointer returnAddress, CodeInfo info) {
        CodeInfoQueryResult queryResult = CodeInfoTable.lookupCodeInfoQueryResult(info, returnAddress);
        Deoptimizer deoptimizer = new Deoptimizer(sourceSp, queryResult);
        DeoptimizedFrame sourceFrame = deoptimizer.deoptSourceFrame(returnAddress, ignoreNonDeoptimizable);
        if (sourceFrame != null) {
            Deoptimizer.registerSpeculationFailure(sourceFrame.getSourceInstalledCode(), speculation);
        }
    }

    public static void invalidateMethodOfFrame(Pointer sourceSp, SpeculationLog.SpeculationReason speculation) {
        CodePointer returnAddress = FrameAccess.singleton().readReturnAddress(sourceSp);
        SubstrateInstalledCode installedCode = CodeInfoTable.lookupInstalledCode(returnAddress);
        DeoptimizedFrame deoptimizedFrame = Deoptimizer.checkDeoptimized(sourceSp);
        if (deoptimizedFrame != null) {
            installedCode = deoptimizedFrame.getSourceInstalledCode();
            if (installedCode == null) {
                return;
            }
        } else if (installedCode == null) {
            CodeInfoTable.getRuntimeCodeCache().logTable();
            throw VMError.shouldNotReachHere("Only runtime compiled methods can be invalidated. sp = " + Long.toHexString(sourceSp.rawValue()) + ", returnAddress = " + Long.toHexString(returnAddress.rawValue()));
        }
        Deoptimizer.registerSpeculationFailure(installedCode, speculation);
        VMOperation.guaranteeNotInProgress("invalidateMethodOfFrame: running user code that can block");
        installedCode.invalidate();
    }

    private static void registerSpeculationFailure(SubstrateInstalledCode installedCode, SpeculationLog.SpeculationReason speculation) {
        SubstrateSpeculationLog speculationLog;
        if (installedCode != null && speculation != null && (speculationLog = installedCode.getSpeculationLog()) != null) {
            speculationLog.addFailedSpeculation(speculation);
        }
    }

    public Deoptimizer(Pointer sourceSp, CodeInfoQueryResult sourceChunk) {
        VMError.guarantee(sourceChunk != null, "Must not be null.");
        this.sourceSp = sourceSp;
        this.sourceChunk = sourceChunk;
        if (deoptStubFrameSize == 0L) {
            CodeInfo info = CodeInfoTable.getImageCodeInfo();
            deoptStubFrameSize = CodeInfoAccess.lookupTotalFrameSize(info, CodeInfoAccess.relativeIP(info, (CodePointer)DeoptimizationSupport.getDeoptStubPointer()));
        }
    }

    @DeoptStub(stubType=StubType.EntryStub)
    @Uninterruptible(reason="Frame holds Objects in unmanaged storage.")
    public static void deoptStub(DeoptimizedFrame frame) {
        DeoptimizationCounters.counters().deoptCount.inc();
        if (DeoptimizationCounters.Options.ProfileDeoptimization.getValue().booleanValue()) {
            DeoptimizationCounters.startTime.set(System.nanoTime());
        }
        Pointer newSp = KnownIntrinsics.readStackPointer().add(WordFactory.unsigned((long)deoptStubFrameSize)).subtract(FrameAccess.singleton().stackPointerAdjustmentOnCall()).add(WordFactory.unsigned((long)frame.getSourceTotalFrameSize())).subtract(frame.getTargetContent().getSize());
        frame.buildContent(newSp);
        frame.getPin().close();
        recentDeoptimizationEvents.append(frame.getCompletedMessage());
        Deoptimizer.rewriteStackStub(newSp, frame);
    }

    @DeoptStub(stubType=StubType.ExitStub)
    @NeverInline(value="Custom prologue modifies stack pointer register")
    @Uninterruptible(reason="Frame holds Objects in unmanaged storage.")
    private static DeoptimizedFrame rewriteStackStub(Pointer newSp, DeoptimizedFrame frame) {
        Pointer bottomSp = newSp.subtract(FrameAccess.returnAddressSize() + FrameAccess.singleton().savedBasePointerSize());
        frame.getTargetContent().copyToPointer(bottomSp);
        if (DeoptimizationCounters.Options.ProfileDeoptimization.getValue().booleanValue()) {
            DeoptimizationCounters.counters().timeSpentInDeopt.add(System.nanoTime() - DeoptimizationCounters.startTime.get());
        }
        return frame;
    }

    public JavaConstant readLocalVariable(int idx, FrameInfoQueryResult sourceFrame) {
        assert (idx >= 0 && idx < sourceFrame.getNumLocals());
        if (idx < sourceFrame.getValueInfos().length) {
            return this.readValue(sourceFrame.getValueInfos()[idx], sourceFrame);
        }
        return JavaConstant.forIllegal();
    }

    public DeoptimizedFrame deoptSourceFrame(CodePointer pc, boolean ignoreNonDeoptimizable) {
        DeoptSourceFrameOperation operation = new DeoptSourceFrameOperation(this, pc, ignoreNonDeoptimizable);
        operation.enqueue();
        return operation.getResult();
    }

    private DeoptimizedFrame deoptSourceFrameOperation(CodePointer pc, boolean ignoreNonDeoptimizable) {
        VMOperation.guaranteeInProgress("deoptSourceFrame");
        assert (DeoptimizationSupport.getDeoptStubPointer().rawValue() != 0L);
        DeoptimizedFrame existing = Deoptimizer.checkDeoptimized(this.sourceSp);
        if (existing != null) {
            return existing;
        }
        FrameInfoQueryResult frameInfo = this.sourceChunk.getFrameInfo();
        if (frameInfo == null) {
            if (ignoreNonDeoptimizable) {
                return null;
            }
            throw VMError.shouldNotReachHere("Deoptimization: cannot deoptimize a method that was not marked as deoptimizable from address " + Long.toHexString(pc.rawValue()));
        }
        assert (this.endOfParams == 0);
        DeoptimizedFrame.VirtualFrame previousVirtualFrame = null;
        DeoptimizedFrame.VirtualFrame topFrame = null;
        for (FrameInfoQueryResult deoptInfo = frameInfo; deoptInfo != null; deoptInfo = deoptInfo.getCaller()) {
            DeoptimizationCounters.counters().virtualFrameCount.inc();
            if (deoptInfo.getDeoptMethodOffset() == 0) {
                if (ignoreNonDeoptimizable) {
                    return null;
                }
                throw VMError.shouldNotReachHere("Deoptimization: cannot deoptimize a method that has no deoptimization entry point: " + deoptInfo.getSourceReference());
            }
            CodeInfoQueryResult targetInfo = CodeInfoTable.lookupDeoptimizationEntrypoint(deoptInfo.getDeoptMethodOffset(), deoptInfo.getEncodedBci());
            if (targetInfo == null || targetInfo.getFrameInfo() == null) {
                throw VMError.shouldNotReachHere("Deoptimization: no matching target bytecode frame found for bci " + FrameInfoDecoder.readableBci(deoptInfo.getEncodedBci()) + " in method at address " + Long.toHexString(deoptInfo.getDeoptMethodAddress().rawValue()));
            }
            if (!targetInfo.getFrameInfo().isDeoptEntry()) {
                throw VMError.shouldNotReachHere("Deoptimization: target frame information not marked as deoptimization entry point for bci " + FrameInfoDecoder.readableBci(deoptInfo.getEncodedBci()) + " in method at address" + Long.toHexString(deoptInfo.getDeoptMethodAddress().rawValue()));
            }
            if (targetInfo.getFrameInfo().getDeoptMethod() != null && targetInfo.getFrameInfo().getDeoptMethod().hasCalleeSavedRegisters()) {
                throw VMError.shouldNotReachHere("Deoptimization: target method has callee saved registers, which are not properly restored by the deoptimization runtime: " + targetInfo.getFrameInfo().getDeoptMethod().format("%H.%n(%r)"));
            }
            DeoptimizedFrame.VirtualFrame virtualFrame = this.constructTargetFrame(targetInfo, deoptInfo);
            if (previousVirtualFrame != null) {
                previousVirtualFrame.caller = virtualFrame;
            } else {
                topFrame = virtualFrame;
            }
            previousVirtualFrame = virtualFrame;
        }
        VMError.guarantee(this.sourceChunk.getTotalFrameSize() >= (long)FrameAccess.wordSize(), "Insufficient space in frame for pointer to DeoptimizedFrame");
        DeoptimizedFrame.RelockObjectData[] relockObjectData = this.relockedObjects == null ? null : this.relockedObjects.toArray(new DeoptimizedFrame.RelockObjectData[this.relockedObjects.size()]);
        DeoptimizedFrame deoptimizedFrame = DeoptimizedFrame.factory(this.targetContentSize, this.sourceChunk.getEncodedFrameSize(), CodeInfoTable.lookupInstalledCode(pc), topFrame, relockObjectData, pc);
        Deoptimizer.installDeoptimizedFrame(this.sourceSp, deoptimizedFrame);
        if (Options.TraceDeoptimization.getValue().booleanValue()) {
            Deoptimizer.printDeoptimizedFrame(Log.log(), this.sourceSp, deoptimizedFrame, frameInfo, false);
        }
        Deoptimizer.logDeoptSourceFrameOperation(this.sourceSp, deoptimizedFrame, frameInfo);
        return deoptimizedFrame;
    }

    private static void logDeoptSourceFrameOperation(Pointer sp, DeoptimizedFrame deoptimizedFrame, FrameInfoQueryResult frameInfo) {
        StringBuilderLog log = new StringBuilderLog();
        PointerBase deoptimizedFrameAddress = deoptimizedFrame.getPin().addressOfObject();
        log.string("deoptSourceFrameOperation: DeoptimizedFrame at ").hex((WordBase)deoptimizedFrameAddress).string(": ");
        Deoptimizer.printDeoptimizedFrame(log, sp, deoptimizedFrame, frameInfo, true);
        recentDeoptimizationEvents.append(log.getResult().toCharArray());
    }

    public static void logRecentDeoptimizationEvents(Log log) {
        log.string("== [Recent Deoptimizer Events: ").newline();
        recentDeoptimizationEvents.foreach(log, deoptEventsConsumer);
        log.string("]").newline();
    }

    private DeoptimizedFrame.VirtualFrame constructTargetFrame(CodeInfoQueryResult targetInfo, FrameInfoQueryResult sourceFrame) {
        FrameInfoQueryResult targetFrame = targetInfo.getFrameInfo();
        int savedBasePointerSize = FrameAccess.singleton().savedBasePointerSize();
        long targetFrameSize = targetInfo.getTotalFrameSize() - (long)FrameAccess.returnAddressSize() - (long)savedBasePointerSize;
        DeoptimizedFrame.VirtualFrame result = new DeoptimizedFrame.VirtualFrame(targetFrame);
        if (savedBasePointerSize != 0) {
            result.savedBasePointer = new DeoptimizedFrame.SavedBasePointer(this.targetContentSize, (long)this.targetContentSize + targetFrameSize);
            this.targetContentSize += savedBasePointerSize;
        }
        result.returnAddress = new DeoptimizedFrame.ReturnAddress(this.targetContentSize, targetInfo.getIP().rawValue());
        this.targetContentSize += FrameAccess.returnAddressSize();
        assert (sourceFrame.getNumLocals() == targetFrame.getNumLocals());
        assert (sourceFrame.getNumStack() == targetFrame.getNumStack());
        assert (sourceFrame.getNumLocks() == targetFrame.getNumLocks());
        assert (targetFrame.getVirtualObjects().length == 0);
        assert (sourceFrame.getValueInfos().length >= targetFrame.getValueInfos().length);
        int numValues = targetFrame.getValueInfos().length;
        int newEndOfParams = this.endOfParams;
        block4: for (int idx = 0; idx < numValues; ++idx) {
            FrameInfoQueryResult.ValueInfo targetValue = targetFrame.getValueInfos()[idx];
            if (targetValue.getKind() == JavaKind.Illegal) continue;
            FrameInfoQueryResult.ValueInfo sourceValue = sourceFrame.getValueInfos()[idx];
            JavaConstant con = this.readValue(sourceValue, sourceFrame);
            assert (con.getJavaKind() != JavaKind.Illegal);
            if (con.getJavaKind().isObject() && SubstrateObjectConstant.isCompressed(con) != targetValue.isCompressedReference()) {
                Object obj = SubstrateObjectConstant.asObject((Constant)con);
                con = SubstrateObjectConstant.forObject(obj, targetValue.isCompressedReference());
            }
            if (sourceValue.isEliminatedMonitor()) {
                this.relockObject(con);
            }
            switch (targetValue.getType()) {
                case StackSlot: {
                    DeoptimizationCounters.counters().stackValueCount.inc();
                    int targetOffset = TypeConversion.asS4((long)targetValue.getData());
                    assert ((long)targetOffset != targetFrameSize) : "stack slot would overwrite return address";
                    int totalOffset = this.targetContentSize + targetOffset;
                    assert (totalOffset >= this.endOfParams) : "stack location overwrites param area";
                    if ((long)targetOffset < targetFrameSize) {
                        assert (totalOffset >= this.targetContentSize);
                        result.values[idx] = DeoptimizedFrame.ConstantEntry.factory(totalOffset, con);
                        continue block4;
                    }
                    if (sourceFrame.getCaller() == null) continue block4;
                    assert (totalOffset >= this.targetContentSize);
                    result.values[idx] = DeoptimizedFrame.ConstantEntry.factory(totalOffset, con);
                    int size = targetValue.getKind().isObject() && !targetValue.isCompressedReference() ? FrameAccess.uncompressedReferenceSize() : ConfigurationValues.getObjectLayout().sizeInBytes(con.getJavaKind());
                    int endOffset = totalOffset + size;
                    if (endOffset <= newEndOfParams) continue block4;
                    newEndOfParams = endOffset;
                    continue block4;
                }
                case DefaultConstant: 
                case Constant: {
                    assert (this.verifyConstant(targetFrame, targetValue, con));
                    DeoptimizationCounters.counters().constantValueCount.inc();
                    continue block4;
                }
                default: {
                    throw VMError.shouldNotReachHere("unknown deopt target value " + targetValue);
                }
            }
        }
        this.targetContentSize = (int)((long)this.targetContentSize + targetFrameSize);
        this.endOfParams = newEndOfParams;
        return result;
    }

    private void relockObject(JavaConstant valueConstant) {
        Object lockedObject = KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject((Constant)valueConstant), Object.class);
        Object lockData = MonitorSupport.singleton().prepareRelockObject(lockedObject);
        if (this.relockedObjects == null) {
            this.relockedObjects = new ArrayList();
        }
        this.relockedObjects.add(new DeoptimizedFrame.RelockObjectData(lockedObject, lockData));
    }

    private boolean verifyConstant(FrameInfoQueryResult targetFrame, FrameInfoQueryResult.ValueInfo targetValue, JavaConstant source) {
        JavaConstant target = this.readValue(targetValue, targetFrame);
        boolean equal = source.getJavaKind() == JavaKind.Object && target.getJavaKind() == JavaKind.Object ? SubstrateObjectConstant.asObject((Constant)target) == SubstrateObjectConstant.asObject((Constant)source) : source.equals(target);
        if (!equal) {
            Log.log().string("source: ").string(source.toString()).string("  target: ").string(target.toString()).newline();
        }
        return equal;
    }

    private JavaConstant readValue(FrameInfoQueryResult.ValueInfo valueInfo, FrameInfoQueryResult sourceFrame) {
        switch (valueInfo.getType()) {
            case DefaultConstant: 
            case Constant: {
                return valueInfo.getValue();
            }
            case StackSlot: 
            case Register: {
                return Deoptimizer.readConstant(this.sourceSp, WordFactory.signed((long)valueInfo.getData()), valueInfo.getKind(), valueInfo.isCompressedReference());
            }
            case VirtualObject: {
                Object obj = this.materializeObject(TypeConversion.asS4((long)valueInfo.getData()), sourceFrame);
                return SubstrateObjectConstant.forObject(obj, valueInfo.isCompressedReference());
            }
            case Illegal: {
                return JavaConstant.forIllegal();
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private Object materializeObject(int virtualObjectId, FrameInfoQueryResult sourceFrame) {
        int curIdx;
        UnsignedWord curOffset;
        if (this.materializedObjects == null) {
            this.materializedObjects = new Object[sourceFrame.getVirtualObjects().length];
        }
        assert (this.materializedObjects.length == sourceFrame.getVirtualObjects().length);
        Object obj = this.materializedObjects[virtualObjectId];
        if (obj != null) {
            return obj;
        }
        DeoptimizationCounters.counters().virtualObjectsCount.inc();
        FrameInfoQueryResult.ValueInfo[] encodings = sourceFrame.getVirtualObjects()[virtualObjectId];
        DynamicHub hub = KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject((Constant)this.readValue(encodings[0], sourceFrame)), DynamicHub.class);
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        boolean materializingByteArray = false;
        if (LayoutEncoding.isArray(hub.getLayoutEncoding())) {
            int length = this.readValue(encodings[1], sourceFrame).asInt();
            obj = Array.newInstance(DynamicHub.toClass(hub.getComponentHub()), length);
            materializingByteArray = obj.getClass() == byte[].class;
            curOffset = LayoutEncoding.getArrayBaseOffset(hub.getLayoutEncoding());
            curIdx = 2;
        } else {
            try {
                obj = UNSAFE.allocateInstance(DynamicHub.toClass(hub));
            }
            catch (InstantiationException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            curOffset = WordFactory.unsigned((int)objectLayout.getFirstFieldOffset());
            curIdx = 1;
        }
        this.materializedObjects[virtualObjectId] = obj;
        if (testGCinDeoptimizer) {
            Heap.getHeap().getGC().collect(GCCause.TestGCInDeoptimizer);
        }
        while (curIdx < encodings.length) {
            FrameInfoQueryResult.ValueInfo value = encodings[curIdx];
            JavaKind kind = value.getKind();
            JavaConstant con = this.readValue(value, sourceFrame);
            if (materializingByteArray && kind.isPrimitive()) {
                int byteCount = Deoptimizer.restoreEscapedByteArrayWriteByteCount(encodings, curIdx);
                con = Deoptimizer.restoreByteArrayWriteValue(con, byteCount);
                curIdx = curIdx + byteCount - 1;
            }
            Deoptimizer.writeValueInMaterializedObj(obj, curOffset, con);
            curOffset = curOffset.add(objectLayout.sizeInBytes(kind));
            ++curIdx;
        }
        return obj;
    }

    private static int restoreEscapedByteArrayWriteByteCount(FrameInfoQueryResult.ValueInfo[] encodings, int curIdx) {
        int index;
        for (index = curIdx + 1; index < encodings.length && encodings[index].getKind() == JavaKind.Illegal; ++index) {
        }
        return index - curIdx;
    }

    private static JavaConstant restoreByteArrayWriteValue(JavaConstant con, int byteCount) {
        switch (byteCount) {
            case 1: {
                return JavaConstant.forByte((byte)((byte)con.asInt()));
            }
            case 2: {
                return JavaConstant.forChar((char)((char)con.asInt()));
            }
            case 4: {
                if (con.getJavaKind().isNumericFloat()) {
                    return JavaConstant.forFloat((float)con.asFloat());
                }
                return JavaConstant.forInt((int)con.asInt());
            }
            case 8: {
                if (con.getJavaKind().isNumericFloat()) {
                    return JavaConstant.forDouble((double)con.asDouble());
                }
                return JavaConstant.forLong((long)con.asLong());
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private static void writeValueInMaterializedObj(Object materializedObj, UnsignedWord offsetInObj, JavaConstant constant) {
        assert (offsetInObj.notEqual(0)) : "materialized value would overwrite hub";
        switch (constant.getJavaKind()) {
            case Boolean: {
                BarrieredAccess.writeByte((Object)materializedObj, (WordBase)offsetInObj, (byte)(constant.asBoolean() ? (byte)1 : 0));
                break;
            }
            case Byte: {
                BarrieredAccess.writeByte((Object)materializedObj, (WordBase)offsetInObj, (byte)((byte)constant.asInt()));
                break;
            }
            case Char: {
                BarrieredAccess.writeChar((Object)materializedObj, (WordBase)offsetInObj, (char)((char)constant.asInt()));
                break;
            }
            case Short: {
                BarrieredAccess.writeShort((Object)materializedObj, (WordBase)offsetInObj, (short)((short)constant.asInt()));
                break;
            }
            case Int: {
                BarrieredAccess.writeInt((Object)materializedObj, (WordBase)offsetInObj, (int)constant.asInt());
                break;
            }
            case Long: {
                BarrieredAccess.writeLong((Object)materializedObj, (WordBase)offsetInObj, (long)constant.asLong());
                break;
            }
            case Float: {
                BarrieredAccess.writeFloat((Object)materializedObj, (WordBase)offsetInObj, (float)constant.asFloat());
                break;
            }
            case Double: {
                BarrieredAccess.writeDouble((Object)materializedObj, (WordBase)offsetInObj, (double)constant.asDouble());
                break;
            }
            case Object: {
                BarrieredAccess.writeObject((Object)materializedObj, (WordBase)offsetInObj, (Object)SubstrateObjectConstant.asObject((Constant)constant));
                break;
            }
            default: {
                throw VMError.shouldNotReachHere();
            }
        }
    }

    private static JavaConstant readConstant(Pointer addr, SignedWord offset, JavaKind kind, boolean compressed) {
        switch (kind) {
            case Boolean: {
                return JavaConstant.forBoolean((addr.readByte((WordBase)offset) != 0 ? 1 : 0) != 0);
            }
            case Byte: {
                return JavaConstant.forByte((byte)addr.readByte((WordBase)offset));
            }
            case Char: {
                return JavaConstant.forChar((char)addr.readChar((WordBase)offset));
            }
            case Short: {
                return JavaConstant.forShort((short)addr.readShort((WordBase)offset));
            }
            case Int: {
                return JavaConstant.forInt((int)addr.readInt((WordBase)offset));
            }
            case Long: {
                return JavaConstant.forLong((long)addr.readLong((WordBase)offset));
            }
            case Float: {
                return JavaConstant.forFloat((float)addr.readFloat((WordBase)offset));
            }
            case Double: {
                return JavaConstant.forDouble((double)addr.readDouble((WordBase)offset));
            }
            case Object: {
                Word p = ((Word)addr).add(offset);
                Object obj = ReferenceAccess.singleton().readObjectAt((Pointer)p, compressed);
                return SubstrateObjectConstant.forObject(obj, compressed);
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private static void printDeoptimizedFrame(Log log, Pointer sp, DeoptimizedFrame deoptimizedFrame, FrameInfoQueryResult sourceFrameInfo, boolean printOnlyTopFrames) {
        log.string("[Deoptimization of frame").newline();
        SubstrateInstalledCode installedCode = deoptimizedFrame.getSourceInstalledCode();
        if (installedCode != null) {
            log.string("    name: ").string(installedCode.getName()).newline();
        }
        log.string("    sp: ").hex((WordBase)sp).string("  ip: ").hex((WordBase)deoptimizedFrame.getSourcePC()).newline();
        if (sourceFrameInfo != null) {
            log.string("    stack trace where execution continues:").newline();
            FrameInfoQueryResult sourceFrame = sourceFrameInfo;
            DeoptimizedFrame.VirtualFrame targetFrame = deoptimizedFrame.getTopFrame();
            int count = 0;
            while (sourceFrame != null) {
                SharedMethod deoptMethod = sourceFrame.getDeoptMethod();
                log.string("        at ");
                if (deoptMethod != null) {
                    StackTraceElement element = deoptMethod.asStackTraceElement(sourceFrame.getBci());
                    if (element.getFileName() != null && element.getLineNumber() >= 0) {
                        log.string(element.toString());
                    } else {
                        log.string(deoptMethod.format("%H.%n(%p)"));
                    }
                } else {
                    log.string("method at ").hex((WordBase)sourceFrame.getDeoptMethodAddress());
                }
                log.string(" bci ");
                FrameInfoDecoder.logReadableBci(log, sourceFrame.getEncodedBci());
                log.string("  return address ").hex(targetFrame.returnAddress.returnAddress).newline();
                if (printOnlyTopFrames || Options.TraceDeoptimizationDetails.getValue().booleanValue()) {
                    Deoptimizer.printVirtualFrame(log, targetFrame);
                }
                if (printOnlyTopFrames && ++count >= 4) break;
                sourceFrame = sourceFrame.getCaller();
                targetFrame = targetFrame.getCaller();
            }
        }
        log.string("]").newline();
    }

    private static void printVirtualFrame(Log log, DeoptimizedFrame.VirtualFrame virtualFrame) {
        FrameInfoQueryResult frameInfo = virtualFrame.getFrameInfo();
        String sourceReference = frameInfo.getSourceReference().toString();
        if (sourceReference != null) {
            log.string("            ").string(sourceReference).newline();
        }
        log.string("            bci: ");
        FrameInfoDecoder.logReadableBci(log, frameInfo.getEncodedBci());
        log.string("  deoptMethodOffset: ").signed(frameInfo.getDeoptMethodOffset());
        log.string("  deoptMethod: ").hex((WordBase)frameInfo.getDeoptMethodAddress());
        log.string("  return address: ").hex(virtualFrame.returnAddress.returnAddress).string("  offset: ").signed(virtualFrame.returnAddress.offset);
        for (int i = 0; i < frameInfo.getValueInfos().length; ++i) {
            JavaConstant con = virtualFrame.getConstant(i);
            if (con.getJavaKind() == JavaKind.Illegal) continue;
            log.newline().string("            slot ").signed(i);
            String name = frameInfo.getLocalVariableName(i);
            if (name != null) {
                log.string(" ").string(name);
            }
            log.string("  kind: ").string(con.getJavaKind().toString());
            if (con.getJavaKind() == JavaKind.Object) {
                Object val = SubstrateObjectConstant.asObject((Constant)con);
                if (val == null) {
                    log.string("  null");
                } else {
                    log.string("  value: ").object(val);
                }
            } else {
                log.string("  value: ").string(con.toValueString());
            }
            log.string("  offset: ").signed(virtualFrame.values[i].offset);
        }
        log.newline();
    }

    static {
        assert (Deoptimizer.checkEncoding());
        testGCinDeoptimizer = false;
        deoptStubFrameSize = 0L;
        deoptEventsConsumer = (context, entry) -> {
            Log l = (Log)context;
            for (char c : entry) {
                if (c == '\n') {
                    l.newline();
                    continue;
                }
                l.character(c);
            }
        };
    }

    static class TargetContent {
        private final byte[] frameBuffer;
        private static final int sizeofInt = JavaKind.Int.getByteCount();
        private static final int sizeofLong = JavaKind.Long.getByteCount();
        private final int sizeofCompressedReference = ConfigurationValues.getObjectLayout().getReferenceSize();
        private final int sizeofUncompressedReference = FrameAccess.uncompressedReferenceSize();
        private static final int arrayBaseOffset = ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte);
        private static final ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException("TargetContent.offsetCheck");

        @Uninterruptible(reason="Called from uninterruptible code.")
        private void offsetCheck(int offset, int size) {
            if (0 > offset || offset > this.frameBuffer.length - size) {
                throw arrayIndexOutOfBoundsException;
            }
        }

        protected TargetContent(int targetContentSize, ByteOrder byteOrder) {
            if (byteOrder != ByteOrder.nativeOrder()) {
                VMError.unsupportedFeature("TargetContent with non-native byte order.");
            }
            if (FrameAccess.returnAddressSize() != sizeofLong) {
                VMError.unsupportedFeature("TargetContent with returnAddressSize() != sizeof(long).");
            }
            this.frameBuffer = new byte[targetContentSize];
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        protected int getSize() {
            return this.frameBuffer.length;
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        protected void copyToPointer(Pointer p) {
            for (int idx = 0; idx < this.frameBuffer.length; ++idx) {
                p.writeByte(idx, this.frameBuffer[idx]);
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        protected void writeInt(int offset, int value) {
            this.offsetCheck(offset, sizeofInt);
            this.addressOfFrameArray0().writeInt(offset, value);
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        protected void writeLong(int offset, long value) {
            this.offsetCheck(offset, sizeofLong);
            this.addressOfFrameArray0().writeLong(offset, value);
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        protected void writeWord(int offset, WordBase value) {
            if (FrameAccess.wordSize() == 8) {
                this.writeLong(offset, value.rawValue());
            } else if (FrameAccess.wordSize() == 4) {
                this.writeInt(offset, (int)value.rawValue());
            } else {
                throw VMError.shouldNotReachHere("Unexpected word size: " + FrameAccess.wordSize());
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        protected void writeObject(int offset, Object value, boolean compressed) {
            this.offsetCheck(offset, compressed ? this.sizeofCompressedReference : this.sizeofUncompressedReference);
            Word address = (Word)this.addressOfFrameArray0();
            address = address.add(offset);
            ReferenceAccess.singleton().writeObjectAt((Pointer)address, value, compressed);
        }

        @Uninterruptible(reason="Called from uninterruptible code.")
        private Pointer addressOfFrameArray0() {
            return Word.objectToUntrackedPointer((Object)this.frameBuffer).add(arrayBaseOffset);
        }
    }

    private static final class DeoptSourceFrameOperation
    extends JavaVMOperation {
        private final Deoptimizer receiver;
        private final CodePointer pc;
        private final boolean ignoreNonDeoptimizable;
        private DeoptimizedFrame result;

        DeoptSourceFrameOperation(Deoptimizer receiver, CodePointer pc, boolean ignoreNonDeoptimizable) {
            super("DeoptSourceFrameOperation", VMOperation.SystemEffect.SAFEPOINT);
            this.receiver = receiver;
            this.pc = pc;
            this.ignoreNonDeoptimizable = ignoreNonDeoptimizable;
            this.result = null;
        }

        @Override
        public void operate() {
            this.result = this.receiver.deoptSourceFrameOperation(this.pc, this.ignoreNonDeoptimizable);
        }

        public DeoptimizedFrame getResult() {
            return this.result;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface DeoptStub {
        public StubType stubType();
    }

    public static enum StubType {
        NoDeoptStub,
        EntryStub,
        ExitStub;

    }

    public static class Options {
        @Option(help={"Print logging information for every deoptimization"})
        public static final RuntimeOptionKey<Boolean> TraceDeoptimization = new RuntimeOptionKey<Boolean>(false);
        @Option(help={"Print verbose logging information for every deoptimization"})
        public static final RuntimeOptionKey<Boolean> TraceDeoptimizationDetails = new RuntimeOptionKey<Boolean>(false);
    }
}

