/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.FillerObjectDummyPartition;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ChunkedImageHeapAllocator {
    private static final ImageHeapPartition FILLERS_DUMMY_PARTITION = new FillerObjectDummyPartition();
    private final ImageHeap imageHeap;
    private final int alignedChunkSize;
    private final int alignedChunkAlignment;
    private final int alignedChunkObjectsOffset;
    private final int unalignedChunkObjectsOffset;
    private long position;
    private final ArrayList<UnalignedChunk> unalignedChunks = new ArrayList();
    private final ArrayList<AlignedChunk> alignedChunks = new ArrayList();
    private AlignedChunk currentAlignedChunk;

    ChunkedImageHeapAllocator(ImageHeap imageHeap, long position) {
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        assert (layout.getMinimumObjectSize() == layout.getAlignment()) : "Must be able to fill any gap";
        this.imageHeap = imageHeap;
        this.alignedChunkSize = UnsignedUtils.safeToInt(HeapPolicy.getAlignedHeapChunkSize());
        this.alignedChunkAlignment = UnsignedUtils.safeToInt(HeapPolicy.getAlignedHeapChunkAlignment());
        this.alignedChunkObjectsOffset = UnsignedUtils.safeToInt(AlignedHeapChunk.getObjectsStartOffset());
        this.unalignedChunkObjectsOffset = UnsignedUtils.safeToInt(UnalignedHeapChunk.getObjectStartOffset());
        this.position = position;
    }

    public long getPosition() {
        return this.currentAlignedChunk != null ? this.currentAlignedChunk.getTop() : this.position;
    }

    public void alignBetweenChunks(int multiple) {
        assert (this.currentAlignedChunk == null);
        this.allocateRaw(ChunkedImageHeapAllocator.computePadding(this.position, multiple));
    }

    public long allocateUnalignedChunkForObject(ImageHeapObject obj, boolean writable) {
        assert (this.currentAlignedChunk == null);
        UnsignedWord objSize = WordFactory.unsigned((long)obj.getSize());
        long chunkSize = UnalignedHeapChunk.getChunkSizeForObject(objSize).rawValue();
        long chunkBegin = this.allocateRaw(chunkSize);
        this.unalignedChunks.add(new UnalignedChunk(chunkBegin, chunkSize, writable));
        return chunkBegin + (long)this.unalignedChunkObjectsOffset;
    }

    public void maybeStartAlignedChunk() {
        if (this.currentAlignedChunk == null) {
            this.startNewAlignedChunk();
        }
    }

    public void startNewAlignedChunk() {
        this.maybeFinishAlignedChunk();
        this.alignBetweenChunks(this.alignedChunkAlignment);
        long chunkBegin = this.allocateRaw(this.alignedChunkSize);
        this.currentAlignedChunk = new AlignedChunk(chunkBegin);
        this.alignedChunks.add(this.currentAlignedChunk);
    }

    public long getRemainingBytesInAlignedChunk() {
        return this.currentAlignedChunk.getUnallocatedBytes();
    }

    public long allocateObjectInAlignedChunk(ImageHeapObject obj, boolean writable) {
        return this.currentAlignedChunk.allocate(obj, writable);
    }

    public void alignInAlignedChunk(int multiple) {
        if (!this.currentAlignedChunk.tryAlignTop(multiple)) {
            this.startNewAlignedChunk();
            boolean aligned = this.currentAlignedChunk.tryAlignTop(multiple);
            VMError.guarantee(aligned, "Cannot align to " + multiple + " bytes within an aligned chunk's object area");
        }
    }

    public void maybeFinishAlignedChunk() {
        if (this.currentAlignedChunk != null) {
            this.currentAlignedChunk.finish();
            this.currentAlignedChunk = null;
        }
    }

    public List<AlignedChunk> getAlignedChunks() {
        return this.alignedChunks;
    }

    public List<UnalignedChunk> getUnalignedChunks() {
        return this.unalignedChunks;
    }

    private long allocateRaw(long size) {
        assert (this.currentAlignedChunk == null);
        long begin = this.position;
        this.position += size;
        return begin;
    }

    private static long computePadding(long offset, int alignment) {
        long remainder = offset % (long)alignment;
        return remainder == 0L ? 0L : (long)alignment - remainder;
    }

    final class AlignedChunk
    extends Chunk {
        private final List<ImageHeapObject> objects;
        private long topOffset;

        AlignedChunk(long begin) {
            super(begin, ChunkedImageHeapAllocator.this.alignedChunkSize, false);
            this.objects = new ArrayList<ImageHeapObject>();
            this.topOffset = ChunkedImageHeapAllocator.this.alignedChunkObjectsOffset;
        }

        public long allocate(ImageHeapObject obj, boolean writable) {
            long size = obj.getSize();
            VMError.guarantee(size <= this.getUnallocatedBytes(), "Object of size " + size + " does not fit in the chunk's remaining bytes");
            long objStart = this.getTop();
            this.topOffset += size;
            this.objects.add(obj);
            if (writable) {
                this.setWritable();
            }
            return objStart;
        }

        public boolean tryAlignTop(int multiple) {
            long padding = ChunkedImageHeapAllocator.computePadding(this.getTop(), multiple);
            if (padding > this.getUnallocatedBytes()) {
                return false;
            }
            this.allocateFiller(padding);
            assert (this.getTop() % (long)multiple == 0L);
            return true;
        }

        public void finish() {
            this.allocateFiller(this.getUnallocatedBytes());
            assert (this.isFinished());
        }

        public boolean isFinished() {
            return this.topOffset == this.getEndOffset();
        }

        private void allocateFiller(long size) {
            if (size != 0L) {
                ImageHeapObject filler = ChunkedImageHeapAllocator.this.imageHeap.addFillerObject(NumUtil.safeToInt((long)size));
                filler.setHeapPartition(FILLERS_DUMMY_PARTITION);
                long location = this.allocate(filler, false);
                filler.setOffsetInPartition(location);
            }
        }

        public List<ImageHeapObject> getObjects() {
            return this.objects;
        }

        @Override
        public long getTopOffset() {
            return this.topOffset;
        }

        public long getTop() {
            return this.getBegin() + this.topOffset;
        }

        public long getUnallocatedBytes() {
            return this.getEndOffset() - this.topOffset;
        }
    }

    static final class UnalignedChunk
    extends Chunk {
        UnalignedChunk(long begin, long endOffset, boolean writable) {
            super(begin, endOffset, writable);
        }

        @Override
        public long getTopOffset() {
            return this.getEndOffset();
        }
    }

    static abstract class Chunk {
        private final long begin;
        private final long endOffset;
        private boolean writable;

        Chunk(long begin, long endOffset, boolean writable) {
            this.begin = begin;
            this.endOffset = endOffset;
            this.writable = writable;
        }

        public long getBegin() {
            return this.begin;
        }

        public long getEnd() {
            return this.begin + this.endOffset;
        }

        public long getEndOffset() {
            return this.endOffset;
        }

        public abstract long getTopOffset();

        public void setWritable() {
            this.writable = true;
        }

        public boolean isWritable() {
            return this.writable;
        }
    }
}

