/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.Package_jdk_internal_reflect;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;

@TargetClass(classNameProvider=Package_jdk_internal_reflect.class, className="Reflection")
public final class Target_jdk_internal_reflect_Reflection {
    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private static Class<?> getCallerClass() {
        return StackTraceUtils.getCallerClass(KnownIntrinsics.readCallerStackPointer());
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    @NeverInline(value="Starting a stack walk in the caller frame")
    private static Class<?> getCallerClass(int depth) {
        return StackTraceUtils.getCallerClass(KnownIntrinsics.readCallerStackPointer(), depth);
    }

    @Substitute
    private static int getClassAccessFlags(Class<?> cls) {
        return cls.getModifiers();
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static boolean areNestMates(Class<?> currentClass, Class<?> memberClass) {
        return DynamicHub.fromClass(currentClass).isNestmateOf(memberClass);
    }
}

