/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux.libc;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.posix.linux.libc.BionicLibC;
import com.oracle.svm.core.posix.linux.libc.GLibC;
import com.oracle.svm.core.posix.linux.libc.MuslLibC;
import com.oracle.svm.core.util.UserError;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class LibCFeature
implements Feature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Platform.includedIn(Platform.LINUX.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        LibCBase libc;
        String targetLibC;
        switch (targetLibC = LibCOptions.UseLibC.getValue()) {
            case "glibc": {
                libc = new GLibC();
                break;
            }
            case "musl": {
                libc = new MuslLibC();
                break;
            }
            case "bionic": {
                libc = new BionicLibC();
                break;
            }
            default: {
                throw UserError.abort("Unknown libc " + targetLibC + " selected. Please use one of the available libc implementations.", new Object[0]);
            }
        }
        ImageSingletons.add(LibCBase.class, (Object)libc);
    }

    public static class LibCOptions {
        @APIOption(name="libc")
        @Option(help={"Selects the libc implementation to use. Available implementations: glibc, musl"})
        public static final HostedOptionKey<String> UseLibC = new HostedOptionKey<String>("glibc");
    }
}

