/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.annotate.Uninterruptible;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class UnsignedUtils {
    public static final UnsignedWord MAX_VALUE = WordFactory.unsigned((long)-1L);

    private UnsignedUtils() {
    }

    @Uninterruptible(reason="Used in uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord roundDown(UnsignedWord that, UnsignedWord multiple) {
        return that.unsignedDivide(multiple).multiply(multiple);
    }

    @Uninterruptible(reason="Used in uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord roundUp(UnsignedWord that, UnsignedWord multiple) {
        return UnsignedUtils.roundDown(that.add(multiple.subtract(1)), multiple);
    }

    @Uninterruptible(reason="Used in uninterruptible code.", mayBeInlined=true)
    public static boolean isAMultiple(UnsignedWord that, UnsignedWord multiple) {
        return that.unsignedRemainder(multiple).equal(0);
    }

    @Uninterruptible(reason="Used in uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord min(UnsignedWord x, UnsignedWord y) {
        return x.belowOrEqual(y) ? x : y;
    }

    public static UnsignedWord max(UnsignedWord x, UnsignedWord y) {
        return x.aboveOrEqual(y) ? x : y;
    }

    public static int safeToInt(UnsignedWord w) {
        long l = w.rawValue();
        assert (l >= 0L && l == (long)((int)l));
        return (int)l;
    }
}

