/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class ClassLoaderFeature
implements Feature {
    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(object -> {
            if (object instanceof NativeImageClassLoader || object instanceof NativeImageSystemClassLoader) {
                ClassLoader parent = ((ClassLoader)object).getParent();
                VMError.guarantee(parent != null);
                return parent;
            }
            return object;
        });
    }
}

