/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.SecureClassLoader;

public final class NativeImageSystemClassLoader
extends SecureClassLoader {
    private NativeImageClassLoader delegate = null;
    private final ClassLoader defaultSystemClassLoader;
    private static final Method loadClass = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"loadClass", (Class[])new Class[]{String.class, Boolean.TYPE});
    private static final Method findResource = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"findResource", (Class[])new Class[]{String.class});
    private static final Method getClassLoadingLock = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"getClassLoadingLock", (Class[])new Class[]{String.class});

    public NativeImageSystemClassLoader(ClassLoader defaultSystemClassLoader) {
        super(defaultSystemClassLoader);
        this.defaultSystemClassLoader = defaultSystemClassLoader;
    }

    public void setDelegate(NativeImageClassLoader delegateClassLoader) {
        this.delegate = delegateClassLoader;
    }

    public ClassLoader getDefaultSystemClassLoader() {
        return this.defaultSystemClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader classLoader = null;
        Class loadedClass = null;
        try {
            Object lock;
            classLoader = this.getActiveClassLoader();
            Object object = lock = getClassLoadingLock.invoke((Object)classLoader, name);
            synchronized (object) {
                loadedClass = (Class)loadClass.invoke((Object)classLoader, name, resolve);
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getCause();
            }
            String message = String.format("Can not load class: %s, with class loader: %s", name, classLoader);
            VMError.shouldNotReachHere(message, e);
        }
        return loadedClass;
    }

    @Override
    protected URL findResource(String name) {
        ClassLoader classLoader = null;
        try {
            classLoader = this.getActiveClassLoader();
            return (URL)findResource.invoke((Object)classLoader, name);
        }
        catch (ReflectiveOperationException e) {
            String message = String.format("Can not find resource: %s using class loader: %s", name, classLoader);
            VMError.shouldNotReachHere(message, e);
            return null;
        }
    }

    public String toString() {
        String clString = super.toString();
        return clString + " {delegate=" + this.delegate + ", defaultSystemClassLoader=" + this.defaultSystemClassLoader + '}';
    }

    private ClassLoader getActiveClassLoader() {
        return this.delegate != null ? this.delegate : this.defaultSystemClassLoader;
    }

    private void appendToClassPathForInstrumentation(String classPathEntry) {
        try {
            Method method = ReflectionUtil.lookupMethod(this.getParent().getClass(), (String)"appendToClassPathForInstrumentation", (Class[])new Class[]{String.class});
            method.invoke((Object)this.getParent(), classPathEntry);
        }
        catch (ReflectiveOperationException e) {
            String message = String.format("Can not add jar: %s to class path. Due to %s", classPathEntry, e);
            VMError.shouldNotReachHere(message, e);
        }
    }
}

