/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.impl.SizeOfSupport;
import org.graalvm.word.PointerBase;

public final class SizeOfSupportImpl
implements SizeOfSupport {
    private final NativeLibraries nativeLibraries;
    private final MetaAccessProvider metaAccess;

    public SizeOfSupportImpl(NativeLibraries nativeLibraries, MetaAccessProvider metaAccess) {
        this.nativeLibraries = nativeLibraries;
        this.metaAccess = metaAccess;
    }

    public int sizeof(Class<? extends PointerBase> clazz) {
        ResolvedJavaType type = this.metaAccess.lookupJavaType(clazz);
        ElementInfo typeInfo = this.nativeLibraries.findElementInfo((AnnotatedElement)type);
        if (typeInfo instanceof StructInfo && ((StructInfo)typeInfo).isIncomplete()) {
            throw UserError.abort("Class parameter " + type.toJavaName(true) + " of call to " + SizeOf.class.getSimpleName() + " is an incomplete structure, so no size is available", new Object[0]);
        }
        if (typeInfo instanceof SizableInfo) {
            return ((SizableInfo)typeInfo).getSizeInfo().getProperty();
        }
        throw UserError.abort("Class parameter " + type.toJavaName(true) + " of call to " + SizeOf.class.getSimpleName() + " is not an annotated C interface type", new Object[0]);
    }
}

