/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.ResolvedJavaType;

public class TypeInitializerGraph {
    private final SVMHost hostVM;
    private ClassInitializationSupport classInitializationSupport;
    private final Map<AnalysisType, Safety> types = new HashMap<AnalysisType, Safety>();
    private final Map<AnalysisType, Set<AnalysisType>> dependencies = new HashMap<AnalysisType, Set<AnalysisType>>();
    private final Map<AnalysisMethod, Safety> methodSafety = new HashMap<AnalysisMethod, Safety>();
    private final Collection<AnalysisMethod> methods;

    TypeInitializerGraph(AnalysisUniverse universe) {
        this.hostVM = (SVMHost)universe.hostVM();
        this.classInitializationSupport = this.hostVM.getClassInitializationSupport();
        universe.getTypes().forEach(this::addInitializer);
        universe.getTypes().forEach(this::addInitializerDependencies);
        this.methods = universe.getMethods();
        this.methods.forEach(m -> this.methodSafety.put((AnalysisMethod)m, this.initialMethodSafety((AnalysisMethod)m)));
    }

    void computeInitializerSafety() {
        AtomicBoolean methodSafetyChanged;
        boolean newPromotions;
        do {
            methodSafetyChanged = new AtomicBoolean(false);
            this.methods.stream().filter(m -> this.methodSafety.get(m) == Safety.SAFE).forEach(m -> {
                if (this.updateMethodSafety((AnalysisMethod)m)) {
                    methodSafetyChanged.set(true);
                }
            });
        } while (newPromotions = methodSafetyChanged.get() || this.updateTypeInitializerSafety());
    }

    private Safety initialTypeInitializerSafety(AnalysisType t) {
        return this.classInitializationSupport.canBeProvenSafe(t.getJavaClass()) ? Safety.SAFE : Safety.UNSAFE;
    }

    boolean isUnsafe(AnalysisType type) {
        return this.types.get(type) == Safety.UNSAFE;
    }

    public void setUnsafe(AnalysisType t) {
        this.types.put(t, Safety.UNSAFE);
    }

    private boolean updateTypeInitializerSafety() {
        List<AnalysisType> newUnsafeTypes = this.types.keySet().stream().filter(type -> this.shouldPromoteToUnsafe((AnalysisType)type, this.methodSafety)).collect(Collectors.toList());
        newUnsafeTypes.forEach(this::setUnsafe);
        return !newUnsafeTypes.isEmpty();
    }

    private void addInitializerDependencies(AnalysisType t) {
        this.addInterfaceDependencies(t, t.getInterfaces());
        if (t.getSuperclass() != null) {
            this.addDependency(t, t.getSuperclass());
        }
    }

    private void addInterfaceDependencies(AnalysisType t, AnalysisType[] interfaces) {
        for (AnalysisType anInterface : interfaces) {
            if (anInterface.declaresDefaultMethods()) {
                this.addDependency(t, anInterface);
            }
            this.addInterfaceDependencies(t, anInterface.getInterfaces());
        }
    }

    private void addDependency(AnalysisType dependent, AnalysisType dependee) {
        this.dependencies.get(dependent).add(dependee);
    }

    private Safety initialMethodSafety(AnalysisMethod m) {
        return m.getTypeFlow().getInvokes().stream().anyMatch(this::isInvokeInitiallyUnsafe) || this.hostVM.hasClassInitializerSideEffect(m) || this.isSubstitutedMethod(m) ? Safety.UNSAFE : Safety.SAFE;
    }

    private boolean isSubstitutedMethod(AnalysisMethod m) {
        return !this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)m.getDeclaringClass()) && m.getWrapped() instanceof SubstitutionMethod;
    }

    private boolean isInvokeInitiallyUnsafe(InvokeTypeFlow i) {
        return i.getTargetMethod().isNative() || !i.canBeStaticallyBound();
    }

    private boolean shouldPromoteToUnsafe(AnalysisType type, Map<AnalysisMethod, Safety> safeMethods) {
        if (this.types.get(type) == Safety.UNSAFE) {
            return false;
        }
        if (this.dependencies.get(type).stream().anyMatch(t -> this.shouldPromoteToUnsafe((AnalysisType)t, safeMethods))) {
            return true;
        }
        return type.getClassInitializer() != null && safeMethods.get(type.getClassInitializer()) == Safety.UNSAFE;
    }

    private boolean updateMethodSafety(AnalysisMethod m) {
        assert (this.methodSafety.get(m) == Safety.SAFE);
        Collection invokes = m.getTypeFlow().getInvokes();
        if (invokes.stream().anyMatch(this::isInvokeUnsafeIterative)) {
            this.methodSafety.put(m, Safety.UNSAFE);
            return true;
        }
        if (this.hostVM.getInitializedClasses(m).stream().anyMatch(this::isUnsafe)) {
            this.methodSafety.put(m, Safety.UNSAFE);
            return true;
        }
        return false;
    }

    private boolean isInvokeUnsafeIterative(InvokeTypeFlow i) {
        assert (i.getTargetMethod() != null) : "All methods can be statically bound.";
        return this.methodSafety.get(i.getTargetMethod()) == Safety.UNSAFE;
    }

    private void addInitializer(AnalysisType t) {
        this.types.put(t, this.initialTypeInitializerSafety(t));
        this.dependencies.put(t, new HashSet());
    }

    Set<AnalysisType> getDependencies(AnalysisType type) {
        return Collections.unmodifiableSet(this.dependencies.get(type));
    }

    private static enum Safety {
        SAFE,
        UNSAFE;

    }
}

