/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.dashboard.ToJson;
import com.oracle.svm.hosted.image.NativeImageHeap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;

class HeapBreakdownJsonObject
extends ToJson.JsonObject {
    private final Feature.AfterHeapLayoutAccess access;
    private boolean built = false;
    private static final String INFO_NAME = "name";
    private static final String INFO_SIZE = "size";
    private static final String INFO_COUNT = "count";
    private static final List<String> NAMES = Arrays.asList("name", "size", "count");
    private final HashMap<String, Statistics> sizes = new HashMap();

    HeapBreakdownJsonObject(Feature.AfterHeapLayoutAccess access) {
        this.access = access;
    }

    @Override
    Stream<String> getNames() {
        return Arrays.asList("heap-size").stream();
    }

    @Override
    ToJson.JsonValue getValue(String name) {
        return ToJson.JsonArray.get(this.sizes.entrySet().stream().map(ClassJsonObject::new));
    }

    @Override
    protected void build() {
        if (this.built) {
            return;
        }
        FeatureImpl.AfterHeapLayoutAccessImpl config = (FeatureImpl.AfterHeapLayoutAccessImpl)this.access;
        NativeImageHeap heap = config.getHeap();
        for (NativeImageHeap.ObjectInfo info : heap.getObjects()) {
            String className = info.getClazz().getName();
            Statistics stats = this.sizes.get(className);
            if (stats == null) {
                stats = new Statistics();
                this.sizes.put(className, stats);
            }
            stats.size += info.getSize();
            ++stats.count;
        }
        this.built = true;
    }

    private class Statistics {
        long size = 0L;
        long count = 0L;

        private Statistics() {
        }
    }

    private static class ClassJsonObject
    extends ToJson.JsonObject {
        private final Map.Entry<String, Statistics> entry;

        ClassJsonObject(Map.Entry<String, Statistics> entry) {
            this.entry = entry;
        }

        @Override
        Stream<String> getNames() {
            return NAMES.stream();
        }

        @Override
        ToJson.JsonValue getValue(String name) {
            switch (name) {
                case "name": {
                    return ToJson.JsonString.get(this.entry.getKey());
                }
                case "size": {
                    return ToJson.JsonNumber.get(this.entry.getValue().size);
                }
                case "count": {
                    return ToJson.JsonNumber.get(this.entry.getValue().count);
                }
            }
            return null;
        }
    }
}

