/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.util.ReflectionUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.nativeimage.impl.clinit.ClassInitializationTracking;

public class EarlyConstantFoldLoadFieldPlugin
implements NodePlugin {
    private final ResolvedJavaField isImageBuildTimeField;

    public EarlyConstantFoldLoadFieldPlugin(MetaAccessProvider metaAccess) {
        this.isImageBuildTimeField = metaAccess.lookupJavaField(ReflectionUtil.lookupField(ClassInitializationTracking.class, (String)"IS_IMAGE_BUILD_TIME"));
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField field) {
        if (field.equals(this.isImageBuildTimeField)) {
            b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)false));
            return true;
        }
        if (field.isSynthetic() && field.getName().startsWith("$assertionsDisabled")) {
            boolean assertionsEnabled = SubstrateOptions.getRuntimeAssertionsForClass(field.getDeclaringClass().toJavaName());
            b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((!assertionsEnabled ? 1 : 0) != 0));
            return true;
        }
        return false;
    }
}

