/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.config.ConfigurationValues;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class SystemPropertiesSupport {
    private static final String[] HOSTED_PROPERTIES = new String[]{"java.version", "org.graalvm.nativeimage.kind", "line.separator", "path.separator", "file.separator", "file.encoding", "sun.jnu.encoding", "java.class.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version"};
    private final Map<String, Supplier<String>> lazyRuntimeValues;
    private Properties properties;
    private final Map<String, String> savedProperties;
    private final Map<String, String> readOnlySavedProperties;
    private final String hostOS = System.getProperty("os.name");
    private volatile boolean fullyInitialized;
    private String cachedUserName;
    private String cachedUserHome;
    private String cachedUserDir;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SystemPropertiesSupport() {
        this.properties = new Properties();
        this.savedProperties = new HashMap<String, String>();
        this.readOnlySavedProperties = Collections.unmodifiableMap(this.savedProperties);
        for (String key : HOSTED_PROPERTIES) {
            String value = System.getProperty(key);
            this.properties.put(key, value);
            this.savedProperties.put(key, value);
        }
        this.initializeProperty("java.vm.name", "Substrate VM");
        this.initializeProperty("java.vm.vendor", "Oracle Corporation");
        this.initializeProperty("java.vendor", "Oracle Corporation");
        this.initializeProperty("java.vendor.url", "https://www.graalvm.org/");
        this.initializeProperty("java.class.path", "");
        this.initializeProperty("java.endorsed.dirs", "");
        this.initializeProperty("java.ext.dirs", "");
        this.initializeProperty("java.library.path", "");
        this.initializeProperty("sun.arch.data.model", Integer.toString(ConfigurationValues.getTarget().wordJavaKind.getBitCount()));
        this.initializeProperty("org.graalvm.nativeimage.imagecode", "runtime");
        if (OS.getCurrent() == OS.LINUX && JavaVersionUtil.JAVA_SPEC == 11) {
            this.initializeProperty("awt.toolkit", System.getProperty("awt.toolkit"));
            this.initializeProperty("java.awt.graphicsenv", System.getProperty("java.awt.graphicsenv"));
            this.initializeProperty("java.awt.printerjob", System.getProperty("java.awt.printerjob"));
        }
        this.lazyRuntimeValues = new HashMap<String, Supplier<String>>();
        this.lazyRuntimeValues.put("user.name", this::userName);
        this.lazyRuntimeValues.put("user.home", this::userHome);
        this.lazyRuntimeValues.put("user.dir", this::userDir);
        this.lazyRuntimeValues.put("java.io.tmpdir", this::tmpdirValue);
        this.lazyRuntimeValues.put("os.version", this::osVersionValue);
        this.lazyRuntimeValues.put("java.vm.version", VM::getVersion);
        String targetName = System.getProperty("svm.targetName");
        if (targetName != null) {
            this.initializeProperty("os.name", targetName);
        } else {
            this.lazyRuntimeValues.put("os.name", this::osNameValue);
        }
        String targetArch = System.getProperty("svm.targetArch");
        if (targetArch != null) {
            this.initializeProperty("os.arch", targetArch);
        } else {
            this.initializeProperty("os.arch", ((Platform)ImageSingletons.lookup(Platform.class)).getArchitecture());
        }
    }

    private void ensureFullyInitialized() {
        if (!this.fullyInitialized) {
            for (String key : this.lazyRuntimeValues.keySet()) {
                this.initializeLazyValue(key);
            }
            this.fullyInitialized = true;
        }
    }

    public Map<String, String> getSavedProperties() {
        this.ensureFullyInitialized();
        return this.readOnlySavedProperties;
    }

    public Properties getProperties() {
        this.ensureFullyInitialized();
        return this.properties;
    }

    protected String getProperty(String key) {
        this.initializeLazyValue(key);
        return this.properties.getProperty(key);
    }

    public void setProperties(Properties props) {
        this.ensureFullyInitialized();
        if (props == null) {
            Properties newProps = new Properties();
            for (Map.Entry<String, String> e : this.savedProperties.entrySet()) {
                newProps.setProperty(e.getKey(), e.getValue());
            }
            this.properties = newProps;
        } else {
            this.properties = props;
        }
    }

    public void initializeProperty(String key, String value) {
        this.savedProperties.put(key, value);
        this.properties.setProperty(key, value);
    }

    public String setProperty(String key, String value) {
        this.initializeLazyValue(key);
        return (String)this.properties.setProperty(key, value);
    }

    public String clearProperty(String key) {
        this.initializeLazyValue(key);
        return (String)this.properties.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLazyValue(String key) {
        String value;
        if (!this.fullyInitialized && this.lazyRuntimeValues.containsKey(key) && this.properties.get(key) == null && this.properties.putIfAbsent(key, value = this.lazyRuntimeValues.get(key).get()) == null) {
            Map<String, String> map = this.savedProperties;
            synchronized (map) {
                this.savedProperties.put(key, value);
            }
        }
    }

    public String userName() {
        if (this.cachedUserName == null) {
            this.cachedUserName = this.userNameValue();
        }
        return this.cachedUserName;
    }

    public String userHome() {
        if (this.cachedUserHome == null) {
            this.cachedUserHome = this.userHomeValue();
        }
        return this.cachedUserHome;
    }

    public String userDir() {
        if (this.cachedUserDir == null) {
            this.cachedUserDir = this.userDirValue();
        }
        return this.cachedUserDir;
    }

    protected abstract String userNameValue();

    protected abstract String userHomeValue();

    protected abstract String userDirValue();

    protected abstract String tmpdirValue();

    protected String osNameValue() {
        return this.hostOS;
    }

    protected abstract String osVersionValue();
}

