/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.hosted.AccessorComputer;
import com.oracle.svm.reflect.target.ReflectionHelper;
import com.oracle.svm.reflect.target.Target_jdk_internal_reflect_ConstructorAccessor;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import sun.reflect.generics.repository.ConstructorRepository;

@TargetClass(value=Constructor.class)
public final class Target_java_lang_reflect_Constructor {
    @Alias
    ConstructorRepository genericInfo;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AccessorComputer.class)
    Target_jdk_internal_reflect_ConstructorAccessor constructorAccessor;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ConstructorAnnotatedReceiverTypeComputer.class)
    AnnotatedType annotatedReceiverType;

    @Alias
    native Target_java_lang_reflect_Constructor copy();

    @Substitute
    Target_jdk_internal_reflect_ConstructorAccessor acquireConstructorAccessor() {
        if (this.constructorAccessor == null) {
            throw VMError.unsupportedFeature("Runtime reflection is not supported.");
        }
        return this.constructorAccessor;
    }

    @Substitute
    public AnnotatedType getAnnotatedReceiverType() {
        Target_java_lang_reflect_Constructor holder = ReflectionHelper.getHolder(this);
        return JavaVersionUtil.JAVA_SPEC == 8 ? ReflectionHelper.requireNonNull(holder.annotatedReceiverType, "Annotated receiver type must be computed during native image generation") : holder.annotatedReceiverType;
    }

    public static final class ConstructorAnnotatedReceiverTypeComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Constructor constructor = (Constructor)receiver;
            return constructor.getAnnotatedReceiverType();
        }
    }
}

