/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.graal.code.NativeImagePatcher;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;

class MovSequenceNativeImagePatcher
extends CompilationResult.CodeAnnotation
implements NativeImagePatcher {
    private final AArch64MacroAssembler.MovSequenceAnnotation annotation;

    MovSequenceNativeImagePatcher(AArch64MacroAssembler.MovSequenceAnnotation annotation) {
        super(annotation.instructionPosition);
        this.annotation = annotation;
    }

    @Override
    public void patchCode(int relative, byte[] code) {
        this.annotation.patch(this.annotation.instructionPosition, relative, code);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public int getOffset() {
        throw VMError.unsupportedFeature("trying to get offset of move sequence");
    }

    @Override
    public int getLength() {
        throw VMError.unsupportedFeature("trying to get length of move sequence");
    }
}

