/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Hybrid;
import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.hub.AnnotatedSuperInfo;
import com.oracle.svm.core.hub.AnnotationsEncoding;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.GenericInfo;
import com.oracle.svm.core.hub.HubType;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.hub.ReferenceType;
import com.oracle.svm.core.hub.Target_java_lang_Class_ReflectionData;
import com.oracle.svm.core.hub.Target_java_lang_constant_Constable;
import com.oracle.svm.core.hub.Target_java_lang_invoke_TypeDescriptor_OfField;
import com.oracle.svm.core.hub.Target_java_lang_reflect_RecordComponent;
import com.oracle.svm.core.hub.Target_jdk_internal_reflect_ConstantPool;
import com.oracle.svm.core.hub.Target_jdk_internal_reflect_ReflectionFactory;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK15OrLater;
import com.oracle.svm.core.jdk.JDK16OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.LazyFinalReference;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.util.DirectAnnotationAccess;
import sun.security.util.SecurityConstants;

@Hybrid(canHybridFieldsBeDuplicated=false)
@Substitute
@TargetClass(value=Class.class)
@SuppressFBWarnings(value={"Se"}, justification="DynamicHub must implement Serializable for compatibility with java.lang.Class, not because of actual serialization")
public final class DynamicHub
implements JavaKind.FormatWithToString,
AnnotatedElement,
Type,
GenericDeclaration,
Serializable,
Target_java_lang_invoke_TypeDescriptor_OfField<DynamicHub>,
Target_java_lang_constant_Constable {
    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final int SYNTHETIC = 4096;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Class<?> hostedJavaClass;
    private String name;
    private int hubType;
    private byte referenceType;
    private int layoutEncoding;
    private int typeID;
    private short typeCheckStart;
    private short typeCheckRange;
    private short typeCheckSlot;
    private short monitorOffset;
    private byte flags;
    private static final int IS_LOCAL_CLASS_FLAG_BIT = 0;
    private static final int IS_INSTANTIATED_FLAG_BIT = 1;
    private static final int IS_HIDDED_FLAG_BIT = 2;
    private static final int IS_RECORD_FLAG_BIT = 3;
    private static final int ASSERTION_STATUS_FLAG_BIT = 4;
    private static final int HAS_DEFAULT_METHODS_FLAG_BIT = 5;
    private static final int DECLARES_DEFAULT_METHODS_FLAG_BIT = 6;
    private Object isAnonymousClass;
    private final int modifiers;
    private final DynamicHub superHub;
    @Substitute
    private final DynamicHub componentType;
    private DynamicHub arrayHub;
    private DynamicHub enclosingClass;
    private Object interfacesEncoding;
    private Object enumConstantsReference;
    private int referenceMapIndex;
    private SharedType metaType;
    private String sourceFileName;
    private Object annotationsEncoding;
    private ClassInitializationInfo classInitializationInfo;
    private final ClassLoader classLoader;
    @Hybrid.TypeIDSlots
    private short[] typeCheckSlots;
    @Hybrid.Array
    private CFunctionPointer[] vtable;
    private GenericInfo genericInfo;
    private AnnotatedSuperInfo annotatedSuperInfo;
    private Object module;
    private final Class<?> nestHost;
    private static final LazyFinalReference<ProtectionDomain> allPermDomainReference = new LazyFinalReference<ProtectionDomain>(() -> {
        CodeSource cs;
        Permissions perms = new Permissions();
        perms.add(SecurityConstants.ALL_PERMISSION);
        try {
            cs = new CodeSource(new File(ProcessProperties.getExecutableName()).toURI().toURL(), (Certificate[])null);
        }
        catch (MalformedURLException ex) {
            cs = null;
        }
        return new ProtectionDomain(cs, perms);
    });
    public static final LazyFinalReference<Target_java_lang_Module> singleModuleReference = new LazyFinalReference<Target_java_lang_Module>(Target_java_lang_Module::new);
    private final LazyFinalReference<String> packageNameReference = new LazyFinalReference<String>(this::computePackageName);
    private static final ReflectionData NO_REFLECTION_DATA = new ReflectionData(new Field[0], new Field[0], new Field[0], new Method[0], new Method[0], new Constructor[0], new Constructor[0], null, new Field[0], new Method[0], new Class[0], new Class[0], null, null);
    private ReflectionData rd = NO_REFLECTION_DATA;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setModule(Object module) {
        this.module = module;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DynamicHub(Class<?> hostedJavaClass, String name, HubType hubType, ReferenceType referenceType, boolean isLocalClass, Object isAnonymousClass, DynamicHub superType, DynamicHub componentHub, String sourceFileName, int modifiers, ClassLoader classLoader, boolean isHidden, boolean isRecord, Class<?> nestHost, boolean assertionStatus) {
        this.hostedJavaClass = hostedJavaClass;
        this.name = name;
        this.hubType = hubType.getValue();
        this.referenceType = referenceType.getValue();
        this.setFlag(0, isLocalClass);
        this.isAnonymousClass = isAnonymousClass;
        this.superHub = superType;
        this.componentType = componentHub;
        this.sourceFileName = sourceFileName;
        this.modifiers = modifiers;
        this.classLoader = classLoader;
        this.setFlag(2, isHidden);
        this.setFlag(3, isRecord);
        this.nestHost = nestHost;
        this.setFlag(4, assertionStatus);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void setFlag(int flagBit, boolean value) {
        int flagMask = 1 << flagBit;
        this.flags = NumUtil.safeToByte((int)(this.flags & ~flagMask | (value ? flagMask : 0)));
        assert (this.isFlagSet(flagBit) == value);
    }

    private boolean isFlagSet(int flagBit) {
        int flagMask = 1 << flagBit;
        return (this.flags & flagMask) != 0;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setClassInitializationInfo(ClassInitializationInfo classInitializationInfo, boolean hasDefaultMethods, boolean declaresDefaultMethods) {
        assert (this.classInitializationInfo == null) : "Initialization must be called only once";
        this.classInitializationInfo = classInitializationInfo;
        this.setFlag(5, hasDefaultMethods);
        this.setFlag(6, declaresDefaultMethods);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setClassInitializationInfo(ClassInitializationInfo classInitializationInfo) {
        this.classInitializationInfo = classInitializationInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setData(int layoutEncoding, int typeID, int monitorOffset, short typeCheckStart, short typeCheckRange, short typeCheckSlot, short[] typeCheckSlots, CFunctionPointer[] vtable, long referenceMapIndex, boolean isInstantiated) {
        assert (this.vtable == null) : "Initialization must be called only once";
        this.layoutEncoding = layoutEncoding;
        this.typeID = typeID;
        this.monitorOffset = NumUtil.safeToShort((int)monitorOffset);
        this.typeCheckStart = typeCheckStart;
        this.typeCheckRange = typeCheckRange;
        this.typeCheckSlot = typeCheckSlot;
        this.typeCheckSlots = typeCheckSlots;
        this.vtable = vtable;
        if ((long)((int)referenceMapIndex) != referenceMapIndex) {
            throw VMError.shouldNotReachHere("Reference map index not within integer range, need to switch field from int to long");
        }
        this.referenceMapIndex = (int)referenceMapIndex;
        this.setFlag(1, isInstantiated);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setArrayHub(DynamicHub arrayHub) {
        assert ((this.arrayHub == null || this.arrayHub == arrayHub) && arrayHub != null);
        assert (arrayHub.getComponentHub() == this);
        this.arrayHub = arrayHub;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setEnclosingClass(DynamicHub enclosingClass) {
        assert ((this.enclosingClass == null || this.enclosingClass == enclosingClass) && enclosingClass != null);
        this.enclosingClass = enclosingClass;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setGenericInfo(GenericInfo genericInfo) {
        this.genericInfo = genericInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public GenericInfo getGenericInfo() {
        return this.genericInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setAnnotatedSuperInfo(AnnotatedSuperInfo annotatedSuperInfo) {
        this.annotatedSuperInfo = annotatedSuperInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AnnotatedSuperInfo getAnnotatedSuperInfo() {
        return this.annotatedSuperInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setInterfacesEncoding(Object interfacesEncoding) {
        this.interfacesEncoding = interfacesEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getInterfacesEncoding() {
        return this.interfacesEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setAnnotationsEncoding(Object annotationsEncoding) {
        this.annotationsEncoding = annotationsEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getAnnotationsEncoding() {
        return this.annotationsEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean shouldInitEnumConstants() {
        return this.enumConstantsReference == null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initEnumConstants(Enum<?>[] enumConstants) {
        this.enumConstantsReference = enumConstants;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initEnumConstantsAtRuntime(Class<?> enumClass) {
        try {
            Method values = ReflectionUtil.lookupMethod(enumClass, (String)"values", (Class[])new Class[0]);
            this.enumConstantsReference = new LazyFinalReference<Object>(() -> DynamicHub.initEnumConstantsAtRuntime(values));
        }
        catch (ReflectionUtil.ReflectionUtilError e) {
            this.enumConstantsReference = null;
        }
        catch (NoClassDefFoundError e) {
            String message = e.getMessage();
            this.enumConstantsReference = new LazyFinalReference<Object>(() -> DynamicHub.throwNoClassDefFoundErrorAtRuntime(message));
        }
    }

    private static Object initEnumConstantsAtRuntime(Method values) {
        try {
            return values.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static Object throwNoClassDefFoundErrorAtRuntime(String message) {
        throw new NoClassDefFoundError(message);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setMetaType(SharedType metaType) {
        this.metaType = metaType;
    }

    public boolean hasDefaultMethods() {
        return this.isFlagSet(5);
    }

    public boolean declaresDefaultMethods() {
        return this.isFlagSet(6);
    }

    public ClassInitializationInfo getClassInitializationInfo() {
        return this.classInitializationInfo;
    }

    public boolean isInitialized() {
        return this.classInitializationInfo.isInitialized();
    }

    public void ensureInitialized() {
        EnsureClassInitializedNode.ensureClassInitialized(DynamicHub.toClass(this));
    }

    public SharedType getMetaType() {
        return this.metaType;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getLayoutEncoding() {
        return this.layoutEncoding;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public short getTypeCheckSlot() {
        return this.typeCheckSlot;
    }

    public short getTypeCheckStart() {
        return this.typeCheckStart;
    }

    public short getTypeCheckRange() {
        return this.typeCheckRange;
    }

    public int getMonitorOffset() {
        return this.monitorOffset;
    }

    public DynamicHub getSuperHub() {
        return this.superHub;
    }

    public DynamicHub getComponentHub() {
        return this.componentType;
    }

    public DynamicHub getArrayHub() {
        return this.arrayHub;
    }

    public int getReferenceMapIndex() {
        return this.referenceMapIndex;
    }

    public boolean isInstantiated() {
        return this.isFlagSet(1);
    }

    public static DynamicHub fromClass(Class<?> clazz) {
        return SubstrateUtil.cast(clazz, DynamicHub.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Class<?> toClass(DynamicHub hub) {
        return SubstrateUtil.cast(hub, Class.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Class<?> getHostedJavaClass() {
        return this.hostedJavaClass;
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    public boolean isInstanceClass() {
        return HubType.isInstance(this.hubType);
    }

    public boolean isStoredContinuationClass() {
        return HubType.isStoredContinuation(this.hubType);
    }

    public boolean isReferenceInstanceClass() {
        return HubType.isReferenceInstance(this.hubType);
    }

    @Override
    @Substitute
    public boolean isArray() {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    public boolean hubIsArray() {
        return HubType.isArray(this.hubType);
    }

    @Substitute
    public boolean isInterface() {
        return LayoutEncoding.isInterface(this.getLayoutEncoding());
    }

    @Override
    @Substitute
    public boolean isPrimitive() {
        return LayoutEncoding.isPrimitive(this.getLayoutEncoding());
    }

    @Substitute
    public int getModifiers() {
        return this.modifiers;
    }

    @Substitute
    private Object getComponentType() {
        return this.componentType;
    }

    @Substitute
    private Object getSuperclass() {
        return this.superHub;
    }

    @Substitute
    private boolean isInstance(Object obj) {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    @Substitute
    private Object cast(Object obj) {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    @Substitute
    private boolean isAssignableFrom(Class<?> cls) {
        throw VMError.shouldNotReachHere("Intrinsified in StandardGraphBuilderPlugins.");
    }

    @Substitute
    private boolean isAnnotation() {
        return this.isInterface() && this.getInterfaces().length == 1 && DynamicHub.toClass(this.getInterfaces()[0]) == Annotation.class;
    }

    @Substitute
    private boolean isEnum() {
        return this.getSuperclass() == Enum.class;
    }

    @KeepOriginal
    private native Enum<?>[] getEnumConstants();

    @Substitute
    public Enum<?>[] getEnumConstantsShared() {
        if (this.enumConstantsReference instanceof LazyFinalReference) {
            return (Enum[])((LazyFinalReference)this.enumConstantsReference).get();
        }
        return (Enum[])this.enumConstantsReference;
    }

    @Substitute
    private InputStream getResourceAsStream(String resourceName) {
        String path = this.resolveName(this.getName(), resourceName);
        List<byte[]> arr = Resources.get(path);
        return arr == null ? null : new ByteArrayInputStream(arr.get(0));
    }

    @Substitute
    private URL getResource(String resourceName) {
        String path = this.resolveName(this.getName(), resourceName);
        List<byte[]> arr = Resources.get(path);
        return arr == null ? null : Resources.createURL(path, arr.get(0));
    }

    private String resolveName(String baseName, String resourceName) {
        if (resourceName == null) {
            return resourceName;
        }
        if (resourceName.startsWith("/")) {
            return resourceName.substring(1);
        }
        int index = baseName.lastIndexOf(46);
        if (index != -1) {
            return baseName.substring(0, index).replace('.', '/') + "/" + resourceName;
        }
        return resourceName;
    }

    @KeepOriginal
    private native ClassLoader getClassLoader();

    @Substitute
    private ClassLoader getClassLoader0() {
        return this.classLoader;
    }

    @KeepOriginal
    @TargetElement(name="getSimpleName", onlyWith={JDK8OrEarlier.class})
    private native String getSimpleNameJDK8OrEarlier();

    @Substitute
    @TargetElement(name="getSimpleName", onlyWith={JDK11OrLater.class})
    private String getSimpleNameJDK11OrLater() {
        return this.getSimpleName0();
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native String getSimpleName0();

    @KeepOriginal
    @TargetElement(name="getCanonicalName", onlyWith={JDK8OrEarlier.class})
    private native String getCanonicalNameJDK8OrEarlier();

    @Substitute
    @TargetElement(name="getCanonicalName", onlyWith={JDK11OrLater.class})
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="sentinel string comparison")
    private String getCanonicalNameJDK11OrLater() {
        String canonicalName = this.getCanonicalName0();
        return canonicalName == Target_java_lang_Class_ReflectionData.NULL_SENTINEL ? null : canonicalName;
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native String getCanonicalName0();

    @Override
    @KeepOriginal
    public native String getTypeName();

    @KeepOriginal
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native boolean isAsciiDigit(char var0);

    @KeepOriginal
    private native String getSimpleBinaryName();

    @KeepOriginal
    private native <U> Class<? extends U> asSubclass(Class<U> var1);

    @Substitute
    private boolean isAnonymousClass() {
        if (this.isAnonymousClass instanceof Boolean) {
            return (Boolean)this.isAnonymousClass;
        }
        if (this.isAnonymousClass instanceof LinkageError) {
            throw (LinkageError)this.isAnonymousClass;
        }
        if (this.isAnonymousClass instanceof InternalError) {
            throw (InternalError)this.isAnonymousClass;
        }
        throw VMError.shouldNotReachHere();
    }

    @Substitute
    @TargetElement(onlyWith={JDK15OrLater.class})
    public boolean isHidden() {
        return this.isFlagSet(2);
    }

    @Substitute
    @TargetElement(onlyWith={JDK15OrLater.class})
    public boolean isRecord() {
        return this.isFlagSet(3);
    }

    @Substitute
    private boolean isLocalClass() {
        return this.isFlagSet(0);
    }

    @KeepOriginal
    private native boolean isMemberClass();

    @Substitute
    public boolean isLocalOrAnonymousClass() {
        return this.isLocalClass() || this.isAnonymousClass();
    }

    @Substitute
    private Object getEnclosingClass() {
        return this.enclosingClass;
    }

    @KeepOriginal
    @TargetElement(name="getDeclaringClass", onlyWith={JDK11OrLater.class})
    private native Object getDeclaringClassJDK11OrLater();

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private Object getDeclaringClass0() {
        return this.getDeclaringClassInternal();
    }

    @Substitute
    @TargetElement(name="getDeclaringClass", onlyWith={JDK8OrEarlier.class})
    private Object getDeclaringClassJDK8OrEarlier() {
        return this.getDeclaringClassInternal();
    }

    private Object getDeclaringClassInternal() {
        if (this.isLocalOrAnonymousClass()) {
            return null;
        }
        return this.enclosingClass;
    }

    @Substitute
    public DynamicHub[] getInterfaces() {
        return DynamicHub.getInterfaces(this, true);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private DynamicHub[] getInterfaces(boolean cloneArray) {
        return DynamicHub.getInterfaces(this, cloneArray);
    }

    private static DynamicHub[] getInterfaces(DynamicHub hub, boolean cloneArray) {
        if (hub.interfacesEncoding == null) {
            return new DynamicHub[0];
        }
        if (hub.interfacesEncoding instanceof DynamicHub) {
            return new DynamicHub[]{(DynamicHub)hub.interfacesEncoding};
        }
        return cloneArray ? (DynamicHub[])((DynamicHub[])hub.interfacesEncoding).clone() : (DynamicHub[])hub.interfacesEncoding;
    }

    @Substitute
    public Object newInstance() throws Throwable {
        this.ensureInitialized();
        Constructor<?> nullaryConstructor = this.rd.nullaryConstructor;
        if (nullaryConstructor == null) {
            if (JavaVersionUtil.JAVA_SPEC <= 8) {
                throw new InstantiationException("Type `" + this.getCanonicalNameJDK8OrEarlier() + "` can not be instantiated reflectively as it does not have a no-parameter constructor or the no-parameter constructor has not been added explicitly to the native image.");
            }
            throw new InstantiationException("Type `" + this.getCanonicalNameJDK11OrLater() + "` can not be instantiated reflectively as it does not have a no-parameter constructor or the no-parameter constructor has not been added explicitly to the native image.");
        }
        try {
            return nullaryConstructor.newInstance(null);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static Object newInstanceInstantiationError(Object instance) throws InstantiationException {
        if (instance == null) {
            throw VMError.shouldNotReachHere("This case should be handled by the `DynamicNewInstance` lowering.");
        }
        throw new InstantiationException("Type `" + instance.getClass().getCanonicalName() + "` can not be instantiated reflectively as it does not have a no-parameter constructor.");
    }

    private static Object newInstanceReachableError(Object instance) {
        throw new RuntimeException("Constructor of `" + instance.getClass().getCanonicalName() + "` was removed by reachability analysis. Use `Feature.BeforeAnalysisAccess.registerForReflectiveInstantiation` to register the type for reflective instantiation.");
    }

    @Override
    @Substitute
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return AnnotationsEncoding.decodeAnnotations(this.annotationsEncoding).getAnnotation(annotationClass);
    }

    @Override
    @Substitute
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    @Substitute
    public Annotation[] getAnnotations() {
        return AnnotationsEncoding.decodeAnnotations(this.annotationsEncoding).getAnnotations();
    }

    @Override
    @Substitute
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        DynamicHub superClass;
        Annotation[] result = this.getDeclaredAnnotationsByType(annotationClass);
        if (result.length == 0 && DirectAnnotationAccess.isAnnotationPresent(annotationClass, Inherited.class) && (superClass = (DynamicHub)this.getSuperclass()) != null) {
            result = superClass.getAnnotationsByType(annotationClass);
        }
        return result;
    }

    @Override
    @Substitute
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationsEncoding.decodeAnnotations(this.annotationsEncoding).getDeclaredAnnotations();
    }

    @Substitute
    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationClass) {
        return GenericDeclaration.super.getDeclaredAnnotationsByType(annotationClass);
    }

    @Override
    @Substitute
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return AnnotationsEncoding.decodeAnnotations(this.annotationsEncoding).getDeclaredAnnotation(annotationClass);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setReflectionData(ReflectionData rd) {
        this.rd = rd;
    }

    @KeepOriginal
    private native Field[] getFields();

    @KeepOriginal
    private native Method[] getMethods();

    @KeepOriginal
    private native Constructor<?>[] getConstructors();

    @Substitute
    private Field getField(String name) throws NoSuchFieldException {
        for (Field field : this.rd.publicUnhiddenFields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw new NoSuchFieldException(name);
    }

    @Substitute
    private Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method method = DynamicHub.searchMethods(this.rd.publicMethods, name, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException(DynamicHub.describeMethod(this.getName() + "." + name + "(", parameterTypes, ")"));
        }
        return method;
    }

    @KeepOriginal
    private native Constructor<?> getConstructor(Class<?> ... var1);

    @Substitute
    private Class<?>[] getDeclaredClasses() {
        return this.rd.declaredClasses;
    }

    @Substitute
    private Class<?>[] getClasses() {
        return this.rd.publicClasses;
    }

    @KeepOriginal
    private native Field[] getDeclaredFields();

    @KeepOriginal
    private native Method[] getDeclaredMethods();

    @KeepOriginal
    private native Constructor<?>[] getDeclaredConstructors();

    @KeepOriginal
    private native Field getDeclaredField(String var1);

    @KeepOriginal
    private native Method getDeclaredMethod(String var1, Class<?> ... var2);

    @KeepOriginal
    private native Constructor<?> getDeclaredConstructor(Class<?> ... var1);

    @Substitute
    private Constructor<?>[] privateGetDeclaredConstructors(boolean publicOnly) {
        return publicOnly ? this.rd.publicConstructors : this.rd.declaredConstructors;
    }

    @Substitute
    private Field[] privateGetDeclaredFields(boolean publicOnly) {
        return publicOnly ? this.rd.declaredPublicFields : this.rd.declaredFields;
    }

    @Substitute
    private Method[] privateGetDeclaredMethods(boolean publicOnly) {
        return publicOnly ? this.rd.declaredPublicMethods : this.rd.declaredMethods;
    }

    @Substitute
    @TargetElement(name="privateGetPublicFields", onlyWith={JDK8OrEarlier.class})
    private Field[] privateGetPublicFieldsJDK8OrEarlier(Set<Class<?>> traversedInterfaces) {
        return this.rd.publicFields;
    }

    @Substitute
    @TargetElement(name="privateGetPublicFields", onlyWith={JDK11OrLater.class})
    private Field[] privateGetPublicFieldsJDK11OrLater() {
        return this.rd.publicFields;
    }

    @Substitute
    private Method[] privateGetPublicMethods() {
        return this.rd.publicMethods;
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK16OrLater.class})
    private native Target_java_lang_reflect_RecordComponent[] getRecordComponents();

    @Substitute
    @TargetElement(onlyWith={JDK16OrLater.class})
    private Target_java_lang_reflect_RecordComponent[] getRecordComponents0() {
        Object[] result = this.rd.recordComponents;
        if (result == null) {
            throw VMError.unsupportedFeature("Record components not available for record class " + this.getTypeName() + ". All record component accessor methods of this record class must be included in the reflection configuration at image build time, then this method can be called.");
        }
        return (Target_java_lang_reflect_RecordComponent[])result;
    }

    @Substitute
    @TargetElement(name="checkMemberAccess", onlyWith={JDK8OrEarlier.class})
    private void checkMemberAccessJDK8OrEarlier(int which, Class<?> caller, boolean checkProxyInterfaces) {
    }

    @Substitute
    @TargetElement(name="checkMemberAccess", onlyWith={JDK11OrLater.class})
    private void checkMemberAccessJDK11OrLater(SecurityManager sm, int which, Class<?> caller, boolean checkProxyInterfaces) {
    }

    @Substitute
    private static Target_jdk_internal_reflect_ReflectionFactory getReflectionFactory() {
        return Target_jdk_internal_reflect_ReflectionFactory.getReflectionFactory();
    }

    @KeepOriginal
    private static native Field searchFields(Field[] var0, String var1);

    @KeepOriginal
    private static native Method searchMethods(Method[] var0, String var1, Class<?>[] var2);

    @KeepOriginal
    private native Constructor<?> getConstructor0(Class<?>[] var1, int var2);

    @KeepOriginal
    private static native boolean arrayContentsEq(Object[] var0, Object[] var1);

    @KeepOriginal
    private static native Field[] copyFields(Field[] var0);

    @KeepOriginal
    private static native Method[] copyMethods(Method[] var0);

    @KeepOriginal
    private static native <U> Constructor<U>[] copyConstructors(Constructor<U>[] var0);

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static String argumentTypesToString(Class<?>[] argTypes) {
        return DynamicHub.describeMethod("(", argTypes, ")");
    }

    @Override
    @Substitute
    public TypeVariable<?>[] getTypeParameters() {
        return this.genericInfo.getTypeParameters();
    }

    @Substitute
    public Type[] getGenericInterfaces() {
        return this.genericInfo.hasGenericInterfaces() ? this.genericInfo.getGenericInterfaces() : this.getInterfaces();
    }

    @Substitute
    public Type getGenericSuperclass() {
        return this.genericInfo.hasGenericSuperClass() ? this.genericInfo.getGenericSuperClass() : this.getSuperHub();
    }

    @Substitute
    public AnnotatedType getAnnotatedSuperclass() {
        return this.annotatedSuperInfo.getAnnotatedSuperclass();
    }

    @Substitute
    public AnnotatedType[] getAnnotatedInterfaces() {
        return this.annotatedSuperInfo.getAnnotatedInterfaces();
    }

    @Substitute
    private Method getEnclosingMethod() {
        if (this.rd.enclosingMethodOrConstructor instanceof Method) {
            return (Method)this.rd.enclosingMethodOrConstructor;
        }
        return null;
    }

    @Substitute
    private Constructor<?> getEnclosingConstructor() {
        if (this.rd.enclosingMethodOrConstructor instanceof Constructor) {
            return (Constructor)this.rd.enclosingMethodOrConstructor;
        }
        return null;
    }

    @Substitute
    private static Class<?> forName(String className) throws ClassNotFoundException {
        return ClassForNameSupport.forName(className, true);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public static Class<?> forName(Target_java_lang_Module module, String className) {
        return ClassForNameSupport.forNameOrNull(className, false);
    }

    @Substitute
    private static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return ClassForNameSupport.forName(name, initialize);
    }

    @KeepOriginal
    private native Package getPackage();

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public String getPackageName() {
        return this.packageNameReference.get();
    }

    private String computePackageName() {
        String cn;
        int dot;
        String pn = null;
        DynamicHub me = this;
        while (me.hubIsArray()) {
            me = (DynamicHub)me.getComponentType();
        }
        pn = me.isPrimitive() ? "java.lang" : ((dot = (cn = me.getName()).lastIndexOf(46)) != -1 ? cn.substring(0, dot).intern() : "");
        return pn;
    }

    @Substitute
    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    @KeepOriginal
    public native String toGenericString();

    @KeepOriginal
    public native boolean isSynthetic();

    @Substitute
    public Object[] getSigners() {
        return null;
    }

    @Substitute
    public ProtectionDomain getProtectionDomain() {
        return allPermDomainReference.get();
    }

    @Substitute
    public boolean desiredAssertionStatus() {
        return this.isFlagSet(4);
    }

    @Substitute
    @TargetElement(name="getModule", onlyWith={JDK11OrLater.class})
    public Target_java_lang_Module getModule() {
        return (Target_java_lang_Module)this.module;
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public String methodToString(String nameArg, Class<?>[] argTypes) {
        return DynamicHub.describeMethod(this.name + "." + nameArg + "(", argTypes, ")");
    }

    private static String describeMethod(String prefix, Class<?>[] argTypes, String suffix) {
        StringJoiner sj = new StringJoiner(", ", prefix, suffix);
        if (argTypes != null) {
            for (Class<?> c : argTypes) {
                sj.add(c == null ? "null" : c.getName());
            }
        }
        return sj.toString();
    }

    @Substitute
    private <T> Target_java_lang_Class_ReflectionData<T> reflectionData() {
        throw VMError.unsupportedFeature("JDK11OrLater: DynamicHub.reflectionData()");
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native boolean isTopLevelClass();

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private String getSimpleBinaryName0() {
        if (this.isAnonymousClass() || this.enclosingClass == null) {
            return null;
        }
        try {
            char firstLetter;
            int prefix = this.enclosingClass.getName().length();
            while (!Character.isLetter(firstLetter = this.name.charAt(++prefix))) {
            }
            return this.name.substring(prefix);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InternalError("Malformed class name", ex);
        }
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native List<Method> getDeclaredPublicMethods(String var1, Class<?> ... var2);

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public Class<?> getNestHost() {
        return this.nestHost;
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public boolean isNestmateOf(Class<?> c) {
        return this.nestHost == DynamicHub.fromClass(c).nestHost;
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private Class<?>[] getNestMembers() {
        throw VMError.unsupportedFeature("Class.getNestMembers is not supported yet");
    }

    @Override
    @Substitute
    @TargetElement(onlyWith={JDK15OrLater.class})
    public DynamicHub componentType() {
        return this.componentType;
    }

    @Override
    @Substitute
    @TargetElement(onlyWith={JDK15OrLater.class})
    public DynamicHub arrayType() {
        return this.arrayHub;
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK15OrLater.class})
    private Class<?> elementType() {
        throw VMError.unsupportedFeature("Method is not available in JDK 8 or JDK 11");
    }

    @Override
    @KeepOriginal
    @TargetElement(onlyWith={JDK15OrLater.class})
    public String descriptorString() {
        throw VMError.unsupportedFeature("Method is not available in JDK 8 or JDK 11");
    }

    @Override
    @KeepOriginal
    @TargetElement(onlyWith={JDK15OrLater.class})
    public Optional<?> describeConstable() {
        throw VMError.unsupportedFeature("Method is not available in JDK 8 or JDK 11");
    }

    @Delete
    private static native void registerNatives();

    @Delete
    static native Class<?> getPrimitiveClass(String var0);

    @Delete
    private native Object[] getEnclosingMethod0();

    @Delete
    private native Class<?>[] getInterfaces0();

    @Delete
    native void setSigners(Object[] var1);

    @Delete
    private native ProtectionDomain getProtectionDomain0();

    @Delete
    private native String getGenericSignature0();

    @Delete
    native byte[] getRawAnnotations();

    @Delete
    native byte[] getRawTypeAnnotations();

    @Delete
    native Target_jdk_internal_reflect_ConstantPool getConstantPool();

    @Delete
    private native Field[] getDeclaredFields0(boolean var1);

    @Delete
    private native Method[] getDeclaredMethods0(boolean var1);

    @Delete
    private native <T> Constructor<T>[] getDeclaredConstructors0(boolean var1);

    @Delete
    private native Class<?>[] getDeclaredClasses0();

    @Delete
    private static native boolean desiredAssertionStatus0(Class<?> var0);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native String getName0();

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native Class<?> getNestHost0();

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native Class<?>[] getNestMembers0();

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native String initClassName();

    @TargetClass(value=Class.class, innerClass={"MethodArray"}, onlyWith={JDK8OrEarlier.class})
    static final class Target_java_lang_Class_MethodArray {
        Target_java_lang_Class_MethodArray() {
        }
    }

    public static final class ReflectionData {
        final Field[] declaredFields;
        final Field[] publicFields;
        final Field[] publicUnhiddenFields;
        final Method[] declaredMethods;
        final Method[] publicMethods;
        final Constructor<?>[] declaredConstructors;
        final Constructor<?>[] publicConstructors;
        final Constructor<?> nullaryConstructor;
        final Field[] declaredPublicFields;
        final Method[] declaredPublicMethods;
        final Class<?>[] declaredClasses;
        final Class<?>[] publicClasses;
        final Object[] recordComponents;
        final Executable enclosingMethodOrConstructor;

        public ReflectionData(Field[] declaredFields, Field[] publicFields, Field[] publicUnhiddenFields, Method[] declaredMethods, Method[] publicMethods, Constructor<?>[] declaredConstructors, Constructor<?>[] publicConstructors, Constructor<?> nullaryConstructor, Field[] declaredPublicFields, Method[] declaredPublicMethods, Class<?>[] declaredClasses, Class<?>[] publicClasses, Executable enclosingMethodOrConstructor, Object[] recordComponents) {
            this.declaredFields = declaredFields;
            this.publicFields = publicFields;
            this.publicUnhiddenFields = publicUnhiddenFields;
            this.declaredMethods = declaredMethods;
            this.publicMethods = publicMethods;
            this.declaredConstructors = declaredConstructors;
            this.publicConstructors = publicConstructors;
            this.nullaryConstructor = nullaryConstructor;
            this.declaredPublicFields = declaredPublicFields;
            this.declaredPublicMethods = declaredPublicMethods;
            this.declaredClasses = declaredClasses;
            this.publicClasses = publicClasses;
            this.enclosingMethodOrConstructor = enclosingMethodOrConstructor;
            this.recordComponents = recordComponents;
        }
    }
}

