/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Policy;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.login.Configuration;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslServerFactory;
import javax.smartcardio.TerminalFactory;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;
import sun.security.provider.NativePRNG;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;

@AutomaticFeature
public class SecurityServicesFeature
extends JNIRegistrationUtil
implements Feature {
    private static final String SECURE_RANDOM_SERVICE = "SecureRandom";
    private static final String SIGNATURE_SERVICE = "Signature";
    private static final String CIPHER_SERVICE = "Cipher";
    private static final String KEY_AGREEMENT_SERVICE = "KeyAgreement";
    private static final String KEY_STORE = "KeyStore";
    private static final String CERTIFICATE_FACTORY = "CertificateFactory";
    private static final String JKS = "JKS";
    private static final String X509 = "X.509";
    private static final String[] emptyStringArray = new String[0];
    private static final Class<?>[] knownServices = new Class[]{AlgorithmParameterGenerator.class, AlgorithmParameters.class, CertPathBuilder.class, CertPathValidator.class, CertStore.class, CertificateFactory.class, Cipher.class, Configuration.class, KeyAgreement.class, KeyFactory.class, KeyGenerator.class, KeyInfoFactory.class, KeyManagerFactory.class, KeyPairGenerator.class, KeyStore.class, Mac.class, MessageDigest.class, Policy.class, SSLContext.class, SaslClientFactory.class, SaslServerFactory.class, SecretKeyFactory.class, SecureRandom.class, Signature.class, TerminalFactory.class, TransformService.class, TrustManagerFactory.class, XMLSignatureFactory.class};
    private ImageClassLoader loader;
    private Function<String, Class<?>> ctrParamClassAccessor;
    private Method getSpiClassMethod;
    private Map<String, Set<Provider.Service>> availableServices;
    private static final String SEP = ", ";

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.EnableSecurityServicesFeature.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.loader = access.imageClassLoader;
        this.ctrParamClassAccessor = SecurityServicesFeature.getConstructorParameterClassAccessor(this.loader);
        this.getSpiClassMethod = SecurityServicesFeature.getSpiClassMethod();
        this.availableServices = SecurityServicesFeature.computeAvailableServices();
        RuntimeClassInitializationSupport rci = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        rci.rerunInitialization(NativePRNG.class, "for substitutions");
        rci.rerunInitialization(NativePRNG.Blocking.class, "for substitutions");
        rci.rerunInitialization(NativePRNG.NonBlocking.class, "for substitutions");
        rci.rerunInitialization(SecurityServicesFeature.clazz(access, "sun.security.provider.SeedGenerator"), "for substitutions");
        rci.rerunInitialization(SecurityServicesFeature.clazz(access, "sun.security.provider.SecureRandom$SeederHolder"), "for substitutions");
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            rci.rerunInitialization(SecurityServicesFeature.clazz(access, "sun.security.provider.AbstractDrbg$SeederHolder"), "for substitutions");
        }
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            rci.rerunInitialization(SecurityServicesFeature.clazz(access, "sun.security.provider.FileInputStreamPool"), "for substitutions");
        }
        rci.rerunInitialization(SecurityServicesFeature.clazz(access, "java.util.UUID$Holder"), "for substitutions");
        rci.rerunInitialization(SecurityServicesFeature.clazz(access, "sun.security.jca.JCAUtil$CachedSecureRandomHolder"), "for substitutions");
        rci.rerunInitialization(SecurityServicesFeature.clazz(access, "com.sun.crypto.provider.SunJCE$SecureRandomHolder"), "for substitutions");
        rci.rerunInitialization(SecurityServicesFeature.clazz(access, "sun.security.krb5.Confounder"), "for substitutions");
        rci.rerunInitialization(SecurityServicesFeature.clazz(access, "sun.security.ssl.SSLContextImpl$DefaultManagersHolder"), "for reading properties at run time");
        SecurityServicesFeature.optionalClazz(access, "sun.security.ssl.Debug").ifPresent(c -> rci.rerunInitialization(c, "for reading properties at run time"));
        SecurityServicesFeature.optionalClazz(access, "sun.security.ssl.SSLLogger").ifPresent(c -> rci.rerunInitialization(c, "for reading properties at run time"));
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.registerServiceReachabilityHandlers(access);
        if (JavaVersionUtil.JAVA_SPEC < 16) {
            access.registerReachabilityHandler(SecurityServicesFeature::linkSunEC, new Object[]{SecurityServicesFeature.method((Feature.FeatureAccess)access, "sun.security.ec.ECDSASignature", "signDigest", byte[].class, byte[].class, byte[].class, byte[].class, Integer.TYPE), SecurityServicesFeature.method((Feature.FeatureAccess)access, "sun.security.ec.ECDSASignature", "verifySignedDigest", byte[].class, byte[].class, byte[].class, byte[].class)});
        }
        if (SecurityServicesFeature.isPosix()) {
            access.registerReachabilityHandler(SecurityServicesFeature::linkJaas, new Object[]{SecurityServicesFeature.method((Feature.FeatureAccess)access, "com.sun.security.auth.module.UnixSystem", "getUnixInfo", new Class[0])});
        }
    }

    private static void linkSunEC(Feature.DuringAnalysisAccess a) {
        NativeLibraries nativeLibraries = ((FeatureImpl.DuringAnalysisAccessImpl)a).getNativeLibraries();
        PlatformNativeLibrarySupport.singleton();
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("sunec");
        PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_security_ec");
        nativeLibraries.addStaticJniLibrary("sunec", new String[0]);
        if (SecurityServicesFeature.isPosix()) {
            nativeLibraries.addDynamicNonJniLibrary("stdc++");
        }
    }

    private static void linkJaas(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(SecurityServicesFeature.fields((Feature.FeatureAccess)a, "com.sun.security.auth.module.UnixSystem", "username", "uid", "gid", "groups"));
        NativeLibraries nativeLibraries = ((FeatureImpl.DuringAnalysisAccessImpl)a).getNativeLibraries();
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary(JavaVersionUtil.JAVA_SPEC >= 11 ? "jaas" : "jaas_unix");
        PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("com_sun_security_auth_module_UnixSystem");
        nativeLibraries.addStaticJniLibrary("jaas", new String[0]);
    }

    private void registerServiceReachabilityHandlers(Feature.BeforeAnalysisAccess access) {
        for (Class<?> serviceClass : knownServices) {
            Consumer<Feature.DuringAnalysisAccess> handler = a -> this.registerServices(serviceClass);
            for (Method method : serviceClass.getMethods()) {
                if (!method.getName().equals("getInstance")) continue;
                SecurityServicesFeature.checkGetInstanceMethod(method);
                access.registerReachabilityHandler(handler, new Object[]{method});
            }
        }
        access.registerReachabilityHandler(a -> this.registerServices(SECURE_RANDOM_SERVICE), new Object[]{SecurityServicesFeature.method((Feature.FeatureAccess)access, "java.security.Provider$Service", "newInstance", Object.class)});
    }

    private void registerServices(Class<?> serviceClass) {
        if (serviceClass.getPackage().getName().equals("java.security")) {
            SecurityServicesFeature.registerSpiClass(serviceClass, this.getSpiClassMethod);
        }
        this.registerServices(serviceClass.getSimpleName());
    }

    private void registerServices(String serviceType) {
        Set<Provider.Service> services = this.availableServices.get(serviceType);
        for (Provider.Service service : services) {
            SecurityServicesFeature.registerService(this.loader, service, this.ctrParamClassAccessor);
            Provider provider = service.getProvider();
            SecurityServicesFeature.registerProvider(provider);
        }
    }

    private static void checkGetInstanceMethod(Method method) {
        VMError.guarantee(Modifier.isPublic(method.getModifiers()));
        VMError.guarantee(Modifier.isStatic(method.getModifiers()));
        VMError.guarantee(method.getReturnType().equals(method.getDeclaringClass()));
    }

    private static Map<String, Set<Provider.Service>> computeAvailableServices() {
        HashMap<String, Set<Provider.Service>> availableServices = new HashMap<String, Set<Provider.Service>>();
        for (Provider provider : Security.getProviders()) {
            for (Provider.Service s : provider.getServices()) {
                availableServices.computeIfAbsent(s.getType(), t -> new HashSet()).add(s);
            }
        }
        return availableServices;
    }

    private static Function<String, Class<?>> getConstructorParameterClassAccessor(ImageClassLoader loader) {
        Map knownEngines = (Map)ReflectionUtil.readStaticField(Provider.class, (String)"knownEngines");
        Class<?> clazz = loader.findClass("java.security.Provider$EngineDescription").getOrFail();
        Field consParamClassNameField = ReflectionUtil.lookupField(clazz, (String)"constructorParameterClassName");
        return serviceType -> {
            try {
                Object engineDescription = knownEngines.get(serviceType);
                if (engineDescription == null) {
                    return null;
                }
                String constrParamClassName = (String)consParamClassNameField.get(engineDescription);
                if (constrParamClassName != null) {
                    return loader.findClass(constrParamClassName).get();
                }
            }
            catch (IllegalAccessException e) {
                VMError.shouldNotReachHere(e);
            }
            return null;
        };
    }

    private static Method getSpiClassMethod() {
        try {
            Method method = Security.class.getDeclaredMethod("getSpiClass", String.class);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static void registerSpiClass(Class<?> serviceClass, Method getSpiClassMethod) {
        try {
            Class spiClass = (Class)getSpiClassMethod.invoke(null, serviceClass.getSimpleName());
            RuntimeReflection.register((Class[])new Class[]{spiClass});
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static void registerProvider(Provider provider) {
        SecurityServicesFeature.registerForReflection(provider.getClass());
        try {
            Method getVerificationResult = ReflectionUtil.lookupMethod(Class.forName("javax.crypto.JceSecurity"), (String)"getVerificationResult", (Class[])new Class[]{Provider.class});
            getVerificationResult.invoke(null, provider);
            SecurityServicesFeature.trace("Provider registered: %s", provider.getName());
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static void registerService(ImageClassLoader loader, Provider.Service service, Function<String, Class<?>> ctrParamClassAccessor) {
        TypeResult<Class<?>> serviceClassResult = loader.findClass(service.getClassName());
        if (serviceClassResult.isPresent()) {
            SecurityServicesFeature.registerForReflection(serviceClassResult.get());
            Class<?> ctrParamClass = ctrParamClassAccessor.apply(service.getType());
            if (ctrParamClass != null) {
                SecurityServicesFeature.registerForReflection(ctrParamClass);
                SecurityServicesFeature.trace("Parameter class registered: %s", ctrParamClass);
            }
            if (SecurityServicesFeature.isSignature(service) || SecurityServicesFeature.isCipher(service) || SecurityServicesFeature.isKeyAgreement(service)) {
                for (String keyClassName : SecurityServicesFeature.getSupportedKeyClasses(service)) {
                    loader.findClass(keyClassName).ifPresent(SecurityServicesFeature::registerForReflection);
                }
            }
            if (SecurityServicesFeature.isKeyStore(service) && service.getAlgorithm().equals(JKS)) {
                SecurityServicesFeature.registerJks(loader);
            }
            if (SecurityServicesFeature.isCertificateFactory(service) && service.getAlgorithm().equals(X509)) {
                SecurityServicesFeature.registerX509Extensions();
            }
            SecurityServicesFeature.trace("Service registered: %s", service);
        } else {
            SecurityServicesFeature.trace("Service registration failed: %s. Cause: class not found %s", service, service.getClassName());
        }
    }

    private static void registerJks(ImageClassLoader loader) {
        Class<?> javaKeyStoreJks = loader.findClass("sun.security.provider.JavaKeyStore$JKS").getOrFail();
        SecurityServicesFeature.registerForReflection(javaKeyStoreJks);
        SecurityServicesFeature.trace("Class registered for reflection: %s", javaKeyStoreJks);
    }

    private static void registerX509Extensions() {
        Map map = (Map)ReflectionUtil.readStaticField(OIDMap.class, (String)"nameMap");
        for (String name : map.keySet()) {
            try {
                Class<?> extensionClass = OIDMap.getClass(name);
                assert (Extension.class.isAssignableFrom(extensionClass));
                SecurityServicesFeature.registerForReflection(extensionClass);
                SecurityServicesFeature.trace("Class registered for reflection: %s", extensionClass);
            }
            catch (CertificateException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    private static void registerForReflection(Class<?> clazz) {
        RuntimeReflection.register((Class[])new Class[]{clazz});
        RuntimeReflection.register((Executable[])clazz.getConstructors());
    }

    private static boolean isSignature(Provider.Service s) {
        return s.getType().equals(SIGNATURE_SERVICE);
    }

    private static boolean isCipher(Provider.Service s) {
        return s.getType().equals(CIPHER_SERVICE);
    }

    private static boolean isKeyAgreement(Provider.Service s) {
        return s.getType().equals(KEY_AGREEMENT_SERVICE);
    }

    private static boolean isKeyStore(Provider.Service s) {
        return s.getType().equals(KEY_STORE);
    }

    private static boolean isCertificateFactory(Provider.Service s) {
        return s.getType().equals(CERTIFICATE_FACTORY);
    }

    private static String[] getSupportedKeyClasses(Provider.Service s) {
        assert (SecurityServicesFeature.isSignature(s) || SecurityServicesFeature.isCipher(s) || SecurityServicesFeature.isKeyAgreement(s));
        String supportedKeyClasses = s.getAttribute("SupportedKeyClasses");
        if (supportedKeyClasses != null) {
            return supportedKeyClasses.split("\\|");
        }
        return emptyStringArray;
    }

    private static String asString(Provider.Service s) {
        String str = "Provider = " + s.getProvider().getName() + SEP;
        str = str + "Type = " + s.getType() + SEP;
        str = str + "Algorithm = " + s.getAlgorithm() + SEP;
        str = str + "Class = " + s.getClassName();
        if (SecurityServicesFeature.isSignature(s) || SecurityServicesFeature.isCipher(s) || SecurityServicesFeature.isKeyAgreement(s)) {
            str = str + ", SupportedKeyClasses = " + Arrays.toString(SecurityServicesFeature.getSupportedKeyClasses(s));
        }
        return str;
    }

    private static void trace(String msg, Object ... args) {
        if (Options.TraceSecurityServices.getValue().booleanValue()) {
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof Provider.Service)) continue;
                    args[i] = SecurityServicesFeature.asString((Provider.Service)args[i]);
                }
            }
            System.out.format(msg + "%n", args);
        }
    }

    static class Options {
        @Option(help={"Enable the feature that provides support for security services."})
        public static final HostedOptionKey<Boolean> EnableSecurityServicesFeature = new HostedOptionKey<Boolean>(true);
        @Option(help={"Enable trace logging for the security services feature."})
        static final HostedOptionKey<Boolean> TraceSecurityServices = new HostedOptionKey<Boolean>(false);

        Options() {
        }
    }
}

