/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedSnippets;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ExceptionSynthesizer;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.ConfigurableClassInitialization;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.classinitialization.TypeInitializerGraph;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.lang.reflect.Executable;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class ClassInitializationFeature
implements GraalFeature {
    private ClassInitializationSupport classInitializationSupport;
    private AnalysisUniverse universe;
    private AnalysisMetaAccess metaAccess;

    public static void processClassInitializationOptions(ClassInitializationSupport initializationSupport) {
        ClassInitializationFeature.initializeNativeImagePackagesAtBuildTime(initializationSupport);
        Options.ClassInitialization.getValue().getValuesWithOrigins().forEach(entry -> {
            for (String info : ((String)entry.getLeft()).split(",")) {
                boolean noMatches = Arrays.stream(InitKind.values()).noneMatch(v -> info.endsWith(v.suffix()));
                String origin = (String)entry.getRight();
                if (noMatches) {
                    throw UserError.abort("Element in class initialization configuration must end in %s, %s, or %s. Found: %s (from %s)", InitKind.RUN_TIME.suffix(), InitKind.RERUN.suffix(), InitKind.BUILD_TIME.suffix(), info, origin);
                }
                Pair<String, InitKind> elementType = InitKind.strip(info);
                ((InitKind)((Object)((Object)elementType.getRight()))).stringConsumer(initializationSupport, origin).accept((String)elementType.getLeft());
            }
        });
    }

    private static void initializeNativeImagePackagesAtBuildTime(ClassInitializationSupport initializationSupport) {
        initializationSupport.initializeAtBuildTime("com.oracle.svm", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("com.oracle.graal", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.collections", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.compiler", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.word", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.nativeimage", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.util", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.home", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.polyglot", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.options", "Native Image classes are always initialized at build time");
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.classInitializationSupport = access.getHostVM().getClassInitializationSupport();
        this.classInitializationSupport.setUnsupportedFeatures(access.getBigBang().getUnsupportedFeatures());
        access.registerObjectReplacer(this::checkImageHeapInstance);
        this.universe = ((FeatureImpl.DuringSetupAccessImpl)a).getBigBang().getUniverse();
        this.metaAccess = ((FeatureImpl.DuringSetupAccessImpl)a).getBigBang().getMetaAccess();
    }

    private Object checkImageHeapInstance(Object obj) {
        if (obj != null && this.classInitializationSupport.shouldInitializeAtRuntime(obj.getClass())) {
            String msg = "No instances of " + obj.getClass().getTypeName() + " are allowed in the image heap as this class should be initialized at image runtime.";
            msg = msg + this.classInitializationSupport.objectInstantiationTraceMessage(obj, " To fix the issue mark " + obj.getClass().getTypeName() + " for build-time initialization with " + SubstrateOptionsParser.commandArgument(Options.ClassInitialization, obj.getClass().getTypeName(), "initialize-at-build-time") + " or use the the information from the trace to find the culprit and " + SubstrateOptionsParser.commandArgument(Options.ClassInitialization, "<culprit>", "initialize-at-run-time") + " to prevent its instantiation.\n");
            throw new UnsupportedFeatureException(msg);
        }
        return obj;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : EnsureClassInitializedSnippets.FOREIGN_CALLS) {
            access.getBigBang().addRootMethod((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()));
        }
    }

    @Override
    public void registerForeignCalls(RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, SubstrateForeignCallsProvider foreignCalls, boolean hosted) {
        foreignCalls.register(providers, EnsureClassInitializedSnippets.FOREIGN_CALLS);
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        EnsureClassInitializedSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        this.classInitializationSupport.checkDelayedInitialization();
        for (AnalysisType type : access.getUniverse().getTypes()) {
            DynamicHub hub;
            if (!type.isReachable() || (hub = access.getHostVM().dynamicHub((ResolvedJavaType)type)).getClassInitializationInfo() != null) continue;
            this.buildClassInitializationInfo(access, type, hub);
            access.requireAnalysisIteration();
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        String imageName = ((FeatureImpl.AfterAnalysisAccessImpl)access).getBigBang().getHostVM().getImageName();
        try (Timer.StopTimer ignored = new Timer(imageName, "(clinit)").start();){
            this.classInitializationSupport.setUnsupportedFeatures(null);
            String path = Paths.get(Paths.get(SubstrateOptions.Path.getValue(), new String[0]).toString(), "reports").toAbsolutePath().toString();
            assert (this.classInitializationSupport.checkDelayedInitialization());
            TypeInitializerGraph initGraph = new TypeInitializerGraph(this.universe);
            initGraph.computeInitializerSafety();
            Set<AnalysisType> provenSafe = this.initializeSafeDelayedClasses(initGraph);
            if (Options.PrintClassInitialization.getValue().booleanValue()) {
                ClassInitializationFeature.reportSafeTypeInitiazliation(this.universe, initGraph, path, provenSafe);
                this.reportMethodInitializationInfo(path);
            }
            if (SubstrateOptions.TraceClassInitialization.hasBeenSet()) {
                ClassInitializationFeature.reportTrackedClassInitializationTraces(path);
            }
        }
    }

    private static void reportSafeTypeInitiazliation(AnalysisUniverse universe, TypeInitializerGraph initGraph, String path, Set<AnalysisType> provenSafe) {
        ReportUtils.report((String)"initializer dependencies", (String)path, (String)"initializer_dependencies", (String)"dot", writer -> {
            writer.println("digraph initializer_dependencies {");
            universe.getTypes().stream().filter(ClassInitializationFeature::isRelevantForPrinting).forEach(t -> writer.println(ClassInitializationFeature.quote(t.toClassName()) + "[fillcolor=" + (initGraph.isUnsafe((AnalysisType)t) ? "red" : "green") + "]"));
            universe.getTypes().stream().filter(ClassInitializationFeature::isRelevantForPrinting).forEach(t -> initGraph.getDependencies((AnalysisType)t).forEach(t1 -> writer.println(ClassInitializationFeature.quote(t.toClassName()) + " -> " + ClassInitializationFeature.quote(t1.toClassName()))));
            writer.println("}");
        });
        ReportUtils.report((String)(provenSafe.size() + " classes that are considered as safe for build-time initialization"), (String)path, (String)"safe_classes", (String)"txt", printWriter -> provenSafe.forEach(t -> printWriter.println(t.toClassName())));
    }

    private void reportMethodInitializationInfo(String path) {
        for (InitKind kind : InitKind.values()) {
            Set<Class<?>> classes = this.classInitializationSupport.classesWithKind(kind);
            ReportUtils.report((String)(classes.size() + " classes of type " + (Object)((Object)kind)), (String)path, (String)(kind.toString().toLowerCase() + "_classes"), (String)"txt", writer -> classes.stream().map(Class::getTypeName).sorted().forEach(writer::println));
        }
    }

    private static void reportTrackedClassInitializationTraces(String path) {
        Map<Class<?>, StackTraceElement[]> initializedClasses = ConfigurableClassInitialization.getInitializedClasses();
        int size = initializedClasses.size();
        if (size > 0) {
            ReportUtils.report((String)(size + " class initialization trace(s) of class(es) traced by " + SubstrateOptions.TraceClassInitialization.getName()), (String)path, (String)"traced_class_initialization", (String)"txt", writer -> initializedClasses.forEach((k, v) -> {
                writer.println(k.getName());
                writer.println("---------------------------------------------");
                writer.println(ConfigurableClassInitialization.getTraceString(v));
                writer.println();
            }));
        }
    }

    private static boolean isRelevantForPrinting(AnalysisType type) {
        return !type.isPrimitive() && !type.isArray() && type.isReachable();
    }

    private static String quote(String className) {
        return "\"" + className + "\"";
    }

    private Set<AnalysisType> initializeSafeDelayedClasses(TypeInitializerGraph initGraph) {
        HashSet<AnalysisType> provenSafe = new HashSet<AnalysisType>();
        this.classInitializationSupport.setConfigurationSealed(false);
        this.classInitializationSupport.classesWithKind(InitKind.RUN_TIME).stream().filter(t -> this.metaAccess.optionalLookupJavaType(t).isPresent()).filter(t -> this.metaAccess.lookupJavaType(t).isReachable()).filter(t -> this.classInitializationSupport.canBeProvenSafe((Class<?>)t)).forEach(c -> {
            AnalysisType type = this.metaAccess.lookupJavaType(c);
            if (!initGraph.isUnsafe(type)) {
                this.classInitializationSupport.forceInitializeHosted((Class<?>)c, "proven safe to initialize", true);
                if (!this.classInitializationSupport.shouldInitializeAtRuntime((Class<?>)c)) {
                    provenSafe.add(type);
                    ClassInitializationInfo initializationInfo = type.getClassInitializer() == null ? ClassInitializationInfo.NO_INITIALIZER_INFO_SINGLETON : ClassInitializationInfo.INITIALIZED_INFO_SINGLETON;
                    ((SVMHost)this.universe.hostVM()).dynamicHub((ResolvedJavaType)type).setClassInitializationInfo(initializationInfo);
                }
            }
        });
        return provenSafe;
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess a) {
        this.classInitializationSupport.checkDelayedInitialization();
    }

    private void buildClassInitializationInfo(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType type, DynamicHub hub) {
        ClassInitializationInfo info;
        if (this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)type)) {
            info = ClassInitializationFeature.buildRuntimeInitializationInfo(access, type);
        } else {
            assert (type.isInitialized());
            info = type.getClassInitializer() == null ? ClassInitializationInfo.NO_INITIALIZER_INFO_SINGLETON : ClassInitializationInfo.INITIALIZED_INFO_SINGLETON;
        }
        hub.setClassInitializationInfo(info, type.hasDefaultMethods(), type.declaresDefaultMethods());
    }

    private static ClassInitializationInfo buildRuntimeInitializationInfo(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType type) {
        assert (!type.isInitialized());
        try {
            type.link();
        }
        catch (VerifyError e) {
            AnalysisMethod throwVerifyError = access.getMetaAccess().lookupJavaMethod((Executable)ExceptionSynthesizer.throwExceptionMethod(VerifyError.class));
            access.registerAsCompiled(throwVerifyError);
            return new ClassInitializationInfo(MethodPointer.factory((ResolvedJavaMethod)throwVerifyError));
        }
        catch (Throwable t) {
            return ClassInitializationInfo.FAILED_INFO_SINGLETON;
        }
        assert (type.isLinked());
        AnalysisMethod classInitializer = type.getClassInitializer();
        if (classInitializer != null) {
            assert (classInitializer.getCode() != null);
            access.registerAsCompiled(classInitializer);
        }
        return new ClassInitializationInfo(MethodPointer.factory((ResolvedJavaMethod)classInitializer));
    }

    public static class Options {
        @APIOption.List(value={@APIOption(name={"initialize-at-run-time"}, valueTransformer={InitializationValueDelay.class}, defaultValue={""}, customHelp="A comma-separated list of packages and classes (and implicitly all of their subclasses) that must be initialized at runtime and not during image building. An empty string is currently not supported."), @APIOption(name={"initialize-at-build-time"}, valueTransformer={InitializationValueEager.class}, defaultValue={""}, customHelp="A comma-separated list of packages and classes (and implicitly all of their superclasses) that are initialized during image generation. An empty string designates all packages."), @APIOption(name={"delay-class-initialization-to-runtime"}, valueTransformer={InitializationValueDelay.class}, deprecated="Use --initialize-at-run-time.", defaultValue={""}, customHelp="A comma-separated list of classes (and implicitly all of their subclasses) that are initialized at runtime and not during image building"), @APIOption(name={"rerun-class-initialization-at-runtime"}, valueTransformer={InitializationValueRerun.class}, deprecated="Currently there is no replacement for this option. Try using --initialize-at-run-time or use the non-API option -H:ClassInitialization directly.", defaultValue={""}, customHelp="A comma-separated list of classes (and implicitly all of their subclasses) that are initialized both at runtime and during image building")})
        @Option(help={"A comma-separated list of classes appended with their initialization strategy (':build_time', ':rerun', or ':run_time')"}, type=OptionType.User)
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ClassInitialization = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        @Option(help={"Prints class initialization info for all classes detected by analysis."}, type=OptionType.Debug)
        public static final HostedOptionKey<Boolean> PrintClassInitialization = new HostedOptionKey<Boolean>(false);

        private static class InitializationValueEager
        extends InitializationValueTransformer {
            InitializationValueEager() {
                super(InitKind.BUILD_TIME.name().toLowerCase());
            }
        }

        private static class InitializationValueRerun
        extends InitializationValueTransformer {
            InitializationValueRerun() {
                super(InitKind.RERUN.name().toLowerCase());
            }
        }

        private static class InitializationValueDelay
        extends InitializationValueTransformer {
            InitializationValueDelay() {
                super(InitKind.RUN_TIME.name().toLowerCase());
            }
        }

        private static class InitializationValueTransformer
        implements Function<Object, Object> {
            private final String val;

            InitializationValueTransformer(String val) {
                this.val = val;
            }

            @Override
            public Object apply(Object o) {
                String[] elements = o.toString().split(",");
                if (elements.length == 0) {
                    return ":" + this.val;
                }
                CharSequence[] results = new String[elements.length];
                for (int i = 0; i < elements.length; ++i) {
                    results[i] = elements[i] + ":" + this.val;
                }
                return String.join((CharSequence)",", results);
            }
        }
    }
}

