/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni;

import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.jni.functions.JNIFunctionTables;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import org.graalvm.nativeimage.c.struct.SizeOf;

public class JNIThreadLocalEnvironment {
    static final FastThreadLocalBytes<JNIEnvironment> jniFunctions = (FastThreadLocalBytes)FastThreadLocalFactory.createBytes(() -> SizeOf.get(JNIEnvironment.class)).setMaxOffset(0);

    public static JNIEnvironment getAddress() {
        JNIEnvironment env = jniFunctions.getAddress();
        if (env.getFunctions().isNull()) {
            env.setFunctions(JNIFunctionTables.singleton().getGlobalFunctionTable());
        }
        return env;
    }
}

