/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.jni.access.JNIAccessibleClass;
import com.oracle.svm.jni.access.JNIAccessibleMember;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class JNIAccessibleField
extends JNIAccessibleMember {
    private static final UnsignedWord ID_STATIC_FLAG = WordFactory.unsigned((long)-1L).unsignedShiftRight(1).add(1);
    private static final UnsignedWord ID_OBJECT_FLAG = ID_STATIC_FLAG.unsignedShiftRight(1);
    private static final UnsignedWord ID_OFFSET_MASK = ID_OBJECT_FLAG.subtract(1);
    private final String name;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final UnsignedWord flags;
    private UnsignedWord id = (UnsignedWord)WordFactory.zero();

    public static WordBase getOffsetFromId(JNIFieldId id) {
        UnsignedWord result = ((UnsignedWord)id).and(ID_OFFSET_MASK);
        assert (result.notEqual(0));
        return result;
    }

    JNIAccessibleField(JNIAccessibleClass declaringClass, String name, JavaKind kind, int modifiers) {
        super(declaringClass);
        this.name = name;
        UnsignedWord bits = Modifier.isStatic(modifiers) ? ID_STATIC_FLAG : (UnsignedWord)WordFactory.zero();
        this.flags = bits = bits.or(kind.isObject() ? ID_OBJECT_FLAG : (UnsignedWord)WordFactory.zero());
    }

    public JNIFieldId getId() {
        return (JNIFieldId)this.id;
    }

    public boolean isStatic() {
        assert (!this.id.equal(0));
        return this.id.and(ID_STATIC_FLAG).notEqual(0);
    }

    void finishBeforeCompilation(FeatureImpl.CompilationAccessImpl access) {
        assert (this.id.equal(0)) : "JNI field ID has already been set";
        try {
            int offset;
            Field reflField = this.getDeclaringClass().getClassObject().getDeclaredField(this.name);
            HostedField field = access.getMetaAccess().lookupJavaField(reflField);
            if (HybridLayout.isHybridField(field)) {
                assert (!field.hasLocation());
                HybridLayout hybridLayout = new HybridLayout((HostedInstanceClass)field.getDeclaringClass(), (ObjectLayout)ImageSingletons.lookup(ObjectLayout.class));
                assert (field.equals(hybridLayout.getArrayField())) : "JNI access to hybrid bitset field is not implemented";
                offset = hybridLayout.getArrayBaseOffset();
            } else {
                assert (field.hasLocation());
                offset = field.getLocation();
            }
            assert (ID_OFFSET_MASK.and(offset).equal(offset)) : "Offset is too large to be encoded in the JNIAccessibleField ID";
            this.id = this.flags.or(offset);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        this.setHidingSubclasses(access.getMetaAccess(), sub -> this.anyMatchName(sub.getInstanceFields(false)) || this.anyMatchName(sub.getStaticFields()));
    }

    private boolean anyMatchName(ResolvedJavaField[] fields) {
        for (ResolvedJavaField field : fields) {
            if (!field.getName().equals(this.name)) continue;
            return true;
        }
        return false;
    }
}

