/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.IsolatedCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.IsolatedTruffleCallNode;
import com.oracle.svm.truffle.isolated.IsolatedTruffleSourceLanguagePosition;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class IsolatedTruffleInlining<T extends TruffleMetaAccessProvider>
extends IsolatedObjectProxy<T>
implements TruffleMetaAccessProvider {
    IsolatedTruffleInlining(ClientHandle<T> handle) {
        super(handle);
    }

    public TruffleCallNode findCallNode(JavaConstant callNodeConstant) {
        ClientHandle<?> callNodeConstantHandle = ((IsolatedObjectConstant)callNodeConstant).getHandle();
        ClientHandle<TruffleCallNode> callNodeHandle = IsolatedTruffleInlining.findCallNode0(IsolatedCompileContext.get().getClient(), this.handle, callNodeConstantHandle);
        return new IsolatedTruffleCallNode(callNodeHandle);
    }

    public TruffleSourceLanguagePosition getPosition(JavaConstant nodeConstant) {
        if (!(nodeConstant instanceof IsolatedObjectConstant)) {
            return null;
        }
        ClientHandle<?> nodeConstantHandle = ((IsolatedObjectConstant)nodeConstant).getHandle();
        CompilerHandle<TruffleSourceLanguagePosition> position = IsolatedTruffleInlining.getPosition0(IsolatedCompileContext.get().getClient(), this.handle, nodeConstantHandle);
        return IsolatedCompileContext.get().unhand(position);
    }

    public void addTargetToDequeue(CompilableTruffleAST target) {
        ClientHandle<SubstrateCompilableTruffleAST> targetHandle = ((IsolatedCompilableTruffleAST)target).getHandle();
        IsolatedTruffleInlining.addTargetToDequeue0(IsolatedCompileContext.get().getClient(), this.handle, targetHandle);
    }

    public void setCallCount(int count) {
        IsolatedTruffleInlining.setCallCount0(IsolatedCompileContext.get().getClient(), this.handle, count);
    }

    public void setInlinedCallCount(int count) {
        IsolatedTruffleInlining.setInlinedCallCount0(IsolatedCompileContext.get().getClient(), this.handle, count);
    }

    public int countInlinedCalls() {
        return IsolatedTruffleInlining.countInlinedCalls0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public void addInlinedTarget(CompilableTruffleAST target) {
        ClientHandle<SubstrateCompilableTruffleAST> targetHandle = ((IsolatedCompilableTruffleAST)target).getHandle();
        IsolatedTruffleInlining.addInlinedTarget0(IsolatedCompileContext.get().getClient(), this.handle, targetHandle);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<TruffleCallNode> findCallNode0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> inliningHandle, ClientHandle<?> callNodeConstantHandle) {
        TruffleMetaAccessProvider inlining = IsolatedCompileClient.get().unhand(inliningHandle);
        JavaConstant callNodeConstant = SubstrateObjectConstant.forObject(IsolatedCompileClient.get().unhand(callNodeConstantHandle));
        TruffleCallNode callNode = inlining.findCallNode(callNodeConstant);
        return IsolatedCompileClient.get().hand(callNode);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static CompilerHandle<TruffleSourceLanguagePosition> getPosition0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> inliningHandle, ClientHandle<?> callNodeConstantHandle) {
        JavaConstant callNodeConstant;
        TruffleMetaAccessProvider inlining = IsolatedCompileClient.get().unhand(inliningHandle);
        TruffleSourceLanguagePosition position = inlining.getPosition(callNodeConstant = SubstrateObjectConstant.forObject(IsolatedCompileClient.get().unhand(callNodeConstantHandle)));
        if (position == null) {
            return (CompilerHandle)IsolatedHandles.nullHandle();
        }
        return IsolatedTruffleInlining.createPositionInCompiler(IsolatedCompileClient.get().getCompiler(), IsolatedCompileClient.get().hand(position), position.getLineNumber(), position.getOffsetStart(), position.getOffsetEnd(), position.getNodeId());
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void addTargetToDequeue0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> providerHandle, ClientHandle<SubstrateCompilableTruffleAST> targetHandle) {
        IsolatedCompileClient isolatedCompileClient = IsolatedCompileClient.get();
        TruffleMetaAccessProvider truffleMetaAccessProvider = isolatedCompileClient.unhand(providerHandle);
        truffleMetaAccessProvider.addTargetToDequeue((CompilableTruffleAST)isolatedCompileClient.unhand(targetHandle));
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void addInlinedTarget0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> providerHandle, ClientHandle<SubstrateCompilableTruffleAST> targetHandle) {
        IsolatedCompileClient isolatedCompileClient = IsolatedCompileClient.get();
        TruffleMetaAccessProvider truffleMetaAccessProvider = isolatedCompileClient.unhand(providerHandle);
        truffleMetaAccessProvider.addInlinedTarget((CompilableTruffleAST)isolatedCompileClient.unhand(targetHandle));
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void setCallCount0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> handle, int count) {
        TruffleMetaAccessProvider truffleMetaAccessProvider = IsolatedCompileClient.get().unhand(handle);
        truffleMetaAccessProvider.setCallCount(count);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void setInlinedCallCount0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> handle, int count) {
        TruffleMetaAccessProvider truffleMetaAccessProvider = IsolatedCompileClient.get().unhand(handle);
        truffleMetaAccessProvider.setInlinedCallCount(count);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static int countInlinedCalls0(ClientIsolateThread client, ClientHandle<? extends TruffleMetaAccessProvider> handle) {
        TruffleMetaAccessProvider truffleMetaAccessProvider = IsolatedCompileClient.get().unhand(handle);
        return truffleMetaAccessProvider.countInlinedCalls();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static CompilerHandle<TruffleSourceLanguagePosition> createPositionInCompiler(CompilerIsolateThread compiler, ClientHandle<TruffleSourceLanguagePosition> positionHandle, int lineNumber, int offsetStart, int offsetEnd, int nodeId) {
        return IsolatedCompileContext.get().hand(new IsolatedTruffleSourceLanguagePosition(positionHandle, lineNumber, offsetStart, offsetEnd, nodeId));
    }
}

