/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.amd64;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.amd64.AMD64LibCHelper;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;

public class AMD64CPUFeatureAccess
implements CPUFeatureAccess {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static EnumSet<AMD64.Flag> allAMD64Flags() {
        return EnumSet.of(AMD64.Flag.UseCountLeadingZerosInstruction, AMD64.Flag.UseCountTrailingZerosInstruction);
    }

    private static boolean isFeaturePresent(String featureName, AMD64LibCHelper.CPUFeatures cpuFeatures) {
        switch (featureName) {
            case "CX8": {
                return cpuFeatures.fCX8();
            }
            case "CMOV": {
                return cpuFeatures.fCMOV();
            }
            case "FXSR": {
                return cpuFeatures.fFXSR();
            }
            case "HT": {
                return cpuFeatures.fHT();
            }
            case "MMX": {
                return cpuFeatures.fMMX();
            }
            case "AMD_3DNOW_PREFETCH": {
                return cpuFeatures.fAMD3DNOWPREFETCH();
            }
            case "SSE": {
                return cpuFeatures.fSSE();
            }
            case "SSE2": {
                return cpuFeatures.fSSE2();
            }
            case "SSE3": {
                return cpuFeatures.fSSE3();
            }
            case "SSSE3": {
                return cpuFeatures.fSSSE3();
            }
            case "SSE4A": {
                return cpuFeatures.fSSE4A();
            }
            case "SSE4_1": {
                return cpuFeatures.fSSE41();
            }
            case "SSE4_2": {
                return cpuFeatures.fSSE42();
            }
            case "POPCNT": {
                return cpuFeatures.fPOPCNT();
            }
            case "LZCNT": {
                return cpuFeatures.fLZCNT();
            }
            case "TSC": {
                return cpuFeatures.fTSC();
            }
            case "TSCINV": {
                return cpuFeatures.fTSCINV();
            }
            case "AVX": {
                return cpuFeatures.fAVX();
            }
            case "AVX2": {
                return cpuFeatures.fAVX2();
            }
            case "AES": {
                return cpuFeatures.fAES();
            }
            case "ERMS": {
                return cpuFeatures.fERMS();
            }
            case "CLMUL": {
                return cpuFeatures.fCLMUL();
            }
            case "BMI1": {
                return cpuFeatures.fBMI1();
            }
            case "BMI2": {
                return cpuFeatures.fBMI2();
            }
            case "RTM": {
                return cpuFeatures.fRTM();
            }
            case "ADX": {
                return cpuFeatures.fADX();
            }
            case "AVX512F": {
                return cpuFeatures.fAVX512F();
            }
            case "AVX512DQ": {
                return cpuFeatures.fAVX512DQ();
            }
            case "AVX512PF": {
                return cpuFeatures.fAVX512PF();
            }
            case "AVX512ER": {
                return cpuFeatures.fAVX512ER();
            }
            case "AVX512CD": {
                return cpuFeatures.fAVX512CD();
            }
            case "AVX512BW": {
                return cpuFeatures.fAVX512BW();
            }
            case "AVX512VL": {
                return cpuFeatures.fAVX512VL();
            }
            case "SHA": {
                return cpuFeatures.fSHA();
            }
            case "FMA": {
                return cpuFeatures.fFMA();
            }
        }
        throw VMError.shouldNotReachHere("Missing feature check: " + featureName);
    }

    @Platforms(value={Platform.AMD64.class})
    public static EnumSet<AMD64.CPUFeature> determineHostCPUFeatures() {
        EnumSet<AMD64.CPUFeature> features = EnumSet.noneOf(AMD64.CPUFeature.class);
        AMD64LibCHelper.CPUFeatures cpuFeatures = (AMD64LibCHelper.CPUFeatures)StackValue.get(AMD64LibCHelper.CPUFeatures.class);
        UnmanagedMemoryUtil.fill((Pointer)cpuFeatures, SizeOf.unsigned(AMD64LibCHelper.CPUFeatures.class), (byte)0);
        AMD64LibCHelper.determineCPUFeatures(cpuFeatures);
        for (AMD64.CPUFeature feature : AMD64.CPUFeature.values()) {
            if (!AMD64CPUFeatureAccess.isFeaturePresent(feature.name(), cpuFeatures)) continue;
            features.add(feature);
        }
        return features;
    }

    @Override
    public void verifyHostSupportsArchitecture(Architecture imageArchitecture) {
        AMD64 architecture = (AMD64)imageArchitecture;
        EnumSet<AMD64.CPUFeature> features = AMD64CPUFeatureAccess.determineHostCPUFeatures();
        if (!features.containsAll(architecture.getFeatures())) {
            ArrayList<AMD64.CPUFeature> missingFeatures = new ArrayList<AMD64.CPUFeature>();
            for (AMD64.CPUFeature feature : architecture.getFeatures()) {
                if (features.contains(feature)) continue;
                missingFeatures.add(feature);
            }
            throw VMError.shouldNotReachHere("Current target does not support the following CPU features that are required by the image: " + missingFeatures);
        }
    }

    @Override
    public void enableFeatures(Architecture runtimeArchitecture) {
        if (CalleeSavedRegisters.supportedByPlatform()) {
            return;
        }
        AMD64 architecture = (AMD64)runtimeArchitecture;
        EnumSet<AMD64.CPUFeature> features = AMD64CPUFeatureAccess.determineHostCPUFeatures();
        architecture.getFeatures().addAll(features);
    }
}

