/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.classinitialization;

import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_16, cycles=NodeCycles.CYCLES_2, cyclesRationale="Class initialization only runs at most once at run time, so the amortized cost is only the is-initialized check")
@Node.NodeIntrinsicFactory
public class EnsureClassInitializedNode
extends WithExceptionNode
implements Simplifiable,
StateSplit,
SingleMemoryKill,
Lowerable {
    public static final NodeClass<EnsureClassInitializedNode> TYPE = NodeClass.create(EnsureClassInitializedNode.class);
    @Node.Input
    private ValueNode hub;
    @Node.Input(value=InputType.State)
    private FrameState stateAfter;

    public static boolean intrinsify(GraphBuilderContext b, ValueNode hub) {
        b.add((ValueNode)new EnsureClassInitializedNode(b.nullCheckedValue(hub)));
        return true;
    }

    public EnsureClassInitializedNode(ValueNode hub, FrameState stateAfter) {
        super(TYPE, StampFactory.forVoid());
        this.hub = hub;
        assert (StampTool.isPointerNonNull((ValueNode)hub)) : "Hub must already be null-checked";
        this.stateAfter = stateAfter;
    }

    public EnsureClassInitializedNode(ValueNode hub) {
        this(hub, null);
    }

    public ValueNode getHub() {
        return this.hub;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public FrameState stateAfter() {
        return this.stateAfter;
    }

    public void setStateAfter(FrameState stateAfter) {
        this.updateUsages((Node)this.stateAfter, (Node)stateAfter);
        this.stateAfter = stateAfter;
    }

    public boolean hasSideEffect() {
        return true;
    }

    public void simplify(SimplifierTool tool) {
        ResolvedJavaType type;
        if (this.hub.isConstant() && (type = tool.getConstantReflection().asJavaType(this.hub.asConstant())) != null && type.isInitialized()) {
            this.killExceptionEdge();
            this.graph().removeSplit((ControlSplitNode)this, this.next());
            return;
        }
    }

    @Node.NodeIntrinsic
    public static native void ensureClassInitialized(Class<?> var0);
}

