/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.Generation;
import com.oracle.svm.core.genscavenge.GreyObjectsWalker;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.log.Log;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

public final class OldGeneration
extends Generation {
    private final Space fromSpace;
    private final Space toSpace;
    private final GreyObjectsWalker toGreyObjectsWalker = new GreyObjectsWalker();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    OldGeneration(String name) {
        super(name);
        int age = HeapPolicy.getMaxSurvivorSpaces() + 1;
        this.fromSpace = new Space("oldFromSpace", true, age);
        this.toSpace = new Space("oldToSpace", false, age);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void tearDown() {
        this.fromSpace.tearDown();
        this.toSpace.tearDown();
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        return this.getFromSpace().walkObjects(visitor) && this.getToSpace().walkObjects(visitor);
    }

    @Override
    @AlwaysInline(value="GC performance")
    public Object promoteObject(Object original, UnsignedWord header) {
        if (ObjectHeaderImpl.isAlignedHeader(header)) {
            AlignedHeapChunk.AlignedHeader chunk = AlignedHeapChunk.getEnclosingChunk(original);
            Space originalSpace = HeapChunk.getSpace(chunk);
            if (originalSpace.isFromSpace()) {
                return this.promoteAlignedObject(original, originalSpace);
            }
        } else {
            assert (ObjectHeaderImpl.isUnalignedHeader(header));
            UnalignedHeapChunk.UnalignedHeader chunk = UnalignedHeapChunk.getEnclosingChunk(original);
            Space originalSpace = HeapChunk.getSpace(chunk);
            if (originalSpace.isFromSpace()) {
                this.promoteUnalignedChunk(chunk, originalSpace);
            }
        }
        return original;
    }

    @AlwaysInline(value="GC performance")
    public Object promoteAlignedObject(Object original, Space originalSpace) {
        return this.getToSpace().promoteAlignedObject(original, originalSpace);
    }

    @AlwaysInline(value="GC performance")
    public void promoteUnalignedChunk(UnalignedHeapChunk.UnalignedHeader chunk, Space originalSpace) {
        this.getToSpace().promoteUnalignedHeapChunk(chunk, originalSpace);
    }

    public void promoteObjectChunk(Object obj) {
        this.getToSpace().promoteObjectChunk(obj);
    }

    void releaseSpaces(GCImpl.ChunkReleaser chunkReleaser) {
        this.getFromSpace().releaseChunks(chunkReleaser);
    }

    void prepareForPromotion() {
        this.toGreyObjectsWalker.setScanStart(this.getToSpace());
    }

    boolean scanGreyObjects() {
        if (!this.toGreyObjectsWalker.haveGreyObjects()) {
            return false;
        }
        this.toGreyObjectsWalker.walkGreyObjects();
        return true;
    }

    @Override
    public Log report(Log log, boolean traceHeapChunks) {
        log.string("[Old generation: ").indent(true);
        this.getFromSpace().report(log, traceHeapChunks).newline();
        this.getToSpace().report(log, traceHeapChunks).newline();
        log.redent(false).string("]");
        return log;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Space getFromSpace() {
        return this.fromSpace;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Space getToSpace() {
        return this.toSpace;
    }

    void swapSpaces() {
        assert (this.getFromSpace().isEmpty()) : "fromSpace should be empty.";
        this.getFromSpace().absorb(this.getToSpace());
    }

    void emptyFromSpaceIntoToSpace() {
        this.getToSpace().absorb(this.getFromSpace());
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        return this.getFromSpace().walkHeapChunks(visitor) && this.getToSpace().walkHeapChunks(visitor);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getChunkBytes() {
        UnsignedWord fromBytes = this.getFromSpace().getChunkBytes();
        UnsignedWord toBytes = this.getToSpace().getChunkBytes();
        return fromBytes.add(toBytes);
    }
}

