/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.graal.jdk.SubstrateArraycopyNode;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeInterface;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.KillingBeginNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopy;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="may be replaced with non-throwing counterpart", size=NodeSize.SIZE_64)
public class ArrayCopyWithExceptionNode
extends WithExceptionNode
implements ArrayCopy {
    public static final NodeClass<ArrayCopyWithExceptionNode> TYPE = NodeClass.create(ArrayCopyWithExceptionNode.class);
    @Node.Input
    NodeInputList<ValueNode> args;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateDuring;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;
    @Node.OptionalInput(value=InputType.Memory)
    protected MemoryKill lastLocationAccess;
    protected JavaKind elementKind;
    protected int bci;

    public ArrayCopyWithExceptionNode(ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind, int bci) {
        super(TYPE, StampFactory.forVoid());
        this.bci = bci;
        this.args = new NodeInputList((Node)this, (Node[])new ValueNode[]{src, srcPos, dest, destPos, length});
        Object object = this.elementKind = elementKind != JavaKind.Illegal ? elementKind : null;
        if (this.elementKind == null) {
            this.elementKind = ArrayCopy.selectComponentKind((ArrayCopy)this);
        }
    }

    public NodeInputList<ValueNode> args() {
        return this.args;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return this.getLocationIdentity();
    }

    public LocationIdentity getLocationIdentity() {
        if (this.elementKind != null) {
            return NamedLocationIdentity.getArrayLocation((JavaKind)this.elementKind);
        }
        return LocationIdentity.any();
    }

    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsagesInterface((NodeInterface)this.lastLocationAccess, (NodeInterface)lla);
        this.lastLocationAccess = lla;
    }

    public FrameState stateDuring() {
        return this.stateDuring;
    }

    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages((Node)this.stateDuring, (Node)stateDuring);
        this.stateDuring = stateDuring;
    }

    public FrameState stateAfter() {
        return this.stateAfter;
    }

    public void setStateAfter(FrameState stateAfter) {
        this.updateUsages((Node)this.stateAfter, (Node)stateAfter);
        this.stateAfter = stateAfter;
    }

    public int getBci() {
        return this.bci;
    }

    public JavaKind getElementKind() {
        return this.elementKind;
    }

    public FixedNode replaceWithNonThrowing() {
        SubstrateArraycopyNode plainArrayCopy = (SubstrateArraycopyNode)this.asNode().graph().add((Node)new SubstrateArraycopyNode(this.getSource(), this.getSourcePosition(), this.getDestination(), this.getDestinationPosition(), this.getLength(), this.getElementKind(), this.getBci()));
        plainArrayCopy.setStateAfter(this.stateAfter);
        AbstractBeginNode nextBegin = this.next;
        AbstractBeginNode oldException = this.exceptionEdge;
        this.graph().replaceSplitWithFixed((ControlSplitNode)this, (FixedWithNextNode)plainArrayCopy, this.next());
        GraphUtil.killCFG((FixedNode)oldException);
        if (nextBegin instanceof KillingBeginNode && ((KillingBeginNode)nextBegin).getKilledLocationIdentity().equals(plainArrayCopy.getKilledLocationIdentity())) {
            plainArrayCopy.graph().removeFixed((FixedWithNextNode)nextBegin);
        }
        return plainArrayCopy;
    }
}

