/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_8, cycles=NodeCycles.CYCLES_8, allowedUsageTypes={InputType.Memory})
public final class VaListNextArgNode
extends FixedWithNextNode
implements Lowerable,
SingleMemoryKill {
    public static final NodeClass<VaListNextArgNode> TYPE = NodeClass.create(VaListNextArgNode.class);
    @Node.Input
    protected ValueNode vaList;

    public VaListNextArgNode(JavaKind kind, ValueNode vaList) {
        super(TYPE, StampFactory.forKind((JavaKind)kind));
        assert (kind.isPrimitive() && kind != JavaKind.Void);
        this.vaList = vaList;
    }

    public ValueNode getVaList() {
        return this.vaList;
    }

    public void lower(LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
            tool.getLowerer().lower((Node)this, tool);
        }
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }
}

