/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.replacements;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.StateSplitProxyNode;
import org.graalvm.compiler.nodes.extended.UnboxNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.GraphKit;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.WordBase;

public class SubstrateGraphKit
extends GraphKit {
    private final FrameStateBuilder frameState;
    private int nextBCI;

    public SubstrateGraphKit(DebugContext debug, ResolvedJavaMethod stubMethod, Providers providers, WordTypes wordTypes, GraphBuilderConfiguration.Plugins graphBuilderPlugins, CompilationIdentifier compilationId) {
        super(debug, stubMethod, providers, wordTypes, graphBuilderPlugins, compilationId, null, SubstrateOptions.parseOnce());
        assert (wordTypes != null) : "Support for Word types is mandatory";
        this.frameState = new FrameStateBuilder((GraphBuilderTool)this, stubMethod, this.graph);
        this.frameState.disableKindVerification();
        this.frameState.initializeForMethodStart(null, true, graphBuilderPlugins);
        this.graph.start().setStateAfter(this.frameState.create(this.bci(), (StateSplit)this.graph.start()));
    }

    protected MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, int bci) {
        return new SubstrateMethodCallTargetNode(invokeKind, targetMethod, args, returnStamp, null, null);
    }

    public SubstrateLoweringProvider getLoweringProvider() {
        return (SubstrateLoweringProvider)this.getLowerer();
    }

    public FrameStateBuilder getFrameState() {
        return this.frameState;
    }

    public ValueNode loadLocal(int index, JavaKind slotKind) {
        return this.frameState.loadLocal(index, slotKind);
    }

    public void storeLocal(int index, JavaKind slotKind, ValueNode value) {
        this.frameState.storeLocal(index, slotKind, value);
    }

    public List<ValueNode> loadArguments(JavaType[] paramTypes) {
        ArrayList<ValueNode> arguments = new ArrayList<ValueNode>();
        int numOfParams = paramTypes.length;
        int javaIndex = 0;
        for (int i = 0; i < numOfParams; ++i) {
            JavaType type = paramTypes[i];
            JavaKind kind = type.getJavaKind();
            assert (this.frameState.loadLocal(javaIndex, kind) != null);
            arguments.add(this.frameState.loadLocal(javaIndex, kind));
            javaIndex += kind.getSlotCount();
        }
        return arguments;
    }

    public LoadFieldNode createLoadField(ValueNode object, ResolvedJavaField field) {
        return (LoadFieldNode)this.append((ValueNode)LoadFieldNode.create(null, (ValueNode)object, (ResolvedJavaField)field));
    }

    public ValueNode createLoadIndexed(ValueNode array, int index, JavaKind kind) {
        ValueNode loadIndexed = LoadIndexedNode.create(null, (ValueNode)array, (ValueNode)ConstantNode.forInt((int)index, (StructuredGraph)this.getGraph()), null, (JavaKind)kind, (MetaAccessProvider)this.getMetaAccess(), (ConstantReflectionProvider)this.getConstantReflection());
        if (loadIndexed instanceof FixedNode) {
            return this.append((ValueNode)((FixedNode)loadIndexed));
        }
        return this.unique((FloatingNode)loadIndexed);
    }

    public ValueNode createStoreIndexed(ValueNode array, int index, JavaKind kind, ValueNode value) {
        return this.append((ValueNode)new StoreIndexedNode(array, (ValueNode)ConstantNode.forInt((int)index, (StructuredGraph)this.getGraph()), null, null, kind, value));
    }

    public ValueNode createUnboxing(ValueNode boxed, JavaKind targetKind, MetaAccessProvider metaAccess) {
        return this.append((ValueNode)new UnboxNode(boxed, targetKind, metaAccess));
    }

    public ValueNode createInvokeWithExceptionAndUnwind(Class<?> declaringClass, String name, CallTargetNode.InvokeKind invokeKind, ValueNode ... args) {
        return this.createInvokeWithExceptionAndUnwind(this.findMethod(declaringClass, name, invokeKind == CallTargetNode.InvokeKind.Static), invokeKind, this.frameState, this.bci(), args);
    }

    public InvokeWithExceptionNode createJavaCallWithException(CallTargetNode.InvokeKind kind, ResolvedJavaMethod targetMethod, ValueNode ... arguments) {
        return this.startInvokeWithException(targetMethod, kind, this.frameState, this.bci(), arguments);
    }

    public ValueNode createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind kind, ResolvedJavaMethod targetMethod, ValueNode ... arguments) {
        return this.createInvokeWithExceptionAndUnwind(targetMethod, kind, this.frameState, this.bci(), arguments);
    }

    public ConstantNode createConstant(Constant value, JavaKind kind) {
        return ConstantNode.forConstant((Stamp)StampFactory.forKind((JavaKind)kind), (Constant)value, (MetaAccessProvider)this.getMetaAccess(), (StructuredGraph)this.getGraph());
    }

    public ValueNode createCFunctionCall(ValueNode targetAddress, List<ValueNode> arguments, Signature signature, int newThreadStatus, boolean emitDeoptTarget) {
        boolean emitTransition = VMThreads.StatusSupport.isValidStatus(newThreadStatus);
        if (emitTransition) {
            this.append((ValueNode)new CFunctionPrologueNode(newThreadStatus));
        }
        JavaKind javaReturnKind = signature.getReturnKind();
        JavaKind cReturnKind = javaReturnKind.getStackKind();
        JavaType returnType = signature.getReturnType(null);
        Stamp returnStamp = this.returnStamp(returnType, cReturnKind);
        InvokeNode invoke = this.createIndirectCall(targetAddress, arguments, signature.toParameterTypes(null), returnStamp, cReturnKind, SubstrateCallingConventionType.NativeCall);
        assert (!emitDeoptTarget || !emitTransition) : "cannot have transition for deoptimization targets";
        if (emitTransition) {
            CFunctionEpilogueNode epilogue = new CFunctionEpilogueNode(newThreadStatus);
            this.append((ValueNode)epilogue);
            epilogue.setStateAfter(invoke.stateAfter().duplicateWithVirtualState());
        } else if (emitDeoptTarget) {
            int bci = invoke.stateAfter().bci;
            this.appendWithUnwind(new DeoptEntryNode(), bci);
        }
        InvokeNode result = invoke;
        if (javaReturnKind != cReturnKind) {
            assert (javaReturnKind.getByteCount() < cReturnKind.getByteCount());
            result = this.append((ValueNode)new NarrowNode((ValueNode)result, javaReturnKind.getByteCount() << 3));
        }
        return this.getLoweringProvider().implicitLoadConvertWithBooleanCoercionIfNecessary(this.getGraph(), this.asKind(returnType), (ValueNode)result);
    }

    public InvokeNode createIndirectCall(ValueNode targetAddress, List<ValueNode> arguments, Signature signature, CallingConvention.Type callType) {
        assert (arguments.size() == signature.getParameterCount(false));
        assert (callType != SubstrateCallingConventionType.NativeCall) : "return kind and stamp would be incorrect";
        JavaKind returnKind = signature.getReturnKind();
        Stamp returnStamp = this.returnStamp(signature.getReturnType(null), returnKind);
        return this.createIndirectCall(targetAddress, arguments, signature.toParameterTypes(null), returnStamp, returnKind, callType);
    }

    private InvokeNode createIndirectCall(ValueNode targetAddress, List<ValueNode> arguments, JavaType[] parameterTypes, Stamp returnStamp, JavaKind returnKind, CallingConvention.Type callType) {
        this.frameState.clearStack();
        int bci = this.bci();
        CallTargetNode callTarget = (CallTargetNode)this.getGraph().add((Node)new IndirectCallTargetNode(targetAddress, arguments.toArray(new ValueNode[arguments.size()]), StampPair.createSingle((Stamp)returnStamp), parameterTypes, null, callType, CallTargetNode.InvokeKind.Static));
        InvokeNode invoke = (InvokeNode)this.append((ValueNode)new InvokeNode(callTarget, bci));
        this.frameState.pushReturn(returnKind, (ValueNode)invoke);
        FrameState stateAfter = this.frameState.create(bci, (StateSplit)invoke);
        invoke.setStateAfter(stateAfter);
        return invoke;
    }

    private Stamp returnStamp(JavaType returnType, JavaKind returnKind) {
        if (returnKind == JavaKind.Object && returnType instanceof ResolvedJavaType) {
            return StampFactory.object((TypeReference)TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)((ResolvedJavaType)returnType)));
        }
        return this.getLoweringProvider().loadStamp(StampFactory.forKind((JavaKind)returnKind), returnKind);
    }

    public ConstantNode createLong(long value) {
        return ConstantNode.forLong((long)value, (StructuredGraph)this.getGraph());
    }

    public ConstantNode createInt(int value) {
        return ConstantNode.forInt((int)value, (StructuredGraph)this.getGraph());
    }

    public ConstantNode createObject(Object value) {
        return ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(value), (MetaAccessProvider)this.getMetaAccess(), (StructuredGraph)this.graph);
    }

    public ValueNode createBoxing(ValueNode value, JavaKind kind, ResolvedJavaType targetType) {
        return this.append((ValueNode)BoxNode.create((ValueNode)value, (ResolvedJavaType)targetType, (JavaKind)kind));
    }

    public ValueNode createReturn(ValueNode retValue, JavaKind returnKind) {
        if (returnKind == JavaKind.Void) {
            return this.append((ValueNode)new ReturnNode(null));
        }
        return this.append((ValueNode)new ReturnNode(retValue));
    }

    public PiNode createPiNode(ValueNode value, Stamp stamp) {
        return (PiNode)this.append((ValueNode)new PiNode(value, stamp, (ValueNode)AbstractBeginNode.prevBegin((FixedNode)this.lastFixedNode)));
    }

    public int bci() {
        return this.nextBCI++;
    }

    public static boolean isWord(Class<?> klass) {
        return WordBase.class.isAssignableFrom(klass);
    }

    public StructuredGraph finalizeGraph() {
        if (this.lastFixedNode != null) {
            throw VMError.shouldNotReachHere("Manually constructed graph does not terminate control flow properly. lastFixedNode: " + this.lastFixedNode);
        }
        this.mergeUnwinds();
        assert (this.graph.verify());
        assert (this.wordTypes.ensureGraphContainsNoWordTypeReferences(this.graph));
        return this.graph;
    }

    private void mergeUnwinds() {
        ArrayList<UnwindNode> unwinds = new ArrayList<UnwindNode>();
        for (Node node : this.getGraph().getNodes()) {
            if (!(node instanceof UnwindNode)) continue;
            unwinds.add((UnwindNode)node);
        }
        if (unwinds.size() > 1) {
            MergeNode unwindMergeNode = (MergeNode)this.add((ValueNode)new MergeNode());
            ValueNode exceptionValue = InliningUtil.mergeUnwindExceptions((AbstractMergeNode)unwindMergeNode, unwinds);
            UnwindNode unwindReplacement = (UnwindNode)this.add((ValueNode)new UnwindNode(exceptionValue));
            unwindMergeNode.setNext((FixedNode)unwindReplacement);
            FrameStateBuilder exceptionState = this.getFrameState().copy();
            exceptionState.clearStack();
            exceptionState.push(JavaKind.Object, exceptionValue);
            exceptionState.setRethrowException(true);
            unwindMergeNode.setStateAfter(exceptionState.create(-4, (StateSplit)unwindMergeNode));
        }
    }

    protected <T extends WithExceptionNode> T appendWithUnwind(T withExceptionNode, int bci) {
        WithExceptionNode appended = (WithExceptionNode)this.append((ValueNode)withExceptionNode);
        assert (appended == withExceptionNode);
        if (withExceptionNode instanceof StateSplit) {
            StateSplit stateSplit = (StateSplit)withExceptionNode;
            stateSplit.setStateAfter(this.frameState.create(bci, stateSplit));
        }
        AbstractBeginNode noExceptionEdge = (AbstractBeginNode)this.add((ValueNode)withExceptionNode.createNextBegin());
        withExceptionNode.setNext(noExceptionEdge);
        ExceptionObjectNode exceptionEdge = this.createExceptionObjectNode(this.frameState, bci);
        withExceptionNode.setExceptionEdge((AbstractBeginNode)exceptionEdge);
        assert (this.lastFixedNode == null);
        this.lastFixedNode = exceptionEdge;
        this.append((ValueNode)new UnwindNode((ValueNode)exceptionEdge));
        assert (this.lastFixedNode == null);
        this.lastFixedNode = noExceptionEdge;
        return withExceptionNode;
    }

    public void appendStateSplitProxy(FrameState state) {
        StateSplitProxyNode proxy = new StateSplitProxyNode(null);
        this.append((ValueNode)proxy);
        proxy.setStateAfter(state);
    }

    public void appendStateSplitProxy(FrameStateBuilder stateBuilder) {
        StateSplitProxyNode proxy = new StateSplitProxyNode(null);
        this.append((ValueNode)proxy);
        proxy.setStateAfter(stateBuilder.create(this.bci(), (StateSplit)proxy));
    }
}

