/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class StackOverflowCheckImpl
implements StackOverflowCheck {
    static final FastThreadLocalWord<UnsignedWord> stackBoundaryTL = (FastThreadLocalWord)FastThreadLocalFactory.createWord().setMaxOffset(63);
    static final FastThreadLocalInt yellowZoneStateTL = FastThreadLocalFactory.createInt();
    static final int STATE_UNINITIALIZED = 0;
    static final int STATE_YELLOW_ENABLED = 1;

    StackOverflowCheckImpl() {
    }

    @Fold
    static boolean supportedByOS() {
        return ImageSingletons.contains(StackOverflowCheck.OSSupport.class);
    }

    @Override
    @Uninterruptible(reason="Called while thread is being attached to the VM, i.e., when the thread state is not yet set up.")
    public void initialize(IsolateThread thread) {
        if (!StackOverflowCheckImpl.supportedByOS()) {
            return;
        }
        UnsignedWord stackEnd = ((StackOverflowCheck.OSSupport)ImageSingletons.lookup(StackOverflowCheck.OSSupport.class)).lookupStackEnd();
        stackBoundaryTL.set(thread, stackEnd.add(StackOverflowCheck.Options.StackYellowZoneSize.getValue() + StackOverflowCheck.Options.StackRedZoneSize.getValue()));
        yellowZoneStateTL.set(thread, 1);
    }

    @Override
    @Uninterruptible(reason="Atomically manipulating state of multiple thread local variables.")
    public void makeYellowZoneAvailable() {
        ThreadingSupportImpl.pauseRecurringCallback("Recurring callbacks are considered user code and must not run in yellow zone");
        if (!StackOverflowCheckImpl.supportedByOS()) {
            return;
        }
        int state = yellowZoneStateTL.get();
        VMError.guarantee(state >= 1, "StackOverflowSupport.disableYellowZone: Illegal state");
        if (state == 1) {
            stackBoundaryTL.set(stackBoundaryTL.get().subtract(StackOverflowCheck.Options.StackYellowZoneSize.getValue().intValue()));
        }
        yellowZoneStateTL.set(state + 1);
        UnsignedWord stackBoundary = stackBoundaryTL.get();
        if (KnownIntrinsics.readStackPointer().belowOrEqual(stackBoundary)) {
            throw VMError.shouldNotReachHere("StackOverflowError: Enabling the yellow zone of the stack did not make any stack space available. Possible reasons for that: 1) A call from native code to Java code provided the wrong JNI environment or the wrong IsolateThread; 2) Frames of native code filled the stack, and now there is not even enough stack space left to throw a regular StackOverflowError; 3) An internal VM error occurred.");
        }
    }

    @Override
    public boolean isYellowZoneAvailable() {
        return yellowZoneStateTL.get() > 1;
    }

    @Override
    @Uninterruptible(reason="Atomically manipulating state of multiple thread local variables.")
    public void protectYellowZone() {
        ThreadingSupportImpl.resumeRecurringCallbackAtNextSafepoint();
        if (!StackOverflowCheckImpl.supportedByOS()) {
            return;
        }
        int state = yellowZoneStateTL.get();
        VMError.guarantee(state > 1, "StackOverflowSupport.enableYellowZone: Illegal state");
        int newState = state - 1;
        yellowZoneStateTL.set(newState);
        if (newState == 1) {
            stackBoundaryTL.set(stackBoundaryTL.get().add(StackOverflowCheck.Options.StackYellowZoneSize.getValue().intValue()));
        }
    }

    @Override
    public int yellowAndRedZoneSize() {
        if (!StackOverflowCheckImpl.supportedByOS()) {
            return 0;
        }
        return StackOverflowCheck.Options.StackYellowZoneSize.getValue() + StackOverflowCheck.Options.StackRedZoneSize.getValue();
    }

    @Override
    @Uninterruptible(reason="Called by fatal error handling that is uninterruptible.")
    public void disableStackOverflowChecksForFatalError() {
        stackBoundaryTL.set(WordFactory.unsigned((int)1));
        yellowZoneStateTL.set(-16843010);
    }
}

