/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class PredefinedClassesSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Set<Class<?>> predefinedClasses = new HashSet();
    private final ReentrantLock lock = new ReentrantLock();
    private final EconomicMap<String, Class<?>> predefinedClassesByHash = ImageHeapMap.create();
    private final EconomicMap<String, Class<?>> loadedClassesByName = EconomicMap.create();

    @Fold
    static PredefinedClassesSupport singleton() {
        return (PredefinedClassesSupport)ImageSingletons.lookup(PredefinedClassesSupport.class);
    }

    public static String hash(byte[] classData, int offset, int length) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(classData, offset, length);
            return SubstrateUtil.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(String hash, Class<?> clazz) {
        Class existing = (Class)PredefinedClassesSupport.singleton().predefinedClassesByHash.putIfAbsent((Object)hash, clazz);
        if (existing != clazz) {
            VMError.guarantee(existing == null, "Can define only one class per hash");
            PredefinedClassesSupport.singleton().predefinedClasses.add(clazz);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean isPredefined(Class<?> clazz) {
        return PredefinedClassesSupport.singleton().predefinedClasses.contains(clazz);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String expectedName, byte[] data, int offset, int length, ProtectionDomain protectionDomain) {
        String hash = PredefinedClassesSupport.hash(data, offset, length);
        Class clazz = (Class)PredefinedClassesSupport.singleton().predefinedClassesByHash.get((Object)hash);
        if (clazz == null) {
            String name = expectedName != null ? expectedName : "(name not specified)";
            throw VMError.unsupportedFeature("Defining a class from new bytecodes at run time is not supported. Class " + name + " with hash " + hash + " was not provided during the image build. Please see BuildConfiguration.md.");
        }
        return PredefinedClassesSupport.singleton().load(classLoader, protectionDomain, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> load(ClassLoader classLoader, ProtectionDomain protectionDomain, Class<?> clazz) {
        this.lock.lock();
        try {
            boolean alreadyLoaded;
            boolean bl = alreadyLoaded = this.loadedClassesByName.get((Object)clazz.getName()) == clazz;
            if (alreadyLoaded) {
                if (classLoader == clazz.getClassLoader()) {
                    throw new LinkageError("loader " + classLoader + " attempted duplicate class definition for " + clazz.getName() + " defined by " + clazz.getClassLoader());
                }
                throw VMError.unsupportedFeature("A predefined class can be loaded (defined) at runtime only once by a single class loader. Hierarchies of class loaders and distinct sets of classes are not supported. Class " + clazz.getName() + " has already been loaded by class loader: " + clazz.getClassLoader());
            }
            PredefinedClassesSupport.throwIfUnresolvable(clazz.getSuperclass(), classLoader);
            for (Class<?> intf : clazz.getInterfaces()) {
                PredefinedClassesSupport.throwIfUnresolvable(intf, classLoader);
            }
            DynamicHub hub = DynamicHub.fromClass(clazz);
            hub.setClassLoaderAtRuntime(classLoader);
            if (protectionDomain != null) {
                hub.setProtectionDomainAtRuntime(protectionDomain);
            }
            this.loadedClassesByName.put((Object)clazz.getName(), clazz);
            Class<?> clazz2 = clazz;
            return clazz2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void throwIfUnresolvable(Class<?> clazz, ClassLoader classLoader) {
        if (clazz == null) {
            return;
        }
        DynamicHub hub = DynamicHub.fromClass(clazz);
        if (!hub.isLoaded()) {
            PredefinedClassesSupport.throwResolutionError(clazz.getName());
        }
        if (!PredefinedClassesSupport.isSameOrParent(clazz.getClassLoader(), classLoader)) {
            PredefinedClassesSupport.throwResolutionError(clazz.getName());
        }
    }

    private static void throwResolutionError(String name) {
        NoClassDefFoundError error = new NoClassDefFoundError(name.replace('.', '/'));
        error.initCause(new ClassNotFoundException(name));
        throw error;
    }

    static Class<?> getLoadedForNameOrNull(String name, ClassLoader classLoader) {
        Class<?> clazz = PredefinedClassesSupport.singleton().getLoaded(name);
        if (clazz == null || !PredefinedClassesSupport.isSameOrParent(clazz.getClassLoader(), classLoader)) {
            return null;
        }
        return clazz;
    }

    private Class<?> getLoaded(String name) {
        this.lock.lock();
        try {
            Class clazz = (Class)this.loadedClassesByName.get((Object)name);
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static boolean isSameOrParent(ClassLoader parent, ClassLoader child) {
        if (parent == null) {
            return true;
        }
        ClassLoader c = child;
        do {
            if (c != parent) continue;
            return true;
        } while ((c = c.getParent()) != null);
        return false;
    }

    public static class TestingBackdoor {
        public static UnmodifiableEconomicMap<String, Class<?>> getPredefinedClasses() {
            return PredefinedClassesSupport.singleton().predefinedClassesByHash;
        }
    }
}

