/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.invoke;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Executable;
import java.util.function.BooleanSupplier;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import sun.invoke.util.Wrapper;

public class MethodHandleUtils {
    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static long longUnbox(Object retVal, MethodHandle methodHandle) {
        return MethodHandleUtils.longUnbox(retVal, methodHandle.type().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static long longUnbox(Object retVal, Target_java_lang_invoke_MemberName memberName) {
        return MethodHandleUtils.longUnbox(retVal, memberName.getMethodType().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    private static long longUnbox(Object retVal, Class<?> returnType) {
        switch (Wrapper.forPrimitiveType(returnType)) {
            case BOOLEAN: {
                return (Boolean)retVal != false ? 1L : 0L;
            }
            case BYTE: {
                return ((Byte)retVal).byteValue();
            }
            case SHORT: {
                return ((Short)retVal).shortValue();
            }
            case CHAR: {
                return ((Character)retVal).charValue();
            }
            case INT: {
                return ((Integer)retVal).intValue();
            }
            case LONG: {
                return (Long)retVal;
            }
        }
        throw VMError.shouldNotReachHere("Unexpected type for unbox function");
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static int intUnbox(Object retVal, MethodHandle methodHandle) {
        return MethodHandleUtils.intUnbox(retVal, methodHandle.type().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static int intUnbox(Object retVal, Target_java_lang_invoke_MemberName memberName) {
        return MethodHandleUtils.intUnbox(retVal, memberName.getMethodType().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static int intUnbox(Object retVal, Class<?> returnType) {
        switch (Wrapper.forPrimitiveType(returnType)) {
            case BOOLEAN: {
                return (Boolean)retVal != false ? 1 : 0;
            }
            case BYTE: {
                return ((Byte)retVal).byteValue();
            }
            case SHORT: {
                return ((Short)retVal).shortValue();
            }
            case CHAR: {
                return ((Character)retVal).charValue();
            }
            case INT: {
                return (Integer)retVal;
            }
        }
        throw VMError.shouldNotReachHere("Unexpected type for unbox function");
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static short shortUnbox(Object retVal, MethodHandle methodHandle) {
        return MethodHandleUtils.shortUnbox(retVal, methodHandle.type().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static short shortUnbox(Object retVal, Target_java_lang_invoke_MemberName memberName) {
        return MethodHandleUtils.shortUnbox(retVal, memberName.getMethodType().returnType());
    }

    @AlwaysInline(value="constant fold as much as possible in signature polymorphic wrappers")
    public static short shortUnbox(Object retVal, Class<?> returnType) {
        switch (Wrapper.forPrimitiveType(returnType)) {
            case BOOLEAN: {
                return (Boolean)retVal != false ? (short)1 : 0;
            }
            case BYTE: {
                return ((Byte)retVal).byteValue();
            }
            case SHORT: {
                return (Short)retVal;
            }
        }
        throw VMError.shouldNotReachHere("Unexpected type for unbox function");
    }

    public static ResolvedJavaMethod getThrowUnsupportedOperationException(MetaAccessProvider metaAccess) {
        try {
            return metaAccess.lookupJavaMethod((Executable)MethodHandleUtils.class.getMethod("throwUnsupportedOperationException", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere();
        }
    }

    public static void throwUnsupportedOperationException() {
        throw new UnsupportedOperationException("MethodHandle.invoke() and MethodHandle.invokeExact() cannot be invoked through reflection");
    }

    public static class MethodHandlesNotSupported
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return !SubstrateOptions.areMethodHandlesSupported();
        }
    }

    public static class MethodHandlesSupported
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return SubstrateOptions.areMethodHandlesSupported();
        }
    }
}

