/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization;

import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.localization.LocalizationFeature;
import com.oracle.svm.core.jdk.localization.OptimizedLocalizationSupport;
import com.oracle.svm.core.util.VMError;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class LocalizationSupport {
    public final Map<String, Charset> charsets = new HashMap<String, Charset>();
    public final Locale defaultLocale;
    public final Locale[] allLocales;
    public final Set<String> supportedLanguageTags;
    public final ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);

    public LocalizationSupport(Locale defaultLocale, Set<Locale> locales) {
        this.defaultLocale = defaultLocale;
        this.allLocales = locales.toArray(new Locale[0]);
        this.supportedLanguageTags = locales.stream().map(Locale::toString).collect(Collectors.toSet());
    }

    @Fold
    public static boolean optimizedMode() {
        return LocalizationFeature.Options.LocalizationOptimizedMode.getValue();
    }

    @Fold
    public static boolean jvmMode() {
        return !LocalizationSupport.optimizedMode();
    }

    public OptimizedLocalizationSupport asOptimizedSupport() {
        GraalError.guarantee((boolean)LocalizationSupport.optimizedMode(), (String)"Optimized support only available in optimized localization mode.");
        return (OptimizedLocalizationSupport)this;
    }

    public Map<String, Object> getBundleContentOf(Object bundle) {
        throw VMError.unsupportedFeature("Resource bundle lookup must be loaded during native image generation: " + bundle.getClass());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void prepareBundle(String bundleName, ResourceBundle bundle, Locale locale) {
        if (bundle instanceof PropertyResourceBundle) {
            String withLocale = this.control.toBundleName(bundleName, locale);
            ((ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class)).addResources(withLocale.replace('.', '/') + "\\.properties");
        } else {
            RuntimeReflection.register((Class[])new Class[]{bundle.getClass()});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{bundle.getClass()});
            this.onBundlePrepared(bundle);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void onBundlePrepared(ResourceBundle bundle) {
    }

    public boolean shouldSubstituteLoadLookup(String className) {
        return false;
    }

    public void prepareNonCompliant(Class<?> clazz) {
    }
}

