/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.monitor.MonitorSnippets;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.monitor.MultiThreadedMonitorSupport;
import com.oracle.svm.core.monitor.SingleThreadedMonitorSupport;
import java.util.Map;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class MonitorFeature
implements GraalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            ImageSingletons.add(MonitorSupport.class, (Object)new MultiThreadedMonitorSupport());
        } else {
            ImageSingletons.add(MonitorSupport.class, (Object)new SingleThreadedMonitorSupport());
        }
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        new MonitorSnippets(options, factories, providers, snippetReflection).registerLowerings(lowerings);
    }

    @Override
    public void registerForeignCalls(RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, SubstrateForeignCallsProvider foreignCalls, boolean hosted) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            foreignCalls.register(providers, MonitorSnippets.FOREIGN_CALLS);
        }
    }
}

