/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.ArrayIndexOfNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

@Platforms(value={Platform.AARCH64.class})
class AArch64ArrayIndexOfForeignCalls {
    private static final ForeignCallSignature[] ORIGINAL_FOREIGN_CALLS = new ForeignCallSignature[]{ArrayIndexOf.STUB_INDEX_OF_1_BYTE, ArrayIndexOf.STUB_INDEX_OF_1_CHAR_COMPACT};
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = (SnippetRuntime.SubstrateForeignCallDescriptor[])Arrays.stream(ORIGINAL_FOREIGN_CALLS).map(call -> SnippetRuntime.findForeignCall(AArch64ArrayIndexOfForeignCalls.class, call.getName(), true, new LocationIdentity[0])).toArray(SnippetRuntime.SubstrateForeignCallDescriptor[]::new);

    AArch64ArrayIndexOfForeignCalls() {
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1Byte(byte[] array, int arrayLength, int fromIndex, byte b) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Byte, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (byte)b);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1CharCompact(byte[] array, int arrayLength, int fromIndex, char ch) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Char, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (char)ch);
    }
}

