/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.hosted.classinitialization.InitKind;
import java.util.function.Function;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;

public final class ClassInitializationOptions {
    @APIOption.List(value={@APIOption(name={"initialize-at-run-time"}, valueTransformer={InitializationValueDelay.class}, defaultValue={""}, customHelp="A comma-separated list of packages and classes (and implicitly all of their subclasses) that must be initialized at runtime and not during image building. An empty string is currently not supported."), @APIOption(name={"initialize-at-build-time"}, valueTransformer={InitializationValueEager.class}, defaultValue={""}, customHelp="A comma-separated list of packages and classes (and implicitly all of their superclasses) that are initialized during image generation. An empty string designates all packages."), @APIOption(name={"delay-class-initialization-to-runtime"}, valueTransformer={InitializationValueDelay.class}, deprecated="Use --initialize-at-run-time.", defaultValue={""}, customHelp="A comma-separated list of classes (and implicitly all of their subclasses) that are initialized at runtime and not during image building"), @APIOption(name={"rerun-class-initialization-at-runtime"}, valueTransformer={InitializationValueRerun.class}, deprecated="Currently there is no replacement for this option. Try using --initialize-at-run-time or use the non-API option -H:ClassInitialization directly.", defaultValue={""}, customHelp="A comma-separated list of classes (and implicitly all of their subclasses) that are initialized both at runtime and during image building")})
    @Option(help={"A comma-separated list of classes appended with their initialization strategy (':build_time', ':rerun', or ':run_time')"}, type=OptionType.User)
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ClassInitialization = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
    @Option(help={"Prints class initialization info for all classes detected by analysis."}, type=OptionType.Debug)
    public static final HostedOptionKey<Boolean> PrintClassInitialization = new HostedOptionKey<Boolean>(false);

    private static class InitializationValueEager
    extends InitializationValueTransformer {
        InitializationValueEager() {
            super(InitKind.BUILD_TIME.name().toLowerCase());
        }
    }

    private static class InitializationValueRerun
    extends InitializationValueTransformer {
        InitializationValueRerun() {
            super(InitKind.RERUN.name().toLowerCase());
        }
    }

    private static class InitializationValueDelay
    extends InitializationValueTransformer {
        InitializationValueDelay() {
            super(InitKind.RUN_TIME.name().toLowerCase());
        }
    }

    private static class InitializationValueTransformer
    implements Function<Object, Object> {
        private final String val;

        InitializationValueTransformer(String val) {
            this.val = val;
        }

        @Override
        public Object apply(Object o) {
            String[] elements = o.toString().split(",");
            if (elements.length == 0) {
                return ":" + this.val;
            }
            CharSequence[] results = new String[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                results[i] = elements[i] + ":" + this.val;
            }
            return String.join((CharSequence)",", results);
        }
    }
}

