/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import com.oracle.svm.hosted.substitute.SubstitutionType;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import jdk.vm.ci.meta.ResolvedJavaType;

public class TypeInitializerGraph {
    private final SVMHost hostVM;
    private ClassInitializationSupport classInitializationSupport;
    private final Map<AnalysisType, Safety> types = new HashMap<AnalysisType, Safety>();
    private final Map<AnalysisType, Set<AnalysisType>> dependencies = new HashMap<AnalysisType, Set<AnalysisType>>();
    private final Map<AnalysisMethod, Safety> methodSafety = new HashMap<AnalysisMethod, Safety>();
    private final Collection<AnalysisMethod> methods;

    TypeInitializerGraph(AnalysisUniverse universe) {
        this.hostVM = (SVMHost)universe.hostVM();
        this.classInitializationSupport = this.hostVM.getClassInitializationSupport();
        universe.getTypes().forEach(this::addInitializer);
        universe.getTypes().forEach(this::addInitializerDependencies);
        this.methods = universe.getMethods();
        this.methods.stream().filter(AnalysisMethod::isImplementationInvoked).forEach(m -> this.methodSafety.put((AnalysisMethod)m, this.initialMethodSafety((AnalysisMethod)m)));
    }

    void computeInitializerSafety() {
        AtomicBoolean methodSafetyChanged;
        boolean newPromotions;
        do {
            methodSafetyChanged = new AtomicBoolean(false);
            this.methods.stream().filter(m -> this.methodSafety.get(m) == Safety.SAFE).forEach(m -> {
                if (this.updateMethodSafety((AnalysisMethod)m)) {
                    methodSafetyChanged.set(true);
                }
            });
        } while (newPromotions = methodSafetyChanged.get() || this.updateTypeInitializerSafety());
    }

    private Safety initialTypeInitializerSafety(AnalysisType t) {
        return this.classInitializationSupport.specifiedInitKindFor(t.getJavaClass()) == InitKind.BUILD_TIME || this.classInitializationSupport.canBeProvenSafe(t.getJavaClass()) ? Safety.SAFE : Safety.UNSAFE;
    }

    boolean isUnsafe(AnalysisType type) {
        return this.types.get(type) == Safety.UNSAFE;
    }

    public void setUnsafe(AnalysisType t) {
        this.types.put(t, Safety.UNSAFE);
    }

    private boolean updateTypeInitializerSafety() {
        return this.types.keySet().stream().map(t -> this.tryPromoteToUnsafe((AnalysisType)t, this.methodSafety)).reduce(false, (lhs, rhs) -> lhs != false || rhs != false);
    }

    private void addInitializerDependencies(AnalysisType t) {
        this.addInterfaceDependencies(t, t.getInterfaces());
        if (t.getSuperclass() != null) {
            this.addDependency(t, t.getSuperclass());
        }
    }

    private void addInterfaceDependencies(AnalysisType t, AnalysisType[] interfaces) {
        for (AnalysisType anInterface : interfaces) {
            if (anInterface.declaresDefaultMethods()) {
                this.addDependency(t, anInterface);
            }
            this.addInterfaceDependencies(t, anInterface.getInterfaces());
        }
    }

    private void addDependency(AnalysisType dependent, AnalysisType dependee) {
        this.dependencies.get(dependent).add(dependee);
    }

    private Safety initialMethodSafety(AnalysisMethod m) {
        return m.getTypeFlow().getInvokes().stream().anyMatch(this::isInvokeInitiallyUnsafe) || this.hostVM.hasClassInitializerSideEffect(m) || this.isSubstitutedMethod(m) ? Safety.UNSAFE : Safety.SAFE;
    }

    private boolean isSubstitutedMethod(AnalysisMethod m) {
        return !this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)m.getDeclaringClass()) && m.getWrapped() instanceof SubstitutionMethod;
    }

    private boolean isInvokeInitiallyUnsafe(InvokeTypeFlow i) {
        return i.getTargetMethod().isNative() || !i.canBeStaticallyBound();
    }

    private boolean tryPromoteToUnsafe(AnalysisType type, Map<AnalysisMethod, Safety> safeMethods) {
        if (this.types.get(type) == Safety.UNSAFE) {
            return false;
        }
        if (type.getClassInitializer() != null && safeMethods.get(type.getClassInitializer()) == Safety.UNSAFE || this.dependencies.get(type).stream().anyMatch(t -> this.types.get(t) == Safety.UNSAFE) || this.dependencies.get(type).stream().anyMatch(t -> this.tryPromoteToUnsafe((AnalysisType)t, safeMethods))) {
            this.setUnsafe(type);
            return true;
        }
        return false;
    }

    private boolean updateMethodSafety(AnalysisMethod m) {
        assert (this.methodSafety.get(m) == Safety.SAFE);
        Collection invokes = m.getTypeFlow().getInvokes();
        if (invokes.stream().anyMatch(this::isInvokeUnsafeIterative)) {
            this.methodSafety.put(m, Safety.UNSAFE);
            return true;
        }
        if (this.hostVM.getInitializedClasses(m).stream().anyMatch(this::isUnsafe)) {
            this.methodSafety.put(m, Safety.UNSAFE);
            return true;
        }
        return false;
    }

    private boolean isInvokeUnsafeIterative(InvokeTypeFlow i) {
        assert (i.getTargetMethod() != null) : "All methods can be statically bound.";
        return this.methodSafety.get(i.getTargetMethod()) == Safety.UNSAFE;
    }

    private void addInitializer(AnalysisType t) {
        ResolvedJavaType rt = t.getWrappedWithoutResolve();
        boolean isSubstituted = false;
        if (rt instanceof SubstitutionType) {
            SubstitutionType substitutionType = (SubstitutionType)rt;
            for (Annotation annotation : substitutionType.getAnnotations()) {
                if (!(annotation instanceof Substitute) && !(annotation instanceof Delete)) continue;
                isSubstituted = true;
                break;
            }
        }
        this.types.put(t, isSubstituted ? Safety.UNSAFE : this.initialTypeInitializerSafety(t));
        this.dependencies.put(t, new HashSet());
    }

    Set<AnalysisType> getDependencies(AnalysisType type) {
        return Collections.unmodifiableSet(this.dependencies.get(type));
    }

    private static enum Safety {
        SAFE,
        UNSAFE;

    }
}

