/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointBuiltins;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.code.IsolateEnterStub;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CEntryPointPrologueBailoutNode;
import com.oracle.svm.core.graal.nodes.DeadEndNode;
import com.oracle.svm.core.graal.replacements.SubstrateGraphKit;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.EnumLookupInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.phases.CInterfaceEnumTool;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.function.CEntryPoint;

public final class CEntryPointCallStubMethod
implements ResolvedJavaMethod,
GraphProvider {
    private static final LineNumberTable lineNumberTable = new LineNumberTable(new int[]{1}, new int[]{0});
    private static final JavaKind cEnumParameterKind = JavaKind.Int;
    private final CEntryPointData entryPointData;
    private final ResolvedJavaMethod targetMethod;
    private final ResolvedJavaType holderClass;
    private final ConstantPool holderConstantPool;
    private StackTraceElement stackTraceElement;

    static CEntryPointCallStubMethod create(AnalysisMethod targetMethod, CEntryPointData entryPointData, AnalysisMetaAccess metaAccess) {
        ResolvedJavaMethod unwrappedMethod = targetMethod.getWrapped();
        MetaAccessProvider unwrappedMetaAccess = metaAccess.getWrapped();
        ResolvedJavaType declaringClass = unwrappedMetaAccess.lookupJavaType(IsolateEnterStub.class);
        ConstantPool constantPool = IsolateEnterStub.getConstantPool(unwrappedMetaAccess);
        return new CEntryPointCallStubMethod(entryPointData, unwrappedMethod, declaringClass, constantPool);
    }

    private CEntryPointCallStubMethod(CEntryPointData entryPointData, ResolvedJavaMethod targetMethod, ResolvedJavaType holderClass, ConstantPool holderConstantPool) {
        this.entryPointData = entryPointData;
        this.targetMethod = targetMethod;
        this.holderClass = holderClass;
        this.holderConstantPool = holderConstantPool;
    }

    public String getName() {
        return SubstrateUtil.uniqueShortName(this.targetMethod);
    }

    public Signature getSignature() {
        return this.targetMethod.getSignature();
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.targetMethod.getParameters();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.holderClass;
    }

    public ConstantPool getConstantPool() {
        return this.holderConstantPool;
    }

    private ResolvedJavaMethod lookupMethodInUniverse(UniverseMetaAccess metaAccess, ResolvedJavaMethod method) {
        ResolvedJavaMethod universeMethod = method;
        MetaAccessProvider wrappedMetaAccess = metaAccess.getWrapped();
        if (wrappedMetaAccess instanceof UniverseMetaAccess) {
            universeMethod = this.lookupMethodInUniverse((UniverseMetaAccess)wrappedMetaAccess, universeMethod);
        }
        return metaAccess.getUniverse().lookup((JavaMethod)universeMethod);
    }

    AnalysisMethod lookupTargetMethod(AnalysisMetaAccess metaAccess) {
        return (AnalysisMethod)this.lookupMethodInUniverse((UniverseMetaAccess)metaAccess, this.targetMethod);
    }

    private ResolvedJavaMethod unwrapMethodAndLookupInUniverse(UniverseMetaAccess metaAccess) {
        ResolvedJavaMethod unwrappedTargetMethod = this.targetMethod;
        while (unwrappedTargetMethod instanceof WrappedJavaMethod) {
            unwrappedTargetMethod = ((WrappedJavaMethod)unwrappedTargetMethod).getWrapped();
        }
        return this.lookupMethodInUniverse(metaAccess, unwrappedTargetMethod);
    }

    public boolean allowRuntimeCompilation() {
        return false;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        if (this.entryPointData.getBuiltin() != CEntryPointData.DEFAULT_BUILTIN) {
            return this.buildBuiltinGraph(debug, method, providers);
        }
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        NativeLibraries nativeLibraries = CEntryPointCallStubSupport.singleton().getNativeLibraries();
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
        JavaType[] parameterTypes = method.toParameterTypes();
        JavaType[] parameterLoadTypes = Arrays.copyOf(parameterTypes, parameterTypes.length);
        EnumInfo[] parameterEnumInfos = this.adaptParameterTypes(providers, nativeLibraries, kit, parameterTypes, parameterLoadTypes, purpose);
        ValueNode[] args = kit.loadArguments(parameterLoadTypes).toArray(new ValueNode[0]);
        InvokeNode prologueInvoke = this.generatePrologue(providers, kit, parameterLoadTypes, this.targetMethod.getParameterAnnotations(), args);
        CEntryPointCallStubMethod.adaptArgumentValues(providers, kit, parameterTypes, parameterEnumInfos, args);
        ResolvedJavaMethod universeTargetMethod = this.unwrapMethodAndLookupInUniverse(metaAccess);
        kit.emitEnsureInitializedCall(universeTargetMethod.getDeclaringClass());
        int invokeBci = kit.bci();
        CallTargetNode.InvokeKind invokeKind = universeTargetMethod.isStatic() ? CallTargetNode.InvokeKind.Static : CallTargetNode.InvokeKind.Special;
        ValueNode[] invokeArgs = args;
        if (invokeKind != CallTargetNode.InvokeKind.Static) {
            invokeArgs = new ValueNode[args.length + 1];
            invokeArgs[0] = kit.createObject(null);
            System.arraycopy(args, 0, invokeArgs, 1, args.length);
        }
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(universeTargetMethod, invokeKind, kit.getFrameState(), invokeBci, invokeArgs);
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        this.generateExceptionHandler(providers, kit, exception, invoke.getStackKind());
        kit.endInvokeWithException();
        ValueNode returnValue = this.adaptReturnValue(method, providers, purpose, metaAccess, nativeLibraries, kit, (ValueNode)invoke);
        InvokeNode epilogueInvoke = this.generateEpilogue(providers, kit);
        kit.createReturn(returnValue, returnValue.getStackKind());
        CEntryPointCallStubMethod.inlinePrologueAndEpilogue(kit, prologueInvoke, epilogueInvoke, invoke.getStackKind());
        return kit.finalizeGraph();
    }

    private StructuredGraph buildBuiltinGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers) {
        int index;
        ResolvedJavaMethod universeTargetMethod = this.unwrapMethodAndLookupInUniverse((UniverseMetaAccess)providers.getMetaAccess());
        UserError.guarantee(this.entryPointData.getPrologue() == CEntryPointData.DEFAULT_PROLOGUE, "@%s method declared as built-in must not have a custom prologue: %s", CEntryPoint.class.getSimpleName(), universeTargetMethod);
        UserError.guarantee(this.entryPointData.getEpilogue() == CEntryPointData.DEFAULT_EPILOGUE, "@%s method declared as built-in must not have a custom epilogue: %s", CEntryPoint.class.getSimpleName(), universeTargetMethod);
        UserError.guarantee(this.entryPointData.getExceptionHandler() == CEntryPointData.DEFAULT_EXCEPTION_HANDLER, "@%s method declared as built-in must not have a custom exception handler: %s", CEntryPoint.class.getSimpleName(), universeTargetMethod);
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
        ExecutionContextParameters executionContext = this.findExecutionContextParameters(providers, universeTargetMethod.toParameterTypes(), universeTargetMethod.getParameterAnnotations());
        CEntryPoint.Builtin builtin = this.entryPointData.getBuiltin();
        ResolvedJavaMethod builtinCallee = null;
        for (ResolvedJavaMethod candidate : metaAccess.lookupJavaType(CEntryPointBuiltins.class).getDeclaredMethods()) {
            CEntryPointBuiltins.CEntryPointBuiltinImplementation annotation = (CEntryPointBuiltins.CEntryPointBuiltinImplementation)candidate.getAnnotation(CEntryPointBuiltins.CEntryPointBuiltinImplementation.class);
            if (annotation == null || !annotation.builtin().equals((Object)builtin)) continue;
            VMError.guarantee(builtinCallee == null, "More than one candidate for @" + CEntryPoint.class.getSimpleName() + " built-in " + builtin);
            builtinCallee = candidate;
        }
        VMError.guarantee(builtinCallee != null, "No candidate for @" + CEntryPoint.class.getSimpleName() + " built-in " + builtin);
        ResolvedJavaType isolateType = providers.getMetaAccess().lookupJavaType(Isolate.class);
        ResolvedJavaType threadType = providers.getMetaAccess().lookupJavaType(IsolateThread.class);
        int builtinIsolateIndex = -1;
        int builtinThreadIndex = -1;
        JavaType[] builtinParamTypes = builtinCallee.toParameterTypes();
        for (int i = 0; i < builtinParamTypes.length; ++i) {
            ResolvedJavaType type = (ResolvedJavaType)builtinParamTypes[i];
            if (isolateType.isAssignableFrom(type)) {
                VMError.guarantee(builtinIsolateIndex == -1, "@" + CEntryPoint.class.getSimpleName() + " built-in with more than one " + Isolate.class.getSimpleName() + " parameter: " + builtinCallee.format("%H.%n(%p)"));
                builtinIsolateIndex = i;
                continue;
            }
            if (threadType.isAssignableFrom(type)) {
                VMError.guarantee(builtinThreadIndex == -1, "@" + CEntryPoint.class.getSimpleName() + " built-in with more than one " + IsolateThread.class.getSimpleName() + " parameter: " + builtinCallee.format("%H.%n(%p)"));
                builtinThreadIndex = i;
                continue;
            }
            VMError.shouldNotReachHere("@" + CEntryPoint.class.getSimpleName() + " built-in currently may have only " + Isolate.class.getSimpleName() + " or " + IsolateThread.class.getSimpleName() + " parameters: " + builtinCallee.format("%H.%n(%p)"));
        }
        ValueNode[] args = kit.loadArguments(method.toParameterTypes()).toArray(new ValueNode[0]);
        ValueNode[] builtinArgs = new ValueNode[builtinParamTypes.length];
        if (builtinIsolateIndex != -1) {
            VMError.guarantee(executionContext.designatedIsolateIndex != -1 || executionContext.isolateCount == 1, "@" + CEntryPoint.class.getSimpleName() + " built-in " + this.entryPointData.getBuiltin() + " needs exactly one " + Isolate.class.getSimpleName() + " parameter: " + builtinCallee.format("%H.%n(%p)"));
            index = executionContext.designatedIsolateIndex != -1 ? executionContext.designatedIsolateIndex : executionContext.lastIsolateIndex;
            builtinArgs[builtinIsolateIndex] = args[index];
        }
        if (builtinThreadIndex != -1) {
            VMError.guarantee(executionContext.designatedThreadIndex != -1 || executionContext.threadCount == 1, "@" + CEntryPoint.class.getSimpleName() + " built-in " + this.entryPointData.getBuiltin() + " needs exactly one " + IsolateThread.class.getSimpleName() + " parameter: " + builtinCallee.format("%H.%n(%p)"));
            index = executionContext.designatedThreadIndex != -1 ? executionContext.designatedThreadIndex : executionContext.lastThreadIndex;
            builtinArgs[builtinThreadIndex] = args[index];
        }
        int invokeBci = kit.bci();
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(builtinCallee, CallTargetNode.InvokeKind.Static, kit.getFrameState(), invokeBci, builtinArgs);
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        this.generateExceptionHandler(providers, kit, exception, invoke.getStackKind());
        kit.endInvokeWithException();
        kit.createReturn((ValueNode)invoke, universeTargetMethod.getSignature().getReturnKind());
        return kit.finalizeGraph();
    }

    private EnumInfo[] adaptParameterTypes(HostedProviders providers, NativeLibraries nativeLibraries, HostedGraphKit kit, JavaType[] parameterTypes, JavaType[] parameterLoadTypes, GraphProvider.Purpose purpose) {
        EnumInfo[] parameterEnumInfos = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].getJavaKind().isPrimitive() || providers.getWordTypes().isWord(parameterTypes[i])) continue;
            ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)((ResolvedJavaType)parameterTypes[i]));
            if (typeInfo instanceof EnumInfo) {
                UserError.guarantee(typeInfo.getChildren().stream().anyMatch(EnumLookupInfo.class::isInstance), "Enum class %s needs a method that is annotated with @%s because it is used as a parameter of an entry point method: %s", parameterTypes[i], CEnumLookup.class.getSimpleName(), this.targetMethod);
                if (parameterEnumInfos == null) {
                    parameterEnumInfos = new EnumInfo[parameterTypes.length];
                }
                parameterEnumInfos[i] = (EnumInfo)typeInfo;
                parameterLoadTypes[i] = providers.getMetaAccess().lookupJavaType(cEnumParameterKind.toJavaClass());
                int parameterIndex = i;
                FrameState initialState = kit.getGraph().start().stateAfter();
                Iterator matchingNodes = initialState.values().filter(node -> ((ParameterNode)node).index() == parameterIndex).iterator();
                ValueNode parameterNode = (ValueNode)matchingNodes.next();
                assert (!matchingNodes.hasNext() && parameterNode.usages().filter(n -> n != initialState).isEmpty());
                parameterNode.setStamp(StampFactory.forKind((JavaKind)cEnumParameterKind));
                continue;
            }
            if (purpose == GraphProvider.Purpose.ANALYSIS) continue;
            throw UserError.abort("Entry point method parameter types are restricted to primitive types, word types and enumerations (@%s): %s", CEnum.class.getSimpleName(), this.targetMethod);
        }
        return parameterEnumInfos;
    }

    private static void adaptArgumentValues(HostedProviders providers, HostedGraphKit kit, JavaType[] parameterTypes, EnumInfo[] parameterEnumInfos, ValueNode[] args) {
        if (parameterEnumInfos != null) {
            for (int i = 0; i < parameterEnumInfos.length; ++i) {
                if (parameterEnumInfos[i] == null) continue;
                CInterfaceEnumTool tool = new CInterfaceEnumTool(providers.getMetaAccess(), providers.getSnippetReflection());
                args[i] = tool.createEnumLookupInvoke(kit, (ResolvedJavaType)parameterTypes[i], parameterEnumInfos[i], cEnumParameterKind, args[i]);
            }
        }
    }

    private InvokeNode generatePrologue(HostedProviders providers, SubstrateGraphKit kit, JavaType[] parameterTypes, Annotation[][] parameterAnnotations, ValueNode[] args) {
        Class<Object> prologueClass = this.entryPointData.getPrologue();
        if (prologueClass == CEntryPointOptions.NoPrologue.class) {
            UserError.guarantee(this.targetMethod.getAnnotation(Uninterruptible.class) != null, "%s.%s is allowed only for methods annotated with @%s: %s", CEntryPointOptions.class.getSimpleName(), CEntryPointOptions.NoPrologue.class.getSimpleName(), Uninterruptible.class.getSimpleName(), this.targetMethod);
            return null;
        }
        if (prologueClass != CEntryPointOptions.AutomaticPrologue.class) {
            ResolvedJavaType prologue = providers.getMetaAccess().lookupJavaType(prologueClass);
            ResolvedJavaMethod[] prologueMethods = prologue.getDeclaredMethods();
            UserError.guarantee(prologueMethods.length == 1 && prologueMethods[0].isStatic(), "Prologue class must declare exactly one static method: %s -> %s", this.targetMethod, prologue);
            ValueNode[] prologueArgs = this.matchPrologueParameters(providers, parameterTypes, args, prologueMethods[0]);
            return kit.createInvoke(prologueMethods[0], CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), prologueArgs);
        }
        ExecutionContextParameters executionContext = this.findExecutionContextParameters(providers, parameterTypes, parameterAnnotations);
        int contextIndex = -1;
        if (executionContext.designatedThreadIndex != -1) {
            contextIndex = executionContext.designatedThreadIndex;
        } else if (executionContext.threadCount == 1) {
            contextIndex = executionContext.lastThreadIndex;
        } else {
            UserError.abort("@%s requires exactly one execution context parameter of type %s: %s", CEntryPoint.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
        }
        ValueNode contextValue = args[contextIndex];
        prologueClass = CEntryPointSetup.EnterPrologue.class;
        ResolvedJavaMethod[] prologueMethods = providers.getMetaAccess().lookupJavaType(prologueClass).getDeclaredMethods();
        assert (prologueMethods.length == 1 && prologueMethods[0].isStatic()) : "Prologue class must declare exactly one static method";
        return kit.createInvoke(prologueMethods[0], CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{contextValue});
    }

    private ExecutionContextParameters findExecutionContextParameters(HostedProviders providers, JavaType[] parameterTypes, Annotation[][] parameterAnnotations) {
        ResolvedJavaType isolateType = providers.getMetaAccess().lookupJavaType(Isolate.class);
        ResolvedJavaType threadType = providers.getMetaAccess().lookupJavaType(IsolateThread.class);
        ExecutionContextParameters result = new ExecutionContextParameters();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ResolvedJavaType declaredType = (ResolvedJavaType)parameterTypes[i];
            boolean isIsolate = isolateType.isAssignableFrom(declaredType);
            boolean isThread = threadType.isAssignableFrom(declaredType);
            boolean isLong = declaredType.getJavaKind() == JavaKind.Long;
            boolean designated = false;
            for (Annotation ann : parameterAnnotations[i]) {
                if (ann.annotationType() == CEntryPoint.IsolateContext.class) {
                    UserError.guarantee(isIsolate || isLong, "@%s parameter %d is annotated with @%s, but does not have type %s: %s", CEntryPoint.class.getSimpleName(), i, CEntryPoint.IsolateContext.class.getSimpleName(), Isolate.class.getSimpleName(), this.targetMethod);
                    designated = true;
                    isIsolate = true;
                    continue;
                }
                if (ann.annotationType() != CEntryPoint.IsolateThreadContext.class) continue;
                UserError.guarantee(isThread || isLong, "@%s parameter %d is annotated with @%s, but does not have type %s: %s", CEntryPoint.class.getSimpleName(), i, CEntryPoint.IsolateThreadContext.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
                designated = true;
                isThread = true;
            }
            UserError.guarantee(!isIsolate || !isThread, "@%s parameter %d has a type as both an %s and a %s: %s", CEntryPoint.class.getSimpleName(), i, Isolate.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
            if (isIsolate) {
                result.lastIsolateIndex = i;
                ++result.isolateCount;
                if (!designated) continue;
                UserError.guarantee(result.designatedIsolateIndex == -1, "@%s has more than one designated %s parameter: %s", CEntryPoint.class.getSimpleName(), Isolate.class.getSimpleName(), this.targetMethod);
                result.designatedIsolateIndex = i;
                continue;
            }
            if (!isThread) continue;
            result.lastThreadIndex = i;
            ++result.threadCount;
            if (!designated) continue;
            UserError.guarantee(result.designatedThreadIndex == -1, "@%s has more than one designated %s parameter: %s", CEntryPoint.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
            result.designatedThreadIndex = i;
        }
        return result;
    }

    private ValueNode[] matchPrologueParameters(HostedProviders providers, JavaType[] types, ValueNode[] values, ResolvedJavaMethod prologueMethod) {
        JavaType[] prologueTypes = prologueMethod.toParameterTypes();
        ValueNode[] prologueValues = new ValueNode[prologueTypes.length];
        int i = 0;
        for (int p = 0; p < prologueTypes.length; ++p) {
            ResolvedJavaType prologueType = (ResolvedJavaType)prologueTypes[p];
            UserError.guarantee(prologueType.isPrimitive() || providers.getWordTypes().isWord((JavaType)prologueType), "Prologue method parameter types are restricted to primitive types and word types: %s -> %s", this.targetMethod, prologueMethod);
            while (i < types.length && !prologueType.isAssignableFrom((ResolvedJavaType)types[i])) {
                ++i;
            }
            if (i >= types.length) {
                throw UserError.abort("Unable to match signature of entry point method to that of prologue method: %s -> %s", this.targetMethod, prologueMethod);
            }
            prologueValues[p] = values[i];
            ++i;
        }
        return prologueValues;
    }

    private void generateExceptionHandler(HostedProviders providers, SubstrateGraphKit kit, ExceptionObjectNode exception, JavaKind returnKind) {
        if (this.entryPointData.getExceptionHandler() == CEntryPoint.FatalExceptionHandler.class) {
            kit.appendStateSplitProxy(exception.stateAfter());
            CEntryPointLeaveNode leave = new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)exception);
            kit.append((ValueNode)leave);
            kit.append((ValueNode)new DeadEndNode());
        } else {
            ResolvedJavaType throwable = providers.getMetaAccess().lookupJavaType(Throwable.class);
            ResolvedJavaType handler = providers.getMetaAccess().lookupJavaType(this.entryPointData.getExceptionHandler());
            ResolvedJavaMethod[] handlerMethods = handler.getDeclaredMethods();
            UserError.guarantee(handlerMethods.length == 1 && handlerMethods[0].isStatic(), "Exception handler class must declare exactly one static method: %s -> %s", this.targetMethod, handler);
            JavaType[] handlerParameterTypes = handlerMethods[0].toParameterTypes();
            UserError.guarantee(handlerParameterTypes.length == 1 && ((ResolvedJavaType)handlerParameterTypes[0]).isAssignableFrom(throwable), "Exception handler method must have exactly one parameter of type Throwable: %s -> %s", this.targetMethod, handlerMethods[0]);
            InvokeWithExceptionNode handlerInvoke = kit.startInvokeWithException(handlerMethods[0], CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{exception});
            kit.noExceptionPart();
            InvokeWithExceptionNode returnValue = handlerInvoke;
            if (handlerInvoke.getStackKind() != returnKind) {
                JavaKind fromKind = handlerInvoke.getStackKind();
                if (fromKind == JavaKind.Float && returnKind == JavaKind.Double) {
                    returnValue = kit.unique((FloatingNode)new FloatConvertNode(FloatConvert.F2D, (ValueNode)returnValue));
                } else if (fromKind.isUnsigned() && returnKind.isNumericInteger() && returnKind.getBitCount() > fromKind.getBitCount()) {
                    returnValue = kit.unique((FloatingNode)new ZeroExtendNode((ValueNode)returnValue, returnKind.getBitCount()));
                } else if (fromKind.isNumericInteger() && returnKind.isNumericInteger() && returnKind.getBitCount() > fromKind.getBitCount()) {
                    returnValue = kit.unique((FloatingNode)new SignExtendNode((ValueNode)returnValue, returnKind.getBitCount()));
                } else {
                    throw UserError.abort("Exception handler method return type must be assignable to entry point method return type: %s -> %s", this.targetMethod, handlerMethods[0]);
                }
            }
            InvokeNode epilogueInvoke = this.generateEpilogue(providers, kit);
            kit.createReturn((ValueNode)returnValue, returnValue.getStackKind());
            kit.exceptionPart();
            kit.append((ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)kit.exceptionObject()));
            kit.append((ValueNode)new DeadEndNode());
            kit.endInvokeWithException();
            kit.inlineAsIntrinsic((Invoke)epilogueInvoke, "Inline epilogue.", "GraphBuilding");
        }
    }

    private ValueNode adaptReturnValue(ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose, UniverseMetaAccess metaAccess, NativeLibraries nativeLibraries, HostedGraphKit kit, ValueNode invokeValue) {
        ValueNode returnValue = invokeValue;
        if (returnValue.getStackKind().isPrimitive()) {
            return returnValue;
        }
        JavaType returnType = method.getSignature().getReturnType(null);
        ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)((ResolvedJavaType)returnType));
        if (typeInfo instanceof EnumInfo) {
            IsNullNode isNull = (IsNullNode)kit.unique((FloatingNode)new IsNullNode(returnValue));
            kit.startIf((LogicNode)isNull, BranchProbabilityNode.VERY_SLOW_PATH_PROFILE);
            kit.thenPart();
            ResolvedJavaType enumExceptionType = metaAccess.lookupJavaType(RuntimeException.class);
            NewInstanceNode enumException = (NewInstanceNode)kit.append((ValueNode)new NewInstanceNode(enumExceptionType, true));
            Iterator enumExceptionCtor = Arrays.stream(enumExceptionType.getDeclaredConstructors()).filter(c -> c.getSignature().getParameterCount(false) == 1 && c.getSignature().getParameterType(0, null).equals(metaAccess.lookupJavaType(String.class))).iterator();
            ConstantNode enumExceptionMessage = kit.createConstant((Constant)kit.getConstantReflection().forString("null return value cannot be converted to a C enum value"), JavaKind.Object);
            kit.createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind.Special, (ResolvedJavaMethod)enumExceptionCtor.next(), new ValueNode[]{enumException, enumExceptionMessage});
            assert (!enumExceptionCtor.hasNext());
            kit.appendStateSplitProxy(kit.getFrameState());
            CEntryPointLeaveNode leave = new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)enumException);
            kit.append((ValueNode)leave);
            kit.append((ValueNode)new DeadEndNode());
            kit.endIf();
            CInterfaceEnumTool tool = new CInterfaceEnumTool(providers.getMetaAccess(), providers.getSnippetReflection());
            JavaKind cEnumReturnType = providers.getWordTypes().getWordKind();
            assert (!cEnumReturnType.isUnsigned()) : "requires correct representation of signed values";
            returnValue = tool.createEnumValueInvoke(kit, (EnumInfo)typeInfo, cEnumReturnType, returnValue);
        } else if (purpose != GraphProvider.Purpose.ANALYSIS) {
            throw UserError.abort("Entry point method return types are restricted to primitive types, word types and enumerations (@%s): %s", CEnum.class.getSimpleName(), this.targetMethod);
        }
        return returnValue;
    }

    private InvokeNode generateEpilogue(HostedProviders providers, SubstrateGraphKit kit) {
        Class<?> epilogueClass = this.entryPointData.getEpilogue();
        if (epilogueClass == CEntryPointOptions.NoEpilogue.class) {
            UserError.guarantee(this.targetMethod.getAnnotation(Uninterruptible.class) != null, "%s.%s is allowed only for methods annotated with @%s: %s", CEntryPointOptions.class.getSimpleName(), CEntryPointOptions.NoEpilogue.class.getSimpleName(), Uninterruptible.class.getSimpleName(), this.targetMethod);
            return null;
        }
        ResolvedJavaType epilogue = providers.getMetaAccess().lookupJavaType(epilogueClass);
        ResolvedJavaMethod[] epilogueMethods = epilogue.getDeclaredMethods();
        UserError.guarantee(epilogueMethods.length == 1 && epilogueMethods[0].isStatic() && epilogueMethods[0].getSignature().getParameterCount(false) == 0, "Epilogue class must declare exactly one static method without parameters: %s -> %s", this.targetMethod, epilogue);
        return kit.createInvoke(epilogueMethods[0], CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[0]);
    }

    private static void inlinePrologueAndEpilogue(SubstrateGraphKit kit, InvokeNode prologueInvoke, InvokeNode epilogueInvoke, JavaKind returnKind) {
        if (prologueInvoke != null) {
            AbstractMergeNode merge;
            FixedNode next = prologueInvoke.next();
            FrameState stateAfterPrologue = prologueInvoke.stateAfter();
            stateAfterPrologue = stateAfterPrologue == null ? kit.getFrameState().create(prologueInvoke.bci(), null) : stateAfterPrologue.duplicateWithVirtualState();
            kit.inlineAsIntrinsic((Invoke)prologueInvoke, "Inline prologue.", "GraphBuilding");
            if (next.isAlive() && next.predecessor() instanceof AbstractMergeNode && (merge = (AbstractMergeNode)next.predecessor()).stateAfter() == null) {
                merge.setStateAfter(stateAfterPrologue);
            }
            NodeIterable bailoutNodes = kit.getGraph().getNodes().filter(CEntryPointPrologueBailoutNode.class);
            for (CEntryPointPrologueBailoutNode node : bailoutNodes) {
                ValueNode result = node.getResult();
                switch (returnKind) {
                    case Float: {
                        assert (result.getStackKind().isNumericFloat());
                        result = kit.unique((FloatingNode)new FloatConvertNode(FloatConvert.D2F, result));
                        break;
                    }
                    case Byte: 
                    case Char: 
                    case Short: 
                    case Int: {
                        assert (result.getStackKind().isNumericInteger());
                        result = kit.unique((FloatingNode)new NarrowNode(result, returnKind.getBitCount()));
                        break;
                    }
                }
                ReturnNode returnNode = (ReturnNode)kit.add((ValueNode)new ReturnNode(result));
                node.replaceAndDelete((Node)returnNode);
            }
        }
        if (epilogueInvoke != null && epilogueInvoke.isAlive()) {
            kit.inlineAsIntrinsic((Invoke)epilogueInvoke, "Inline epilogue.", "GraphBuilding");
        }
    }

    public int getModifiers() {
        return 9;
    }

    public byte[] getCode() {
        return null;
    }

    public int getCodeSize() {
        return 0;
    }

    public int getMaxLocals() {
        return 2 * this.getSignature().getParameterCount(true);
    }

    public int getMaxStackSize() {
        return 2;
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isVarArgs() {
        return false;
    }

    public boolean isBridge() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isClassInitializer() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean canBeStaticallyBound() {
        return true;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return new ExceptionHandler[0];
    }

    public StackTraceElement asStackTraceElement(int bci) {
        if (this.stackTraceElement == null) {
            this.stackTraceElement = new StackTraceElement(this.getDeclaringClass().toJavaName(true), this.getName(), "generated", 0);
        }
        return this.stackTraceElement;
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        throw VMError.unimplemented();
    }

    public void reprofile() {
        throw VMError.unimplemented();
    }

    public Annotation[][] getParameterAnnotations() {
        throw VMError.unimplemented();
    }

    public Type[] getGenericParameterTypes() {
        throw VMError.unimplemented();
    }

    public boolean canBeInlined() {
        return false;
    }

    public boolean hasNeverInlineDirective() {
        return false;
    }

    public boolean shouldBeInlined() {
        return false;
    }

    public LineNumberTable getLineNumberTable() {
        return lineNumberTable;
    }

    public LocalVariableTable getLocalVariableTable() {
        return null;
    }

    public Constant getEncoding() {
        throw VMError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw VMError.unimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.unimplemented();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    public Annotation[] getAnnotations() {
        return new Annotation[0];
    }

    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[0];
    }

    private static class ExecutionContextParameters {
        int isolateCount = 0;
        int lastIsolateIndex = -1;
        int designatedIsolateIndex = -1;
        int threadCount = 0;
        int lastThreadIndex = -1;
        int designatedThreadIndex = -1;

        private ExecutionContextParameters() {
        }
    }
}

