/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.core.annotate.NeverInlineTrivial;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.options.Option;
import org.graalvm.util.GuardedAnnotationAccess;

public final class InlineBeforeAnalysisPolicyImpl
extends InlineBeforeAnalysisPolicy<CountersScope> {
    private final int allowedNodes = Options.InlineBeforeAnalysisAllowedNodes.getValue();
    private final int allowedInvokes = Options.InlineBeforeAnalysisAllowedInvokes.getValue();
    private final int allowedDepth = Options.InlineBeforeAnalysisAllowedDepth.getValue();

    protected boolean shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (b.getDepth() > this.allowedDepth) {
            return false;
        }
        AnalysisMethod caller = (AnalysisMethod)b.getMethod();
        AnalysisMethod callee = (AnalysisMethod)method;
        if (!callee.canBeInlined()) {
            return false;
        }
        if (GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, NeverInlineTrivial.class)) {
            return false;
        }
        if (GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, RestrictHeapAccess.class)) {
            return false;
        }
        return Uninterruptible.Utils.inliningAllowed((AnnotatedElement)caller, (AnnotatedElement)callee);
    }

    protected CountersScope createTopScope() {
        CountersScope accumulated = new CountersScope(null);
        return new CountersScope(accumulated);
    }

    protected CountersScope openCalleeScope(CountersScope outer) {
        return new CountersScope(outer.accumulated);
    }

    protected void commitCalleeScope(CountersScope outer, CountersScope callee) {
        assert (outer.accumulated == callee.accumulated);
        outer.numNodes += callee.numNodes;
        outer.numInvokes += callee.numInvokes;
    }

    protected void abortCalleeScope(CountersScope outer, CountersScope callee) {
        assert (outer.accumulated == callee.accumulated);
        outer.accumulated.numNodes -= callee.numNodes;
        outer.accumulated.numInvokes -= callee.numInvokes;
    }

    protected boolean processNode(CountersScope scope, Node node) {
        if (node instanceof StartNode || node instanceof ParameterNode || node instanceof ReturnNode || node instanceof UnwindNode) {
            throw VMError.shouldNotReachHere("Node must not be visible to policy: " + node.getClass().getTypeName());
        }
        if (node.getNodeClass().size() == NodeSize.SIZE_0 || node instanceof FrameState) {
            return true;
        }
        if (node instanceof ConstantNode || node instanceof LogicConstantNode) {
            return true;
        }
        if (node instanceof AbstractNewObjectNode) {
            ValueNode newArrayLength;
            return node instanceof NewArrayNode && (newArrayLength = ((NewArrayNode)node).length()).isJavaConstant() && newArrayLength.asJavaConstant().asInt() == 0;
        }
        if (node instanceof Invoke) {
            throw VMError.shouldNotReachHere("Node must not visible to policy: " + node.getClass().getTypeName());
        }
        if (node instanceof CallTargetNode) {
            if (scope.accumulated.numInvokes >= this.allowedInvokes) {
                return false;
            }
            ++scope.numInvokes;
            ++scope.accumulated.numInvokes;
        }
        if (scope.accumulated.numNodes >= this.allowedNodes) {
            return false;
        }
        ++scope.numNodes;
        ++scope.accumulated.numNodes;
        return true;
    }

    static final class CountersScope
    implements InlineBeforeAnalysisPolicy.Scope {
        final CountersScope accumulated;
        int numNodes;
        int numInvokes;

        CountersScope(CountersScope accumulated) {
            this.accumulated = accumulated;
        }
    }

    public static class Options {
        @Option(help={"Maximum number of computation nodes for method inlined before static analysis"})
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedNodes = new HostedOptionKey<Integer>(1);
        @Option(help={"Maximum number of invokes for method inlined before static analysis"})
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedInvokes = new HostedOptionKey<Integer>(1);
        @Option(help={"Maximum number of invokes for method inlined before static analysis"})
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedDepth = new HostedOptionKey<Integer>(20);
    }
}

