/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.annotation.CustomSubstitution;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.reflect.helpers.InvokeSpecialReflectionProxy;
import com.oracle.svm.reflect.helpers.ReflectionProxy;
import com.oracle.svm.reflect.hosted.ReflectionSubstitutionType;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;

final class ReflectionSubstitution
extends CustomSubstitution<ReflectionSubstitutionType> {
    private static final String PROXY_NAME_SEPARATOR = "_";
    private final ClassInitializationSupport classInitializationSupport;
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SUPER = 32;
    private final Method defineClass;
    private final Method resolveClass;
    private final ResolvedJavaType reflectionProxy;
    private final ResolvedJavaType javaLangReflectProxy;
    private final HashMap<Executable, Class<?>> proxyMap = new HashMap();
    private final HashMap<ResolvedJavaType, Executable> typeToMember = new HashMap();
    private static final UninterruptibleUtils.AtomicInteger proxyNr = new UninterruptibleUtils.AtomicInteger(0);
    private final ImageClassLoader imageClassLoader;
    private static Method generateProxyMethod;

    ReflectionSubstitution(MetaAccessProvider metaAccess, ClassInitializationSupport initializationSupport, ImageClassLoader classLoader) {
        super(metaAccess);
        this.defineClass = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
        this.resolveClass = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"resolveClass", (Class[])new Class[]{Class.class});
        this.reflectionProxy = metaAccess.lookupJavaType(ReflectionProxy.class);
        this.javaLangReflectProxy = metaAccess.lookupJavaType(Proxy.class);
        this.classInitializationSupport = initializationSupport;
        this.imageClassLoader = classLoader;
    }

    static String getStableProxyName(Executable member) {
        return "com.oracle.svm.reflect." + SubstrateUtil.uniqueShortName(member);
    }

    private static Class<?> getAccessorInterface(Executable member) {
        if (member instanceof Method) {
            return ReflectionSubstitution.packageJdkInternalReflectClassForName("MethodAccessor");
        }
        if (member instanceof Constructor) {
            return ReflectionSubstitution.packageJdkInternalReflectClassForName("ConstructorAccessor");
        }
        throw VMError.shouldNotReachHere();
    }

    private static Class<?> packageJdkInternalReflectClassForName(String className) {
        String packageName = JavaVersionUtil.JAVA_SPEC <= 8 ? "sun.reflect." : "jdk.internal.reflect.";
        try {
            return Class.forName(packageName + className);
        }
        catch (ClassNotFoundException cnfe) {
            throw VMError.shouldNotReachHere(cnfe);
        }
    }

    private static byte[] generateProxyClass(String name, Class<?>[] interfaces) {
        try {
            if (generateProxyMethod == null) {
                String packageName = JavaVersionUtil.JAVA_SPEC <= 8 ? "sun.misc." : "java.lang.reflect.";
                generateProxyMethod = ReflectionUtil.lookupMethod(Class.forName(packageName + "ProxyGenerator"), (String)"generateProxyClass", (Class[])new Class[]{String.class, Class[].class});
            }
            return (byte[])generateProxyMethod.invoke(null, name, interfaces);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static byte[] generateProxyClass14(String name, Class<?>[] interfaces, ClassLoader loader) {
        assert (JavaVersionUtil.JAVA_SPEC >= 14);
        try {
            if (generateProxyMethod == null) {
                generateProxyMethod = ReflectionUtil.lookupMethod(Class.forName("java.lang.reflect.ProxyGenerator"), (String)"generateProxyClass", (Class[])new Class[]{ClassLoader.class, String.class, List.class, Integer.TYPE});
            }
            ArrayList ilist = new ArrayList(Arrays.asList(interfaces));
            return (byte[])generateProxyMethod.invoke(null, loader, name, ilist, 49);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    synchronized Class<?> getProxyClass(Executable member) {
        Class proxyClass = this.proxyMap.get(member);
        if (proxyClass == null) {
            ClassLoader loader = this.imageClassLoader.getClassLoader();
            String name = ReflectionSubstitution.getStableProxyName(member) + PROXY_NAME_SEPARATOR + proxyNr.incrementAndGet();
            Class[] ifaces = member instanceof Method && !Modifier.isStatic(member.getModifiers()) && !Modifier.isAbstract(member.getModifiers()) ? new Class[]{ReflectionSubstitution.getAccessorInterface(member), ReflectionProxy.class, InvokeSpecialReflectionProxy.class} : new Class[]{ReflectionSubstitution.getAccessorInterface(member), ReflectionProxy.class};
            byte[] proxyBC = JavaVersionUtil.JAVA_SPEC < 14 ? ReflectionSubstitution.generateProxyClass(name, ifaces) : ReflectionSubstitution.generateProxyClass14(name, ifaces, loader);
            try {
                proxyClass = (Class)this.defineClass.invoke((Object)loader, name, proxyBC, 0, proxyBC.length);
                this.resolveClass.invoke((Object)loader, proxyClass);
                this.proxyMap.put(member, proxyClass);
                ResolvedJavaType type = this.metaAccess.lookupJavaType(proxyClass);
                this.typeToMember.put(type, member);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
        this.classInitializationSupport.forceInitializeHosted(proxyClass, "all proxy classes are initialized", false);
        return proxyClass;
    }

    private boolean isReflectionProxy(ResolvedJavaType type) {
        return this.reflectionProxy.isAssignableFrom(type) && this.javaLangReflectProxy.isAssignableFrom(type);
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (this.isReflectionProxy(type)) {
            return this.getSubstitution(type);
        }
        return type;
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        ReflectionSubstitutionType declaringClass;
        ReflectionSubstitutionType.ReflectionSubstitutionMethod result;
        if (this.isReflectionProxy(method.getDeclaringClass()) && (result = (ReflectionSubstitutionType.ReflectionSubstitutionMethod)(declaringClass = this.getSubstitution(method.getDeclaringClass())).getSubstitutionMethod(method)) != null) {
            return result;
        }
        return method;
    }

    public ResolvedJavaType resolve(ResolvedJavaType type) {
        if (type instanceof ReflectionSubstitutionType) {
            return ((ReflectionSubstitutionType)type).getOriginal();
        }
        return type;
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        if (method instanceof ReflectionSubstitutionType.ReflectionSubstitutionMethod) {
            return ((ReflectionSubstitutionType.ReflectionSubstitutionMethod)method).getOriginal();
        }
        return method;
    }

    private synchronized ReflectionSubstitutionType getSubstitution(ResolvedJavaType proxyClass) {
        ReflectionSubstitutionType subst = (ReflectionSubstitutionType)this.getSubstitutionType(proxyClass);
        if (subst == null) {
            Executable member = this.typeToMember.get(proxyClass);
            subst = ((ReflectionSubstitutionType.Factory)ImageSingletons.lookup(ReflectionSubstitutionType.Factory.class)).create(proxyClass, member);
            this.addSubstitutionType(proxyClass, subst);
        }
        return subst;
    }
}

